<div class="private-messages-wrapper wpj-messenger" data-uid="<?php echo $interlocutor_id; ?>">

	<!-- List -->
	<aside class="thread-list-body">
		<header class="thread-list-header">

			<!-- Buttons -->
			<div class="thread-buttons-header">
				<a class="icon-button icon-button-simple icon-button-dense pm-nav-btn pm-nav-search cursor-pointer js-search-users-btn">
					<i class="search icon search-messages"></i>
				</a>

				<a class="icon-button icon-button-simple icon-button-dense <?php echo $type !== 'archived' ? 'icon-button-secondary' : ''; ?> pm-nav-btn pm-nav-inbox" href="<?php echo wpj_get_pm_link(); ?>">
					<i class="envelope outline icon inbox-messages"></i>
				</a>

				<a class="icon-button icon-button-simple icon-button-dense <?php echo $type === 'archived' ? 'icon-button-secondary' : ''; ?> pm-nav-btn pm-nav-archive" href="<?php echo wpj_get_pm_link(); ?>?type=archived">
					<i class="archive icon archived-messages"></i>
				</a>
			</div>

		</header>

		<?php wpj_display_users_conversation_list( $type ); ?>

	</aside>

	<!-- Thread -->
	<div class="thread-body">
		<div class="thread-body-content">

			<?php if ( $interlocutor_id ) { ?>

				<!-- Search form -->
				<?php wpj_display_search_message_form(); ?>

				<header class="thread-header">

					<!-- Avatar -->
					<div class="message-user-avatar">

						<?php wpj_display_user_photo( array( 'uid' => $interlocutor_id, 'width' => 40, 'height' => 40, 'with_level_image' => false ) );

						wpj_display_user_status_icon( $interlocutor_id, 'yes_with_icon' ); ?>

					</div>

					<!-- Title -->
					<div class="conversation-title">

						<h2 class="overflow-ellipsis">
							<a href="<?php echo wpj_get_user_profile_link( $interlocutor_id ); ?>"><?php echo $interlocutor_username; ?></a>
						</h2>

						<span>

							<?php echo sprintf( __( 'Last seen: %s', 'wpjobster' ), ( $interlocutor_data ? wpj_get_last_visit( $interlocutor_id ) : __( 'Unknown', 'wpjobster' ) ) ); ?>

						</span>

					</div>

					<div class="actions">

						<!-- Search icon -->
						<a class="icon-button icon-button-light cursor-pointer js-search-message-btn mr5">
							<i class="search icon"></i>
						</a>

						<!-- Settings -->
						<div class="conversation-settings">

							<?php wpj_display_message_settings_options(); ?>

						</div>

						<!-- Custom Offer -->
						<div class="conversation-custom-offer">

							<?php wpj_display_custom_offer_button( array(
								'unique_id'       => 'pm_send_' . $interlocutor_id,
								'id'              => $interlocutor_id,
								'title'           => __( 'Send Custom Offer', 'wpjobster' ),
								'offer_type'      => 'send',
								'current_user_id' => $current_user_id,
								'post_author_id'  => $interlocutor_id,
								'page'            => 'private_messages',
								'label_type'      => 'both'
							) ); ?>

						</div>

					</div>
					
				</header>

				<!-- Messages -->
				<div class="thread-wrapper">
					<div class="thread-viewport js-messages-list">
						<div class="thread-content">

							<?php wpj_display_messages_list([
								'user1'        => $current_user_id,
								'user2'        => $interlocutor_id,
								'message_type' => 'all'
							]); ?>

						</div>
					</div>
				</div>

				<?php wpj_display_send_message_form();

			} else { // if no user in url address ?>

				<div class="flex-center-container center">
					<div class="thread-empty">

						<i class="huge comments outline icon"></i>

						<?php if ( wpj_get_conversations_by_type( $type ) ) { ?>

							<h2><?php _e( "Select a conversation from the list", "wpjobster" ); ?></h2>

						<?php } else { ?>

							<h2><?php _e( "Nothing to see here yet", "wpjobster" ); ?></h2>

						<?php } ?>

						<p><?php _e( "Your messages will appear here.", "wpjobster" ); ?></p>

					</div>
				</div>

			<?php } ?>

		</div>
	</div><!-- END thread -->
</div><!-- END messenger -->