<div class="order-wrapper">

	<?php if ( isset( $order->id ) && is_user_logged_in() && ( get_current_user_id() == $order->uid || get_current_user_id() == wpj_get_seller_id( $order ) || is_super_admin() ) ) { ?>

		<!-- TIMER -->
		<?php wpj_display_order_timer( $order ); ?>

		<!-- BANK DETAILS -->
		<?php if ( $order->payment_status == 'pending' && $order->payment_gateway == 'banktransfer' ) { ?>

			<div class="order-box-wrapper bank-details-row-wrapper">

				<div class="order-box-content p20">

					<p><strong><?php _e( 'Bank Details', 'wpjobster' ); ?>:</strong></p>

					<p><?php wpj_display_bank_details(); ?></p>

				</div>

			</div>

		<?php } ?>

		<!-- ORDER INFO -->
		<div class="order-box-wrapper js-order-main-info">

			<div class="order-box-header new">

				<div class="icon"><img src="<?php echo get_template_directory_uri() . '/assets/images/notification/svg/new-order-white.svg'; ?>" alt="New Order"></div>

				<div class="content">

					<!-- ORDER NUMBER -->
					<h3>

						<?php echo sprintf( __( "Order: <strong>#%s</strong>", 'wpjobster' ), wpj_camouflage_oid( $order->id, $order->date_made ) ); ?>

					</h3>

					<!-- ORDER DATE -->
					<div class="order-date">

						<?php wpj_display_order_date_made( $order ); ?>

					</div>

				</div>

				<?php // BUTTONS
				wpj_display_order_action_buttons( array(
					'order'                 => $order,
					'wrapper_class'         => 'order-header-action-buttons-wrapper',
					'buttons_wrapper_class' => 'div-end-flex',
					'buttons_only'          => true,
					'button_accept_class'   => 'text-button text-button-confirmation',
					'button_deny_class'     => 'text-button text-button-simple-on-dark',
					'button_abort_class'    => 'text-button text-button-negative',
					'button1_order'         => 2,
					'button2_order'         => 1
				) ); ?>

			</div>

			<div class="order-box-content">

				<div class="order-content-header">

					<!-- IMAGE -->
					<?php if ( ! $offer_class ) { ?>

						<div class="avatar"><?php wpj_display_round_job_image( $order->pid, 90, 90, $order->id ); ?></div>

					<?php } ?>

					<div class="order-content-main">

						<!-- TITLE -->
						<?php wpj_display_title( array( 'pid' => $order->pid, 'link' => get_permalink( $order->pid ) ) ); ?>

						<div class="order-info-wrapper">

							<!-- ORDER NUMBER -->
							<?php echo sprintf( __( "Order: <strong>#%s</strong>", 'wpjobster' ), wpj_camouflage_oid( $order->id, $order->date_made ) ); ?>

							&nbsp;&nbsp;|&nbsp;&nbsp;

							<!-- ORDER STATUS -->
							<?php echo wpj_get_order_status( $order->id ); ?>

							&nbsp;&nbsp;|&nbsp;&nbsp;

							<!-- BUYER / SELLER NAME -->
							<?php if ( get_current_user_id() == wpj_get_seller_id( $order ) ) {
								echo sprintf( __( 'Buyer: %s', 'wpjobster' ), '<a href="' . wpj_get_user_profile_link( $buyer_name ) . '">' . $buyer_name . '</a>' );

							} else {
								echo sprintf( __( 'Seller: %s', 'wpjobster' ), '<a href="' . wpj_get_user_profile_link( $seller_name ) . '">' . $seller_name . '</a>' );

							} ?>

						</div>

					</div>

					<div class="order-content-price">

						<?php wpj_display_order_job_price( $order->id ); ?>

					</div>

				</div>

				<ul class="order-extras">

					<!-- EXTRA FAST DELIVERY -->
					<?php if ( $order->extra_fast != 0 && $order->extra_fast_price ) { ?>

						<li>

							<div class="cp-price-extra">

								<?php if ( $order->extra_fast > 1 ) { ?>

									<span class="amount-nr">

										<?php echo $order->extra_fast; ?>

										<span class="x-sign"> x </span>

									</span>

								<?php }

								echo wpj_show_price_classic( $order->extra_fast_price, 1 ); ?>

							</div>

							<div class="cp-title-extra"><?php _e( 'Extra fast delivery', 'wpjobster' ); ?></div>

						</li>

					<?php } ?>

					<!-- EXTRA REVISION -->
					<?php if ( $order->extra_revision != 0 && $order->extra_revision_price ) { ?>

						<li>

							<div class="cp-price-extra">

								<?php if ( $order->extra_revision > 1 ) { ?>

									<span class="amount-nr">

										<?php echo $order->extra_revision; ?>

										<span class="x-sign"> x </span>

									</span>

								<?php }

								echo wpj_show_price_classic( $order->extra_revision_price, 1 ); ?>

							</div>

							<div class="cp-title-extra"><?php _e( 'Extra revision', 'wpjobster' ); ?></div>

						</li>

					<?php }

					// EXTRAS
					for ( $n = 1; $n <= 10; $n++ ) {

						$extra_content = get_post_meta( $order->pid, 'extra' . $n . '_content', true );
						$extra_content = wpj_apply_filter_to_string( $extra_content, false, 'transactionpages' );

						if ( $order->{'extra' . $n} != 0 ) {

							if ( $order->{'extra' . $n . '_price'} ) { ?>

								<li>

									<div class="cp-price-extra">

										<?php if ( $order->{'extra' . $n} > 1 ) { ?>

											<span class="amount-nr">

												<?php echo $order->{'extra' . $n}; ?>

												<span class="x-sign"> x </span>

											</span>

										<?php }

										echo wpj_show_price_classic( $order->{'extra' . $n . '_price'}, 1 ); ?>

									</div>

									<div class="cp-title-extra"><?php echo $order->{'extra' . $n . '_title'}; ?></div>

								</li>

							<?php } elseif ( get_post_meta( $order->pid, 'extra' . $n . '_content', true ) ) { ?>

								<li><div class="cp-title-extra"><?php echo $extra_content; ?></div></li>

							<?php }

						}

					}

					// CUSTOM EXTRAS
					wpj_display_order_custom_extras_list( $order );

					// TIPS
					wpj_display_order_tips_list( $order );

					// ACTION
					do_action( 'wpj_before_shipping_price', $order->pid, 'order', $order );

					// SHIPPING
					if ( ! empty( get_post_meta( $order->pid, 'shipping', true ) ) ) { ?>

						<li>
							<div class="cp-price-extra"><?php echo wpj_show_price_classic( get_post_meta( $order->pid, 'shipping', true ), 1 ); ?></div>
							<div class="cp-title-extra"><?php _e( "Shipping:", "wpjobster" ); ?></div>
						</li>

					<?php }

					// PROCESSING FEES
					if ( apply_filters( 'wpj_order_processing_fees_price_filter', $order->processing_fees, $order ) > 0 ) { ?>

						<li>
							<div class="cp-price-extra"><?php echo wpj_show_price_classic( apply_filters( 'wpj_order_processing_fees_price_filter', $order->processing_fees, $order ), 1 ); ?></div>
							<div class="cp-title-extra"><?php _e( "Processing fees:", "wpjobster" ); ?></div>
						</li>

					<?php }

					// ACTION
					do_action( 'wpj_before_tax_price', $order->pid, 'order', $order );

					// TAX
					if ( apply_filters( 'wpj_order_tax_price_filter', $order->tax_amount, $order ) > 0 ) { ?>

						<li>
							<div class="cp-price-extra"><?php echo wpj_show_price_classic( apply_filters( 'wpj_order_tax_price_filter', $order->tax_amount, $order ), 1 ); ?></div>
							<div class="cp-title-extra"><?php _e( "Tax:", "wpjobster" ); ?></div>
						</li>

					<?php }

					// ACTION
					do_action( 'wpj_after_tax_price', $order->pid, 'order', $order ); ?>

				</ul>

				<!-- TOTAL -->
				<div class="order-total-price">
					<?php echo sprintf( __( "Total: <span>%s</span>", "wpjobster" ), wpj_show_price_classic( apply_filters( 'wpj_order_total_price_filter', wpj_get_order_total_price( $order )['total'], $order, 'order_page' ), 1 ) ); ?>
				</div>

				<?php // INSTRUCTIONS FOR BUYER
				if ( $order->job_instructions || get_post_meta( $order->pid, "instruction_box", true ) ) { ?>

					<div class="order-instructions">

						<h3><?php _e( "Instructions for the buyer:", "wpjobster" ); ?></h3>
						<?php wpj_display_order_buyer_instructions( $order ); ?>

					</div>

				<?php }

				// INSTANT DELIVERY FILES
				wpj_display_order_instant_delivery_files( $order );

				// CUSTOM OFFER DESCRIPTION
				if ( wpj_is_custom_offer( $order->pid ) && $order->job_description ) { ?>

					<div class="order-instructions">

						<h3><?php _e( "Custom offer description:", "wpjobster" ); ?></h3>
						<?php echo wpj_display_order_custom_offer_description( $order ); ?>

					</div>

				<?php }

				// CUSTOM FIELD
				wpj_display_order_custom_fields( $order ); ?>

			</div>

		</div>

		<!-- PENDING ORDER -->
		<?php if ( $order->payment_status == 'pending' ) { ?>

			<div class="order-box-wrapper pending-order-wrapper js-pending-order-wrapper">
				<div class="order-box-header orange">

					<div class="icon">

						<img width="50" height="50" src="<?php echo get_template_directory_uri() . '/assets/images/notification/svg/payment-white.svg'; ?>" />

					</div>

					<div class="content">

						<!-- ORDER NUMBER -->
						<h3>

							<?php echo wpj_get_order_status( $order->id, false ); ?>

						</h3>

						<!-- ORDER DATE -->
						<div class="order-date">

							<?php wpj_display_order_date_made( $order ); ?>

						</div>

					</div>

				</div>

				<div class="order-box-content">

					<div>

						<p><?php echo sprintf( __( 'Method: %s', 'wpjobster' ), wpj_translate_string( $order->payment_gateway ) ); ?></p>

						<?php if ( get_current_user_id() != wpj_get_seller_id( $order ) ) { ?>

							<p><?php _e( 'The transaction will start as soon as you complete the payment process.', 'wpjobster' ); ?></p>

							<div class="job-order-bt-proof-row-wrapper">

								<?php wpj_display_bank_job_payment_proof( $order ); ?>

							</div>

						<?php } else { ?>

							<p><?php _e( 'The transaction will start as soon as the buyer pays.', 'wpjobster' ); ?></p>

						<?php } ?>

					</div>

				</div>
			</div>

		<?php } elseif ( in_array( $order->payment_status, array( 'failed', 'processing', 'expired' ) ) ) { ?>

			<p><?php echo wpj_get_order_status( $order->id, false ); ?></p>
			<p><?php echo sprintf( __( 'Method: %s', 'wpjobster' ), wpj_translate_string( $order->payment_gateway ) ); ?></p>

		<?php } ?>

		<!-- COD -->
		<?php if ( strtoupper( $order->payment_gateway ) == strtoupper( 'cod' ) && get_current_user_id() == wpj_get_seller_id( $order ) ) { ?>

			<div class="order-box-wrapper">

				<div class="order-box-header orange">

					<div class="icon">

						<img width="50" height="50" src="<?php echo get_template_directory_uri() . '/assets/images/notification/svg/cash-white.svg'; ?>" />

					</div>

					<div class="content">

						<h3>
							<?php _e( "Payment method: Cash on Delivery", "wpjobster" ); ?>
						</h3>

						<div class="order-date">
							<!-- ORDER DATE -->
							<?php wpj_display_order_date_made( $order ); ?>
						</div>

					</div>

				</div>

				<div class="order-box-content">

					<?php _e( "Since the payment has not been secured by the platform, please make sure you have collected the payment from the buyer, before marking this transaction as delivered.", "wpjobster" );  ?>

				</div>
			</div>

		<?php } ?>

		<!-- CANCELLED ORDER -->
		<div class="cancelled-order-wrapper js-cancelled-order-wrapper">

			<?php if ( $order->payment_status == 'cancelled' ) { ?>

				<div class="order-box-wrapper">

					<div class="order-box-header red">

						<div class="icon">

							<img width="50" height="50" src="<?php echo get_template_directory_uri() . '/assets/images/notification/svg/declined-white.svg'; ?>" />

						</div>

						<div class="content">

							<h3>
								<?php echo wpj_get_order_cancellation_message( $order, 'message' ); ?>
							</h3>

							<div class="order-date">
								<!-- ORDER DATE -->
								<?php wpj_display_order_date_made( $order ); ?>
							</div>

						</div>

					</div>

					<div class="order-box-content">
						<?php do_action( 'wpj_after_gateway_transaction_cancelled_message', $order->id, 'job_purchase'  );

						if ( wpj_get_order_cancellation_message( $order, 'reason' ) ) { ?>

							<div><?php echo sprintf( __( 'Reason: %s', 'wpjobster' ), wpj_get_order_cancellation_message( $order, 'reason' ) ); ?></div>

						<?php } ?>

						<div><?php echo sprintf( __( 'Method: %s', 'wpjobster' ), wpj_translate_string( $order->payment_gateway ) ); ?></div>

						<?php if ( strtolower( $order->payment_gateway ) == 'paypal' ) { ?>

							<div><i><?php echo sprintf( __( 'If you didn\'t cancel your order and still view the order as canceled, wait a few minutes until we receive the response from %s and mark the order as paid.', 'wpjobster' ), wpj_translate_string( $order->payment_gateway ) ); ?></i></div>

						<?php } ?>
					</div>
				</div>

			<?php } ?>

		</div>

		<?php // NOTIFICATIONS
		wpj_display_order_notification_messages( $order );

		// RATING
		wpj_display_order_feedback_form( $order );

		// MESSAGE FORM
		wpj_display_order_message_form( $order );

	} else {

		wpj_display_transaction_not_allowed_notice();

	} ?>

</div>