<div class="order-wrapper">

	<div class="order-box-wrapper js-order-main-info">

		<div class="order-box-header new">

			<div class="icon"><img src="<?php echo get_template_directory_uri() . '/assets/images/notification/svg/new-order-white.svg'; ?>" alt="New Order"></div>

			<div class="content">

				<h3>
					<?php echo sprintf( __( "Transaction #%s%s", "wpjobster" ), wpj_camouflage_oid( $orderid, $date_made ), ( $order_status_class ? '<span class="title-status ' . $order_status_class . '"> (' . $order_status_lbl . ')</span>' : '' ) ); ?>
				</h3>

				<div class="order-date">
					<?php echo $order_status_lbl; ?>
				</div>

			</div>

			<?php if ( current_user_can( 'manage_options' ) || get_current_user_id() == $uid ) {

				if ( $order_status_class == 'pending' ) { ?>

					<div class="order-header-action-buttons-wrapper">

						<button class="text-button text-button-simple-on-dark" onclick="take_to_gateway_topup_process( 'cancel', '<?php echo $order->id;?>', '<?php echo $order->payment_gateway_name;?>', '<?php echo $order->package_id; ?>' );">

						<?php _e( 'Cancel', 'wpjobster' ); ?>

						</button>

						<?php if ( $order->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $order->payment_gateway_name ) ) { ?>

							<button class="text-button text-button-confirmation" onclick="take_to_gateway_topup_process( 'process', '<?php echo $order->id; ?>', '<?php echo $order->payment_gateway_name; ?>', '<?php echo $order->package_id; ?>' );">

								<?php _e( 'Process', 'wpjobster' ); ?>

							</button>

						<?php } ?>

					</div>

				<?php }

				} ?>

		</div>

		<div class="order-box-content">

			<?php if ( current_user_can( 'manage_options' ) || get_current_user_id() == $uid ) {

				if ( ! empty( $order ) && $order->payment_status == 'pending' && $order->payment_gateway_name == 'banktransfer' ) {

					if ( $show_bank_details ) { ?>

						<div class="meta-columns-wrapper">

							<div class="meta-column">
								<div class="label-class"><?php _e( 'Bank Details', 'wpjobster' ); ?>:</div>
								<div class="value-class"><?php wpj_display_bank_details(); ?></div>
							</div>

						</div>

					<?php }

				} ?>

				<div class="js-pending-order-wrapper">

					<div class="meta-columns-wrapper">

						<div class="meta-column">
							<div class="label-class"><?php _e( 'Method', 'wpjobster' ); ?>:</div>
							<div class="value-class"><?php echo $payment_method; ?></div>
						</div>

					</div>

					<?php if ( $order_status_desc ) { ?><p class="highlighted-message"><?php echo $order_status_desc; ?></p><?php } ?>

				</div>

			<?php }

			wpj_display_topup_notices(); ?>

		</div>
	
	</div>

</div>