<div class="checkout-wrapper" data-currency="<?php echo strtoupper( wpj_get_site_currency() ); ?>">

	<?php if ( ! empty( $_POST ) ) { ?>

		<!-- Title Bar -->
		<div class="ui two column stackable grid mb5">

			<!-- Page Title -->
			<div class="twelve wide column checkout-page-title">

				<?php wpj_display_title( array( 'title' => __( 'Review and Choose Payment Method', 'wpjobster' ) ) ); ?>

			</div>

			<!-- Currency Switcher -->
			<div class="four wide column right aligned currency-switcher">

				<?php wpj_display_currency_selector_with_POST(); ?>

			</div>

		</div>

		<!-- Payment Instructions -->
		<?php wpj_display_payment_general_instructions();

		do_action( 'wpj_after_checkout_title', $post->post_author, $payment_type ); ?>

		<!-- Custom Fields -->
		<?php $Custom_Fields->displayFieldsContent( 'checkout' ); ?>

		<div class="wpj-bordered-container no-padding">

			<div class="ui segment no-box-shadow checkout-padding">

				<div class="wpj-checkout-header">

					<?php do_action( 'wpj_before_checkout_job_info', $pid ); ?>

					<!-- Job Image -->
					<div class="checkout-header-avatar">

						<?php wpj_display_round_job_image( $pid, 90, 90 ); ?>

					</div>

					<div class="checkout-header-content">

						<!-- Job Title -->
						<div class="title-wrapper">

							<?php if ( wpj_is_custom_offer( $pid ) ) {

								wpj_display_title( array( 'title' => wpj_get_custom_offer_title( $pid, $post->post_author ), 'title_class' => 'job-title-purchase' ) );

							} else {

								wpj_display_title( array( 'link' => get_permalink( $pid ), 'title_class' => 'job-title-purchase' ) );

							} ?>

						</div>

						<!-- Job Category -->
						<div class="category-wrapper">

							<?php wpj_display_post_category_and_subcategory(); ?>

						</div>

					</div>

					<!-- Job Price -->
					<div class="checkout-header-price">

						<?php wpj_display_job_order_price( $pid, 'text-right' ); ?>

					</div>

				</div>

				<div class="checkout-contents">

					<?php wpj_display_job_order_details_form( $pid, 'checkout' ); ?>
					
				</div>

			</div>
				
			<div class="payment-buttons-bar-wrapper">

				<div class="payment-buttons-bar">

					<div class="left-content">

						<?php wpj_display_payment_buttons( $payment_type ); ?>

					</div>

					<div class="payment-total-price">

							<?php _e( 'Total: ', 'wpjobster' ); wpj_display_job_order_total_price( $payment_type ); ?>

					</div>

				</div>

			</div>

		</div>

		<!-- Secure shopping banner -->
		<div class="checkout-secure-banner">

			<?php wpj_display_secure_shopping_banner(); ?>

		</div>

	<?php } else {

		wpj_display_checkout_not_allowed_notice();

	} ?>

</div>

<div class="ui hidden divider"></div>