<?php wpj_display_user_graph( 'sales' ); ?>

<div class="user-dashboard-wrapper">

	<?php wpj_display_user_sidebar( get_current_user_id() ); ?>

	<div class="checkout-wrapper feature-checkout-wrapper user-dashboard-page" data-currency="<?php echo wpj_get_site_currency(); ?>">

	<!-- Title -->
	<div class="mb20">

		<?php wpj_display_title( array( 'title' => __( 'Feature Job', 'wpjobster' ) ) ); ?>

	</div>

	<!-- Notice -->
	<?php wpj_display_featured_notices();

	if ( wpj_get_option( 'wpjobster_featured_enable' ) == 'yes' && wpj_featured_category_enabled_exist() ) { ?>

		<!-- Feature Form -->
		<form class="ui form" action="<?php echo get_bloginfo( 'url' ); ?>" method="get">

			<div class="wpj-bordered-container no-padding">

				<div class="ui segment">

					<?php do_action( 'wpj_before_feature_page_content', $pid ); ?>

					<div class="ui two column stackable middle aligned grid js-feature-content">

						<!-- Job Image -->
						<div class="two wide column image-wrapper">

							<?php wpj_display_round_job_image(); ?>

						</div>

						<div class="fourteen wide column">

							<!-- Job Title -->
							<div class="post-title-wrapper">

								<?php wpj_display_title( array( 'link' => get_permalink( $pid ), 'title_class' => 'job-title-purchase' ) ); ?>

							</div>

							<!-- Job Category and Subcategory -->
							<div class="post-category-wrapper">

								<?php wpj_display_post_category_and_subcategory( $pid ); ?>

							</div>

						</div>

						<div class="ui fitted divider"></div>

						<div class="sixteen wide column">

							<?php _e( "Select the pages where your job will be featured:", 'wpjobster' ); ?>

						</div>

						<div class="ui fitted divider"></div>

						<!-- HOMEPAGE -->
						<?php if ( wpj_get_option( 'wpjobster_homepage_featured_enable' ) != 'no' ) { ?>

							<div class="sixteen wide column">

								<?php wpj_display_featured_homepage_row(); ?>

							</div>

							<div class="ui fitted divider"></div>

						<?php } ?>
						<!-- END HOMEPAGE -->

						<!-- CATEGORY -->
						<?php if ( wpj_get_option( 'wpjobster_category_featured_enable' ) != 'no' ) { ?>

							<div class="sixteen wide column">

								<?php wpj_display_featured_category_row(); ?>

							</div>

							<div class="ui fitted divider"></div>

						<?php } ?>
						<!-- END CATEGORY -->

						<!-- SUBCATEGORY -->
						<?php if ( wpj_get_option( 'wpjobster_subcategory_featured_enable' ) != 'no' ) { ?>

							<div class="sixteen wide column">

								<?php wpj_display_featured_subcategory_row(); ?>

							</div>

							<?php if ( wpj_is_featured_available( $pid ) ) { ?>

								<div class="ui fitted divider"></div>

							<?php }

						} ?>
						<!-- END SUBCATEGORY -->

						<!-- FEES -->
						<?php if ( wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) != 'disabled' && wpj_is_featured_available( $pid ) ) { ?>

							<div class="sixteen wide column">

								<div class="processing-fees-title">

									<?php if ( wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) == 'percent' )
										echo sprintf( __( 'Processing Fees (%s%s):', 'wpjobster' ), wpj_get_site_processing_fees_percent(), '&#37;' );

									else
										_e( 'Processing Fees:', 'wpjobster' ); ?>

									<span class="right"><?php wpj_display_buyer_processing_fees(); ?></span>

								</div>

							</div>

							<div class="ui fitted divider"></div>

						<?php }

						if ( wpj_get_option( 'wpjobster_enable_site_tax' ) == 'yes' && wpj_is_featured_available( $pid ) ) { ?>

							<div class="sixteen wide column">

								<?php echo sprintf( __( 'Tax (%s%s):', 'wpjobster' ), wpj_get_site_tax_percent(), '&#37;' ); ?>

								<span class="right"><?php wpj_display_buyer_tax(); ?></span>

							</div>

						<?php } ?>
						<!-- END FEES -->

					</div><!-- END <div class="ui two column stackable grid"> -->

				</div>

				<!-- Buy feature job buttons -->
				<div class="payment-buttons-bar-wrapper">

					<div class="payment-buttons-bar">

						<?php if ( wpj_is_featured_available( $pid ) ) { ?>

							<!-- Buttons -->
							<div class="left-content">

								<?php wpj_display_payment_buttons( 'featured' ); ?>

							</div>

							<!-- Action 'wpj_after_feature_payment_buttons' -->
							<?php do_action( 'wpj_after_feature_payment_buttons' ); ?>

							<!-- Total price -->
							<div class="payment-total-price" >

								<?php _e( 'Total: ','wpjobster' ); wpj_display_job_order_total_price( 'featured' ); ?>

							</div>

						<?php } ?>

					</div>

				</div>

			</div><!-- END <div class="ui segment"> -->

		</form><!-- END form -->

	<?php } ?>

	</div>

</div>
