<?php wpj_init_export_user_transactions_modal();

wpj_display_user_graph( 'shopping' ); ?>

<div class="user-dashboard-wrapper">

	<?php wpj_display_user_sidebar( get_current_user_id() ); ?>

	<div class="user-payments-wrapper pr user-dashboard-page" data-currency="<?php echo strtoupper( $currency );  ?>">

		<!-- Title -->
		<div class="user-payments-header">

			<?php wpj_display_title( array( 'title' => __( 'My Payments', 'wpjobster' ) ) ); ?>

			<div class="user-payments-boxes">

				<?php if ( wpj_get_option( 'wpjobster_enable_user_transactions_export' ) != 'no' ) { ?>

					<div class="export-transactions-wrapper cursor-pointer js-export-user-transactions-link">

						<?php _e( 'Export', 'wpjobster' ); ?>

						<div class="balance-value"><?php _e( 'Transactions', 'wpjobster' ); ?></div>

					</div>

				<?php } ?>

				<div class="current-balance-wrapper">

					<?php _e( 'Current Balance', 'wpjobster' ); ?>

					<div class="balance-value"><?php echo wpj_show_price( wpj_get_user_credit( $uid ) ); ?></div>

				</div>

			</div>

		</div>

		<div class="payments-tabs-wrapper">

			<?php // Filter buttons
			wpj_display_filter_buttons( 'user_payments' );

			// Page content
			foreach ( $tabs as $pg => $tab_info ) {

				if ( $pg == 'payments' ) { // PAYMENTS TAB ?>

					<div class="ui tab <?php if ( $active_tab == $pg ) { echo 'active'; } ?>" data-tab="payments">

						<div class="pending-withdrawals">

							<div class="pending-payments-title">

								<h2><?php _e( 'Pending Withdrawals', 'wpjobster' ); ?></h2>

							</div>

							<?php wpj_display_pending_withdrawals_list(); ?>

						</div>

						<div class="ui hidden divider"></div>

						<div class="pending-payments">

							<div class="pending-payments-title">

								<h2><?php _e( 'Pending Incoming Payments', 'wpjobster' ); ?></h2>

							</div>

							<?php wpj_display_pending_incoming_payments_list(); ?>

						</div>
							
					</div>

				<?php } elseif ( $pg == 'transactions' ) { // TRANSACTIONS TAB ?>

					<div class="ui tab <?php if ( $active_tab == 'transactions' ) { echo 'active'; } ?>" data-tab="transactions">

						<?php wpj_display_transactions_list(); ?>

					</div>

				<?php } elseif ( $pg == 'top-up' && wpj_get_option( 'wpjobster_enable_topup' ) == 'yes' ) { // TOPUP TAB

					wpj_display_no_credits_warning(); ?>

					<div class="ui tab <?php if ( $active_tab == 'top-up' ) { echo 'active'; } ?>" data-tab="top-up">

						<?php if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) { ?>

							<div class="ui pointing topup-list-menu secondary menu">
								<div class="item active title-item" data-tab="topup_pay"><?php _e( 'Top Up', 'wpjobster' ); ?></div>
								<div class="item title-item" data-tab="topup_pending"><?php _e( 'Pending', 'wpjobster' ); ?></div>
								<div class="item title-item" data-tab="topup_completed"><?php _e( 'Completed', 'wpjobster' ); ?></div>
							</div>

							<div class="ui topups topup_pay tab active" data-tab="topup_pay">

								<?php wpj_display_topup_payment_list();

								if ( count( array_filter( $topup_packages['topup_cost'] ) ) > 0 ) { ?>

									<div class="payment-buttons-wrapper">

										<div class="payment-buttons-bar">

											<!-- Buttons -->
											<div class="left-column">

												<?php wpj_display_payment_buttons( 'topup', false ); ?>

											</div>

											<!-- Action 'wpj_after_topup_payment_buttons' -->
											<?php do_action( 'wpj_after_topup_payment_buttons' ); ?>

											<!-- Total price -->
											<div class="payment-total-price" >

												<?php _e( 'Total: ','wpjobster' ); wpj_display_job_order_total_price( 'topup' ); ?>

											</div>

										</div>

									</div>

								<?php } ?>

							</div>

							<div class="ui topups topup_pending tab" data-tab="topup_pending">

								<?php wpj_display_topup_pending_list(); ?>

							</div>

							<div class="ui topups topup_completed tab" data-tab="topup_completed">

								<?php wpj_display_topup_completed_list(); ?>

							</div>

						<?php } else { _e( 'You need to enable credits to access this page!', 'wpjobster' ); } ?>

					</div>

				<?php } elseif ( $pg == 'withdraw-money' ) { // WITHDRAW TAB ?>

					<div class="ui tab <?php if ( $active_tab == 'withdraw-money' ) { echo 'active'; } ?>" data-tab="withdraw-money">

						<?php wpj_display_request_withdrawal_gateways_list(); ?>

					</div>

				<?php }

				do_action( 'wpj_after_payments_tabs_content', $pg, $active_tab );

			} ?>

		</div>

	</div>

</div>