<div class="ui basic notpadded segment">

	<?php wpj_display_title( array( 'title' => __( 'Subscriptions', 'wpjobster' ) ) ); ?>

</div>

<?php wpj_display_subscription_notices();

if ( $is_subscription_enabled == 'yes' && wpj_subscription_has_levels_defined() ) { ?>

	<div class="subscription-content">

		<?php if ( $is_subscribed == 1 ) {

			// Filter buttons
			wpj_display_filter_buttons( 'user_subscription' );

			// Subscription page content
			foreach ( $tabs as $pg => $tab_info ) { ?>

				<div class="ui tab subscription-tabs box_content <?php if ( $active_tab == $pg ) { echo 'active'; } ?>" data-tab="<?php echo $pg; ?>">

					<!-- Current subscription details -->
					<?php if ( $pg == 'current-subscription' ) {

						do_action( 'wpj_before_current_subscription_title', get_current_user_id() ); ?>

						<div class="wpj-shadow-container">

							<h2 class="heading-title heading-title-themed">

								<?php _e( 'Current Subscription', 'wpjobster' ); ?>

							</h2>

							<?php wpj_display_subscription_features_details(); ?>

						</div>

					<?php } elseif ( $pg == 'upgrade-subscription' ) {

						$subscription_form_arr['page'] = 'upgrade-subscription';
						wpj_get_template( 'pages/payment/subscription-checkout-template.php', $subscription_form_arr );

					} elseif ( $pg == 'schedule-subscription' ) {

						$subscription_form_arr['page'] = 'schedule-subscription';
						wpj_get_template( 'pages/payment/subscription-checkout-template.php', $subscription_form_arr );

					} ?>

				</div>

			<?php }

			// Current subscription schedule info
			wpj_display_subscription_schedule_details();

		} else {

			$subscription_form_arr['page'] = 'new-subscription';
			wpj_get_template( 'pages/payment/subscription-checkout-template.php', $subscription_form_arr );

		} ?>

	</div>

<?php }