<?php if ( have_posts() ) {

	while ( have_posts() ) { the_post(); ?>

		<div class="ui basic notpadded segment cf">

			<?php wpj_display_title(); ?>

		</div>

		<div class="request-wrapper single-request-wrapper mb20 wpj-bordered-container js-request-item-content-<?php echo $pid; ?>" id="request-<?php echo $pid; ?>" data-pid="<?php echo $pid; ?>">

			<div class="request-main-column">

				<div class="request-header">

					<div class="user-avatar">

						<?php wpj_display_user_photo( array( 'uid' => $post->post_author, 'width' => 90, 'height' => 90 ) ); ?>

					</div>

					<div class="user-content">

						<?php wpj_display_username_as_link( $post->post_author ); ?>

						<?php wpj_display_request_post_date( $pid ); ?>

					</div>

				</div>

				<div class="request-meta border-bottom">

					<div class="meta-column">

						<?php
							wpj_display_variable( array(
								'label' => __( 'Budget:', 'wpjobster' ),
								'value' => 'wpj_display_request_budget'
							) ); ?>

					</div>

					<div class="meta-column">

						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_delivery', __( 'Expected delivery:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_delivery_days_number'
							) ); ?>

					</div>

					<div class="meta-column">

						<?php wpj_display_variable( array(
							'label' => wpj_get_acf_field_data( 'request' ,'request_deadline', __( 'Deadline:', 'wpjobster' ) ),
							'value' => 'wpj_display_request_deadline'
						) ); ?>

					</div>

					<div class="meta-column">
						
						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_tags', __( 'Tags:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_tags'
							) ); ?>

					</div>

					<div class="meta-column">
						
						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_start_date', __( 'Start Date:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_start_date'
							) ); ?>

					</div>

					<div class="meta-column">
						
						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_end_date', __( 'End Date:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_end_date'
							) ); ?>

					</div>

				</div>

				<div class="computer-hidden mt20">

					<?php do_action( 'wpj_before_single_request_buttons', $pid, $post->post_title );

						wpj_display_request_or_offer_button( $pid );

						wpj_display_user_contact_button( $post->post_author, $pid, 'request' );

						do_action( 'wpj_after_single_request_buttons', $pid, $post->post_title );
					?>

				</div>

				<div class="request-description">

					<?php wpj_display_request_description(); ?>

					<?php wpj_display_request_custom_fields( $pid ); ?>

				</div>

				<div class="request-meta border-top">

					<div class="meta-column">

						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_location', __( 'Location:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_location'
							) ); ?>

					</div>

					<div class="meta-column">

						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_pick_up_location', __( 'Pick Up Location:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_pick_up_location'
							) ); ?>

					</div>

					<div class="meta-column">

						<?php wpj_display_variable( array(
								'label' => wpj_get_acf_field_data( 'request' ,'request_drop_off_location', __( 'Drop Off Location:', 'wpjobster' ) ),
								'value' => 'wpj_display_request_drop_off_location'
							) ); ?>

					</div>

				</div>

				<div class="request-map">

					<?php wpj_display_request_map( $pid, 'location', 'single_request' ); ?>

					<div class="ui hidden divider"></div>

					<?php wpj_display_variable( array(
						'label' => wpj_get_acf_field_data( 'request' ,'request_pick_up_location', __( 'Pick Up Location:', 'wpjobster' ) ),
						'value' => 'wpj_display_request_pick_up_location'
					) );

					wpj_display_request_map( $pid, 'pick_up_location', 'single_request' ); ?>

					<div class="ui hidden divider"></div>

					<?php wpj_display_variable( array(
						'label' => wpj_get_acf_field_data( 'request' ,'request_drop_off_location', __( 'Drop Off Location:', 'wpjobster' ) ),
						'value' => 'wpj_display_request_drop_off_location'
					) );

					wpj_display_request_map( $pid, 'drop_off_location', 'single_request' ); ?>

				</div>

				<div class="request-attachments">

					<?php wpj_display_request_attachments( $pid ); ?>

				</div>

				<?php wpj_display_request_offer_list( $pid ); ?>

			</div>

			<div class="request-sidebar mobile-hidden">

				<?php do_action( 'wpj_before_single_request_buttons', $pid, $post->post_title );

				wpj_display_request_or_offer_button( $pid );

				wpj_display_user_contact_button( $post->post_author, $pid, 'request' );
				
				do_action( 'wpj_after_single_request_buttons', $pid, $post->post_title );
				?>

			</div>

		</div><!-- END request-wrapper -->

		<?php wpj_display_variable( array(
			'label' => __( 'Posted in', 'wpjobster' ),
			'value' => 'wpj_display_request_category'
		) );

		wpj_display_request_post_date( $pid ); ?>

	<?php }

	wp_reset_query();

} ?>
