<div class="homepage-wrapper">

	<div class="ui stackable grid">

		<div class="four wide column">

			<!-- Welcome box -->
			<div class="ui segment welcome-box-wrapper">

				<div class="box-content">
					
					<?php wpj_display_user_photo( array( 'uid' => get_current_user_id(), 'width' => 78, 'height' => 78, 'with_level_image' => false, 'img_class' => 'box-avatar' ) ); ?>

					<h3 class="box-username"><?php echo sprintf( __( "Hi %s", "wpjobster" ), wpj_get_user_display_type( get_current_user_id() ) ); ?></h3>

					<p><?php _e( "Request the service you are looking for.", "wpjobster" ); ?></p>

					<div class="box-button">
						<a href="<?php echo wpj_get_new_request_link(); ?>" class="ui fluid primary button" title=""><?php _e( "Post a Request", "wpjobster" ); ?></a>
					</div>

					<?php if ( $is_seller ) { ?>

						<p><?php _e( "Post the service you offer.", "wpjobster" ); ?></p>

						<div class="box-button">
							<a href="<?php echo wpj_get_new_job_link(); ?>" class="ui fluid primary button" title=""><?php _e( "Post a Service", "wpjobster" ); ?></a>
						</div>

					<?php } ?>

				</div>

			</div>
			
			<!-- Search bar -->
			<div class="box-wrapper">

				<?php wpj_display_autosuggest_search_without_button( 'yes' ); ?>

			</div>
			
			<!-- Popular categories -->
			<div class="box-wrapper">

				<?php wpj_display_popular_categories( 'job_cat', 6, 'yes' ); ?>

			</div>

			<!-- Recently Viewed -->
			<div class="box-wrapper">

				<?php wpj_display_job_recently_viewed( get_current_user_id(), 'yes' ); ?>

			</div>

			<!-- Recently Bought -->
			<div class="box-wrapper">

				<?php wpj_display_job_recently_bought( get_current_user_id(), 'yes' ); ?>

			</div>

		</div>

		<div class="twelve wide column">

			<div class="category-icons-banner-wrapper" data-alias="logged-in-home">

				<div class="banner-content" style="background-image: url('<?php echo get_template_directory_uri() . '/assets/images/homepage/cover-banner.webp'; ?>')">

					<div class="ui middle aligned grid">

						<div class="seven wide column cibw-text">
							<span class="banner-text">

								<?php echo sprintf( __( '%s,<br>Here\'s what you need to brand your business', 'wpjobster' ), wpj_get_user_display_type( get_current_user_id() ) ); ?>

							</span>
						</div>

						<div class="eight wide column cibw-carousel">

							<?php wpj_display_category_icons_carousel(); ?>

						</div>

					</div>

				</div>
			</div>

			<div class="ui hidden divider"></div>

			<div class="ui basic notpadded segment">

				<?php wpj_display_title( array( 'title' => __( 'Recommended for you', 'wpjobster' ) ) ); ?>

			</div>

			<?php wpj_display_latest_job_posts( 3 ); ?>

		</div>

	</div>

	<div class="mb75"></div>

	<div class="ui basic notpadded segment">

		<?php wpj_display_title( array( 'title' => __( 'News & Stories', 'wpjobster' ) ) ); ?>

	</div>

	<div class="cf pr right mt-55">

		<a href="<?php echo wpj_get_option( 'wpjobster_all_news_page_id' ) ? get_permalink( wpj_get_option( 'wpjobster_all_news_page_id' ) ) : get_post_type_archive_link( 'news' ); ?>" class="ui fluid primary button">

			<?php _e( 'View all news', 'wpjobster' ); ?>

		</a>

	</div>

	<?php wpj_display_posts_carousel( 12, 'news' ); ?>

</div>