<div class="mt-40"></div>

<div class="slider-wrapper full-width-container" data-alias="home">

	<?php wpj_display_home_hero_carousel(); ?>

</div>

<div class="homepage-wrapper full-width-container">

	<div class="main-content cf">

		<!-- Explore services -->
		<div class="hiw-section hiw-section-buyer">

			<div class="hiw-graphic"><img src="<?php echo get_template_directory_uri() . '/assets/images/homepage/woman1.webp'; ?>"></div>

			<div class="hiw-content">

				<h6><?php _e( 'How does it work for buyers?', 'wpjobster' ); ?></h6>

				<h2><?php _e( 'Are you looking for a job service?', 'wpjobster' ); ?></h2>

				<div class="ui stackable two column grid">

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '1', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Find a service that you need', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Compare prices, portfolios, delivery time, and community recommendations in order to find a seller that best suits your needs. If you have a specific question, simply send them an enquiry.', 'wpjobster' ); ?></div>
					</div>

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '2', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Supply your brief', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Be as detailed as possible so the seller can provide you with the quality service that you are expecting. Your payment is held secure until you confirm that the service is performed to your satisfaction.', 'wpjobster' ); ?></div>
					</div>

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '3', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Manage transaction', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Exchange files and feedback with the seller via the built-in conversation and transaction management system. The seller will deliver service within a specified time frame.', 'wpjobster' ); ?></div>
					</div>

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '4', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Approve service delivered', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Once you are happy with the service performed, you can mark the transaction complete, and we’ll make sure that the seller gets paid. Help the community by leaving a feedback for the seller.', 'wpjobster' ); ?></div>
					</div>

				</div>

				<a href="<?php echo get_permalink( wpj_get_option( 'wpjobster_advanced_search_id' ) ); ?>" class="text-button"><?php _e( 'Explore services', 'wpjobster' ); ?></a>

			</div>
		</div>

		<!-- Explore requests -->
		<div class="hiw-section hiw-section-seller full-width-container">

			<div class="main-content cf">

				<h6><?php _e( 'How does it work for Sellers?', 'wpjobster' ); ?></h6>

				<h2><?php _e( 'Do you want to turn your knowledge, talent or hobby into income?', 'wpjobster' ); ?></h2>

				<div class="ui stackable three column grid">

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '1', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Post your service', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Compare prices, portfolios, delivery time, and community recommendations in order to find a seller that best suits your needs. If you have a specific question, simply send them an enquiry.', 'wpjobster' ); ?></div>
					</div>

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '2', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Communicate promptly', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Be as detailed as possible so the seller can provide you with the quality service that you are expecting. Your payment is held secure until you confirm that the service is performed to your satisfaction.', 'wpjobster' ); ?></div>
					</div>

					<div class="column">
						<div class="column-header">
							<div class="number"><?php _e( '3', 'wpjobster' ); ?></div>
							<div class="title"><?php _e( 'Communicate promptly', 'wpjobster' ); ?></div>
						</div>
						<div class="column-body"><?php _e( 'Be as detailed as possible so the seller can provide you with the quality service that you are expecting. Your payment is held secure until you confirm that the service is performed to your satisfaction.', 'wpjobster' ); ?></div>
					</div>

				</div>

			</div>

			<a href="<?php echo get_permalink( wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) ); ?>" class="text-button hiw-section-seller-cta"><?php _e( 'Explore requests', 'wpjobster' ); ?></a>

		</div>

		<!-- Popular services -->
		<div class="popular-services-wrapper">

			<div class="ui center aligned basic notpadded segment">

				<?php wpj_display_title( array( 'title' => __( 'Popular Services', 'wpjobster' ) ) ); ?>

			</div>

			<?php wpj_display_latest_job_posts(); ?>

		</div>

		<!-- Explore categories -->
		<div class="explore-categories-wrapper">

			<div class="ui aligned center basic notpadded segment job">

				<?php wpj_display_title( array( 'title' => __( 'Explore Categories', 'wpjobster' ) ) ); ?>

			</div>

			<!-- Table -->
			<div class="ui centered grid icon-categories-wrapper four column">

				<?php if ( $categories ) {
					foreach ( $categories as $key => $category ) {
						if ( $category->slug != 'other' ) { ?>

							<div class="column aligned centered">

								<img class="ui centered image" src="<?php echo get_template_directory_uri() . '/assets/images/homepage/' . $category->slug . '.svg'; ?>">

								<p class="category-name"><a href="<?php echo get_category_link( $category->term_id ); ?>"><?php echo $category->name; ?></a></p>

							</div>

						<?php }
					}
				} ?>

			</div>

			<div class="mb75"></div>

			<!-- Carousel -->
			<?php wpj_display_category_images_carousel(); ?>

		</div>

		<div class="mb75"></div>

		<!-- News & Stories carousel -->
		<div class="news-stories-section full-width-container">

			<div class="main-content cf">

				<div class="ui aligned center">

					<?php wpj_display_title( array( 'title' => __( 'News & Stories', 'wpjobster' ) ) ); ?>

				</div>

				<?php wpj_display_posts_carousel( 12, 'news' ); ?>

				<div class="mb75"></div>

				<div class="ui aligned center">

					<a href="<?php echo wpj_get_option( 'wpjobster_all_news_page_id' ) ? get_permalink( wpj_get_option( 'wpjobster_all_news_page_id' ) ) : get_post_type_archive_link( 'news' ); ?>" class="text-button">

						<?php _e( 'View all news', 'wpjobster' ); ?>

					</a>

				</div>

			</div>

		</div>

		<div class="ui hidden divider"></div>

		<!-- Jobs carousel -->
		<div class="jobs-images-carousel-wrapper">

			<h2><?php _e( 'Get inspired with projects made by our sellers', 'wpjobster' ); ?></h2>

			<?php wpj_display_job_simplified_carousel(); ?>

		</div>

		<!-- Sign up -->
		<div class="cta-section-wrapper">
			<div class="cta-section" style="background: url(<?php echo get_template_directory_uri() . '/assets/images/homepage/cta-background.webp'; ?>);">
				<div class="text-content">
					<h2><?php _e( 'Find the talent needed to get your business growing.', 'wpjobster' ); ?></h2>
					<a href="<?php echo esc_url( wpj_get_register_link() ); ?>" class="text-button text-button-big register-link"><?php _e( 'Get Started', 'wpjobster' ); ?></a>
				</div>

				<div class="cta-graphic">
					<img src="<?php echo get_template_directory_uri() . '/assets/images/homepage/cta-person.webp'; ?>" alt="">
				</div>
			</div>
		</div>

	</div>

</div>