<div class="landing-page-image full-width-container landing-page-image-levels">
	<div class="main-content cf">
		<div class="landing-page-content">
			<h1><?php _e( 'Levels system', 'wpjobster' ); ?></h1>

			<p><?php _e( "Climb your way through the levels system and enjoy additional benefits!", 'wpjobster' ); ?></p>
				
			<p><?php _e( "Jobster provides you with an opportunity to turn knowledge, talent, or hobby into a permanent source of income. Therefore, invest in self-promotion, keep your customers satisfied, perform quality service, and you'll be awarded with higher statuses which will open up a whole new door and opportunity for higher earnings.", 'wpjobster' ); ?></p>
		</div>
	</div>
</div>

<div class="levels-wrapper full-width-container">

	<div class="main-content cf wpj-page-section">

		<div class="level-preview">

			<div class="level-preview-avatar">

				<div class="image">

					<img src="<?php echo get_template_directory_uri() . '/assets/images/user/user-placeholder.svg'; ?>" class="user-placeholder" alt="">

				</div>

				<div class="badge">

					<img class="badge-img" src="<?php echo get_template_directory_uri() . '/assets/images/user-level/level-0-icon.png'; ?>">

				</div>

			</div>

			<div class="user-level">

				<?php _e( 'New Seller', 'wpjobster' ); ?>

			</div>

		</div>

		<!-- Level 0 - New Seller -->
		<div class="ui stackable grid new-seller-wrapper">

			<div class="six wide column level-item">

				<p class="item-title"><?php _e( 'Overview', 'wpjobster' ); ?></p>

				<p class="item-description"><?php _e( 'You start with Level 0 once you join. In order to climb up the levels system, we encourage you to work hard and play fair.', 'wpjobster' ); ?></p>

			</div>

			<div class="ten wide column level-item">

				<p class="item-title"><?php _e( 'Benefits', 'wpjobster' ); ?></p>
				<div class="ui list stackable grid">

					<?php foreach ( $level0_benefits as $key => $value ) { ?>

						<div class="item eight wide column">
							<i class="<?php echo $icon; ?> icon"></i>
							<div class="content"><?php echo $value; ?></div>
						</div>

					<?php } ?>

				</div>

			</div>
		</div>
		<!-- END Level 0 - New Seller -->

		<div class="gray-background full-width-container wpj-page-section">

			<div class="main-content cf">

				<div class="ui stackable three column grid">

						<!-- Level 1 – Rookie -->
						<div class="column">

							<div class="level-preview">

								<div class="level-preview-avatar">

									<div class="image">

										<img src="<?php echo get_template_directory_uri() . '/assets/images/user/user1.png'; ?>" alt="">

									</div>

									<div class="badge">

										<img class="badge-img" src="<?php echo get_template_directory_uri() . '/assets/images/user-level/level-1-icon.png'; ?>">

									</div>

								</div>

								<div class="user-level">

									<?php _e( 'Level 1 – Rookie', 'wpjobster' ); ?>

								</div>

							</div>

							<div class="level-item">

								<p class="item-title"><?php _e( 'Overview', 'wpjobster' ); ?></p>
								<p class="item-description"><?php _e( 'You’ve completed $50 worth of orders within the past 30 days, and you’ve kept your customers happy with a reputation of over 90%. Congratulations, you’ve just earned yourself a Rookie status!', 'wpjobster' ); ?></p>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Requirements', 'wpjobster' ); ?></p>
								<div class="ui list">
									<div class="item"><i class="<?php echo $icon; ?> icon"></i><div class="content"><?php _e( 'Earn at least $50', 'wpjobster' ); ?></div></div>
									<div class="item"><i class="<?php echo $icon; ?> icon"></i><div class="content"><?php _e( 'Maintain a 4.5 star rating over the course of 30 days ', 'wpjobster' ); ?></div></div>
								</div>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Benefits', 'wpjobster' ); ?></p>
								<div class="ui list">

									<?php foreach ( $level1_benefits as $key => $value ) { ?>

										<div class="item">
											<i class="<?php echo $icon; ?> icon"></i>
											<div class="content"><?php echo $value; ?></div>
										</div>

									<?php } ?>

								</div>

							</div>

						</div>
						<!-- END Level 1 - New Seller -->

						<!-- Level 3 – Expert -->
						<div class="column">

							<div class="level-preview">

								<div class="level-preview-avatar">

									<div class="image">

										<img src="<?php echo get_template_directory_uri() . '/assets/images/user/user2.png'; ?>" alt="">

									</div>

									<div class="badge">

										<img class="badge-img" src="<?php echo get_template_directory_uri() . '/assets/images/user-level/level-2-icon.png'; ?>">

									</div>

								</div>

								<div class="user-level">

									<?php _e( 'Level 2 – Master', 'wpjobster' ); ?>

								</div>

							</div>

							<div class="level-item">

								<p class="item-title"><?php _e( 'Overview', 'wpjobster' ); ?></p>
								<p class="item-description"><?php _e( 'After two months of diligent work, and $200 worth of sales, like any true master of his trade, you’ve kept your overall reputation at 95% or higher. Keep up the good work and it will only get better from here!', 'wpjobster' ); ?></p>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Requirements', 'wpjobster' ); ?></p>
								<div class="ui list">
									<div class="item"><i class="<?php echo $icon; ?> icon"></i><div class="content"><?php _e( 'Earn at least $200', 'wpjobster' ); ?></div></div>
									<div class="item"><i class="<?php echo $icon; ?> icon"></i><div class="content"><?php _e( 'Maintain a 4.75 star rating over the course of 60 days ', 'wpjobster' ); ?></div></div>
								</div>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Benefits', 'wpjobster' ); ?></p>
								<div class="ui list">

									<?php foreach ( $level2_benefits as $key => $value ) { ?>

										<div class="item">
											<i class="<?php echo $icon; ?> icon"></i>
											<div class="content"><?php echo $value; ?></div>
										</div>

									<?php } ?>

								</div>

							</div>

						</div>
						<!-- END Level 2 – Master -->

						<!-- Level 2 – Master -->
						<div class="column">

							<div class="level-preview">

								<div class="level-preview-avatar">

									<div class="image">

										<img src="<?php echo get_template_directory_uri() . '/assets/images/user/user3.png'; ?>" alt="">

									</div>

									<div class="badge">

										<img class="badge-img" src="<?php echo get_template_directory_uri() . '/assets/images/user-level/level-3-icon.png'; ?>">

									</div>

								</div>

								<div class="user-level">

									<?php _e( 'Level 3 – Expert', 'wpjobster' ); ?>

								</div>

							</div>

							<div class="level-item">

								<p class="item-title"><?php _e( 'Overview', 'wpjobster' ); ?></p>
								<p class="item-description"><?php _e( 'Welcome to Jobster Expert Elite! You’ve worked hard and earned the highest status. For you, Jobster has already become a serious source of income and and a full time job. Congratulations and keep up the good work!', 'wpjobster' ); ?></p>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Requirements', 'wpjobster' ); ?></p>
								<div class="ui list">
									<div class="item"><i class="<?php echo $icon; ?> icon"></i><div class="content"><?php _e( 'This is an exclusive level and will be awarded manually by our staff', 'wpjobster' ); ?></div></div>
								</div>

								<div class="ui hidden divider"></div>

								<p class="item-title"><?php _e( 'Benefits', 'wpjobster' ); ?></p>
								<div class="ui list">

									<?php foreach ( $level3_benefits as $key => $value ) { ?>

										<div class="item">
											<i class="<?php echo $icon; ?> icon"></i>
											<div class="content"><?php echo $value; ?></div>
										</div>

									<?php } ?>

								</div>

							</div>

						</div>
						<!-- END Level 3 – Expert -->

				</div>

			</div>

		</div>

	</div>

</div>

<div class="main-content cf">
	<!-- Sign up -->
	<div class="cta-section-wrapper">
		<div class="cta-section" style="background: url(<?php echo get_template_directory_uri() . '/assets/images/homepage/cta-background.webp'; ?>);">
			<div class="text-content">
				<h2><?php _e( 'What are you waiting for?', 'wpjobster' ); ?></h2>
				<a href="<?php echo esc_url( wpj_get_register_link() ); ?>" class="text-button text-button-big register-link"><?php _e( 'Get Started Now', 'wpjobster' ); ?></a>
			</div>

			<div class="cta-graphic">
				<img src="<?php echo get_template_directory_uri() . '/assets/images/landing/cta-person2.webp'; ?>" alt="">
			</div>
		</div>
	</div>
</div>
		