<?php wpj_display_user_graph( 'shopping' ); ?>

<div class="user-dashboard-wrapper">

	<?php wpj_display_user_sidebar( get_current_user_id() ); ?>

	<div class="user-dashboard-page">
		
		<!-- HEADER -->
		<div class="mb20">

			<?php wpj_display_title( array( 'title' => __( 'Settings', 'wpjobster' ) ) ); ?>

		</div>

		<div class="mt5">

			<?php wpj_display_filter_buttons( 'user_settings' ); ?>

		</div>
		
		<?php foreach ( $tabs as $pg => $tab_info ) { ?>

			<div class="ui tab wpj-bordered-container mt15 <?php if ( $active_tab == $pg ) { echo 'active'; } ?>" data-tab="<?php echo $pg; ?>">

				<form class="ui form edit-profile" method="post" enctype="multipart/form-data">

					<div class="full-width-inputs">

		<!-- ACCOUNT TAB -->
						<?php if ( $pg == 'account' ) { ?>

							<!-- Registration data -->
							<?php wpj_display_dividing_title( __( 'Registration Data', 'wpjobster' ), 'registration-data-lbl no-border' ); ?>

							<div class="two fields wrap-fix">

								<?php if ( $registration_data_fields ) {
									foreach ( $registration_data_fields as $rf_key => $rf_value ) { ?>

										<div class="field <?php echo $rf_key; ?>-field">
											<label><?php echo $rf_value['label']; ?></label>
											<input
												type="<?php echo $rf_value['inp_type']; ?>"
												value="<?php echo $rf_value['value']; ?>"
												name="<?php echo $rf_key; ?>"
												placeholder="<?php echo $rf_value['placeholder']; ?>"
												<?php echo $rf_value['atts']; ?>
											/>
										</div>

									<?php }
								} ?>

							</div>

							<!-- Address data -->
							<?php wpj_display_dividing_title( __( 'Address Data', 'wpjobster' ), 'address-data-lbl no-border' ); ?>

							<!-- Address -->
							<div class="wide field address-field">
								<label><?php _e( 'Address', 'wpjobster' ); ?></label>
								<div class="ui search js-location-autocomplete">
									<div class="ui clearable input">
										<input type="text" name="address" class="prompt" placeholder="<?php echo _x( '123 Street Name, Province', 'Placeholder for: Address', 'wpjobster' ); ?>" value="<?php echo wpj_user( $uid, 'address' ); ?>" />
										<input id="lat" type="hidden" name="lat" value="<?php echo wpj_user( $uid, 'wpj_user_latitude' ); ?>">
										<input id="long" type="hidden" name="long" value="<?php echo wpj_user( $uid, 'wpj_user_longitude' ); ?>">
									</div>
									<div class="results"></div>
								</div>
							</div>

							<div class="two fields wrap-fix">

								<?php if ( $address_data_fields ) {
									foreach ( $address_data_fields as $af_key => $af_value ) { ?>

										<div class="field <?php echo $af_key; ?>-field">
											<label><?php echo $af_value['label']; ?></label>

											<?php if ( $af_value['inp_type'] == 'select' ) { ?>

												<select class="ui search dropdown" name="<?php echo $af_key; ?>">

													<?php wpj_list_select_options( $af_value['atts'], $af_value['value'] ); ?>

												</select>

											<?php } else { ?>

												<input
													type="<?php echo $af_value['inp_type']; ?>"
													value="<?php echo $af_value['value']; ?>"
													name="<?php echo $af_key; ?>"
													placeholder="<?php echo $af_value['placeholder']; ?>"
													<?php echo $af_value['atts']; ?>
												/>

											<?php } ?>

										</div>

									<?php }
								} ?>

							</div>

						<?php } elseif ( $pg == 'social-media' && wpj_get_option( 'wpjobster_enable_user_social_media' ) == 'yes' ) { ?>

		<!-- SOCIAL MEDIA TAB -->
							<div class="two fields wrap-fix">

								<?php if ( $providers ) {
									foreach ( $providers as $key => $provider ) {
										$current_provider = ! empty( $_POST['social_media_' . $key] ) ? $_POST['social_media_' . $key] : get_user_meta( $uid, 'social_media_' . $key, true ); ?>

										<div class="field <?php echo $key; ?>-field">
											<label><?php echo $provider['name']; ?></label>
											<div class="ui labeled icon input">
												<div class="ui label">https://</div>
												<input type="text" name="social_media_<?php echo $key; ?>" value="<?php echo preg_replace( "(^https?://)", "", $current_provider ); ?>" />
												<i class="inverted circular <?php echo $provider['icon']; ?> icon"></i>
											</div>
										</div>

									<?php }
								} ?>

							</div>

						<?php } elseif ( $pg == 'security' ) { ?>

		<!-- SECURITY TAB -->
							<div class="field">
								<div class="three fields">
									<div class="field">
										<label><?php _e( "Current Password", "wpjobster" ); ?></label>
										<input type="password" value="" placeholder="<?php _e( "Current Password", "wpjobster" ); ?>" id="current_password" name="current_password" />
									</div>
									<div class="field">
										<label><?php _e( "New Password", "wpjobster" ); ?></label>
										<input type="password" value="" placeholder="<?php _e( "New Password", "wpjobster" ); ?>" id="password" name="password" />
									</div>
									<div class="field">
										<label><?php _e( "Repeat Password", "wpjobster" ); ?></label>
										<input type="password" value="" placeholder="<?php _e( "Repeat Password", "wpjobster" ); ?>" id="repeat_password" name="repeat_password" />
									</div>
								</div>
							</div>

						<?php } elseif ( $pg == 'payments' ) { ?>

		<!-- PAYMENTS TAB -->

							<?php if ( ! wpj_withdrawal_gateway_enabled_exist() ) _e( 'No withdrawal method is available on this site. Please contact the administrator.', 'wpjobster' );

							if ( wpj_is_payment_type_enabled( 'paypal', 'withdraw' ) ) { ?>

								<div id="paypal-payments" class="field paypal-payment-wrapper">
									<label><?php _e( 'PayPal Payment', 'wpjobster' ); ?></label>
									<div class="two fields">
										<div class="field">
											<input type="text" name="paypal_email" placeholder="<?php _e( 'PayPal Email', 'wpjobster' ); ?>" value="<?php echo wpj_user( $uid, 'paypal_email' ); ?>" />
										</div>
									</div>
								</div>

							<?php }

							if ( wpj_is_payment_type_enabled( 'payoneer', 'withdraw', true ) ) { ?>

								<div id="payoneer-payments" class="field">
									<label><?php _e( 'Payoneer Payment', 'wpjobster' ); ?></label>
									<div class="two fields">
										<div class="field">
											<input type="text" name="payoneer_email" placeholder="<?php _e( 'Payoneer Email', 'wpjobster' ); ?>" value="<?php echo wpj_user( $uid, 'payoneer_email' ); ?>" />
										</div>

										<div class="field">
											<input type="text" name="payoneer_card" placeholder="<?php _e( 'Payoneer Card', 'wpjobster' ); ?>" value="<?php echo wpj_user( $uid, 'payoneer_card' ); ?>" />
										</div>
									</div>
								</div>

							<?php }

							if ( wpj_is_payment_type_enabled( 'banktransfer', 'withdraw' ) ) { ?>

								<div id="bank-payments" class="field">

									<label><?php _e( 'Bank Payment', 'wpjobster' ); ?></label>

									<div class="two fields wrap-fix">

										<?php if ( $bank_fields ) {
											foreach ( $bank_fields as $bf_key => $bf_value ) {
												if ( apply_filters( 'wpj_payments_display_' . $key . '_field_filter', true ) ) { ?>

													<div class="field <?php echo $bf_key; ?>-field">

														<?php if ( $bf_value['inp_type'] == 'textarea' ) { ?>

															<textarea
																row="4"
																type="textarea"
																placeholder="<?php echo $bf_value['placeholder']; ?>"
																name="<?php echo $bf_key; ?>"
																<?php echo $bf_value['atts']; ?>
															><?php echo $bf_value['value']; ?></textarea>

														<?php } else { ?>

															<input
																type="<?php echo $bf_value['inp_type']; ?>"
																value="<?php echo $bf_value['value']; ?>"
																name="<?php echo $bf_key; ?>"
																placeholder="<?php echo $bf_value['placeholder']; ?>"
																<?php echo $bf_value['atts']; ?>
															/>

														<?php } ?>

													</div>

												<?php }
											}
										} ?>

									</div>
								</div>

							<?php }

						} elseif ( $pg == "additional-details" ) { ?>

		<!-- CUSTOM FIELDS TAB -->
							<?php if ( wpj_get_up_custom_fields_content() ) { $ji = 0;
								foreach ( wpj_get_up_custom_fields_content() as $ws_key => $fields ) {
									if ( strpos( $fields['acf_fc_layout'], 'custom_field' ) !== false ) {

										$ucf = $custom_field->getFieldsContent( $fields );

										if ( $ji == 0 ) { ?><div class="two fields"><?php } ?>

											<div class="field">

												<?php if ( $ucf['label'] != 'no' ) { ?>

													<label><?php echo $fields['label']; ?></label>

												<?php }

												echo $ucf['content']; ?>

											</div><?php $ji++;

										if ( $ji == 2 ) { ?></div><?php $ji = 0; }
									}
								}

								if ( count( wpj_get_up_custom_fields_content() ) % 2 != 0 ) { echo '</div>'; }
							}
						}

						do_action( 'wpj_after_user_settings_tabs_content', $pg, $active_tab );

						if ( $pg != 'payments' || ( $pg == 'payments' && wpj_withdrawal_gateway_enabled_exist() ) ) { ?>

							<div class="field">
								<input class="text-button save-user-settings-btn js-save-user-settings" type="submit" name="save-info" value="<?php _e( "Save Changes", 'wpjobster' ); ?>" />
							</div>

						<?php } ?>

					</div><!-- END full-width-inputs -->
				</form>

			</div><!-- END ui segment - form -->

		<?php } ?>

	</div>

</div>