<div class="ui basic notpadded segment job cf">

	<?php wpj_display_title( ['title' => sprintf( __( '%d Search Results Found For: "%s"', 'wpjobster' ), $wp_query->found_posts, get_search_query() )] ); ?>

</div>

<div class="ui stackable grid">

	<div class="row">

		<div class="four wide column">
			<div class="ui segment">
				<div class="sidebar-wrapper">

					<form method="get" class="ui form" action="<?php echo home_url( '/' ); ?>">

						<div class="field">
							<div class="ui input">
								<input type="text" size="10" placeholder="<?php _e( 'Search Term', 'wpjobster' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
							</div>
						</div>

						<?php if ( apply_filters( 'wpj_search_display_post_type_filter', true ) ) { ?>

							<div class="field">
								<select name="post_type" class="ui clearable dropdown search-post-type-field">
									<option value=""><?php _e( 'Post type', 'wpjobster' ); ?></option>

									<?php if ( apply_filters( 'wpj_search_display_post_type_post_filter', true ) ) { ?>

										<option <?php if ( WPJ_Form::get( 'post_type' ) == 'post' ) { echo 'selected="selected"'; } ?> value="post"><?php _e( 'Posts', 'wpjobster' ); ?></option>

									<?php } ?>

									<?php if ( apply_filters( 'wpj_search_display_post_type_news_filter', true ) ) { ?>

										<option <?php if ( WPJ_Form::get( 'post_type' ) == 'news' ) { echo 'selected="selected"'; } ?> value="news"><?php _e( 'News', 'wpjobster' ); ?></option>

									<?php } ?>

									<?php if ( apply_filters( 'wpj_search_display_post_type_job_filter', true ) ) { ?>

										<option <?php if ( WPJ_Form::get( 'post_type' ) == 'job' ) { echo 'selected="selected"'; } ?> value="job"><?php _e( 'Jobs', 'wpjobster' ); ?></option>

									<?php } ?>

									<?php if ( apply_filters( 'wpj_search_display_post_type_request_filter', true ) ) { ?>

										<option <?php if ( WPJ_Form::get( 'post_type' ) == 'request' ) { echo 'selected="selected"'; } ?> value="request"><?php _e( 'Requests', 'wpjobster' ); ?></option>

									<?php } ?>
								</select>
							</div>

						<?php } ?>

						<!-- Switch to Filter -->
						<?php if ( isset( $_COOKIE['switch_filter'] ) ) { ?>
							<input type="hidden" name="switch_filter" value="<?php echo WPJ_Form::cookie( 'switch_filter' ); ?>" />
						<?php } ?>

						<div class="field">
							<input class="ui fluid primary button full-width no-margin bigger" type="submit" value="<?php _e( 'Filter Results', 'wpjobster' ) ?>" name="research_me" />
						</div>

					</form>

				</div>
			</div>
		</div>

		<div class="twelve wide column">

			<?php if ( have_posts() ) {

				while ( have_posts() ) { the_post() ?>

					<div class="ui segment load-more-post" id="post-<?php the_ID(); ?>">

						<h2><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>

						<p class="fs12"><?php echo sprintf( __( 'Posted on %1$s by %2$s', 'wpjobster' ), get_the_date(), get_the_author() ); ?></p>

						<p class="blog_post_preview"><?php echo get_the_excerpt(); ?></p>

						<a href="<?php the_permalink(); ?>" class="ui primary button"><?php _e( 'View More', 'wpjobster' ); ?></a>

					</div>

				<?php }

				echo paginate_links( ['prev_text' => __( '&laquo;' ), 'next_text' => __( '&raquo;' )] );

				wp_reset_query();

			} else { ?>

				<div class="wpj-bordered-container p15"><?php _e( 'Sorry, no posts matched your criteria.', 'wpjobster' ); ?></div>

			<?php } ?>

		</div>

	</div>

</div>