<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'ReduxFramework_extension_repeater' ) ) {
	class ReduxFramework_extension_repeater {

		public static $version = '1.0.0';

		protected $parent;

		public $extension_dir;

		public static $theInstance;

		public $field_name = 'repeater';

		public function __construct( $parent ) {

			// Set parent object
			$this->parent = $parent;

			// Set extension dir
			if ( empty( $this->extension_dir ) ) {
				$this->extension_dir = trailingslashit( str_replace( '\\', '/', dirname( __FILE__ ) ) );
			}

			// Set instance
			self::$theInstance = $this;

			// Adds the local field
			add_filter( 'redux/' . $this->parent->args['opt_name'] . '/field/class/' . $this->field_name, array( &$this, 'overload_field_path' ) ); // Adds the local field
		}

		static public function getInstance() {
			return self::$theInstance;
		}

		// Forces the use of the embeded field path vs what the core typically would use
		public function overload_field_path( $field ) {
			return dirname( __FILE__ ) . '/' . $this->field_name . '/field_' . $this->field_name . '.php';
		}

	}
}