<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Cannot access pages directly.

/**
 * Custom theme configuration.
 * 
 * @since 4.4.8
 */

class Codevz_Core_Config {

	public static function get( $key = '', $config = [] ) {

		// Config.
		$config[ 'reset' ] 			= 0;
		$config[ 'slug' ] 			= 'xtra';
		$config[ 'name' ] 			= esc_html__( 'XTRA', 'xtra' );
		$config[ 'icon' ] 			= '';
		$config[ 'item_id' ] 		= '20715590';
		$config[ 'token_key' ] 		= 'ZMdAZMzRH8IUvopEsOv5jb9hgVfczMQf';

		// Colors.
		$config[ 'color_1' ] 		= '';
		$config[ 'color_2' ] 		= '';
		$config[ 'button_primary_color' ]   = '';
		$config[ 'button_primary_bg' ]      = '';
		$config[ 'button_secondary_color' ] = '';
		$config[ 'button_secondary_bg' ]    = '';

		// API.
		$config[ 'api' ] 			= 'https://xtratheme.com/api/';
		$config[ 'api_demos' ] 		= 'https://xtratheme.com/api/';
		$config[ 'api_templates' ] 	= 'https://xtratheme.com/api/elementor-templates/';

		// Links.
		$config[ 'docs' ] 			= 'https://xtratheme.com/docs';
		$config[ 'changelog' ] 		= 'https://xtratheme.com/changelog';
		$config[ 'faq' ] 			= 'https://xtratheme.com/faqs';
		$config[ 'find_purchase' ] 	= 'https://xtratheme.com/docs/getting-started/how-to-activate-theme-with-license-code/';

		$config[ 'buy_link' ] 		= 'https://1.envato.market/xtratheme';
		$config[ 'youtube' ] 		= 'https://youtube.com/channel/UCrS1L4oeTRfU1hvIo1gJGjg/videos';
		$config[ 'support' ] 		= 'https://codevz.ticksy.com/';

		// Plugins.
		$config[ 'plugins' ] 	= [

			'codevz-plus' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'codevz_plus' ),
				'source' 			=> $config[ 'api' ] . 'codevz-plus.zip',
				'required' 			=> true,
				//'class_exists' 		=> 'Codevz_Plus'
			],
			'elementor' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'elementor' ),
				'recommended' 		=> true
			],
			'js_composer' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'js_composer' ),
				'source' 			=> $config[ 'api' ] . 'js_composer.zip',
				'recommended' 		=> true
			],
			'revslider' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'revslider' ),
				'source' 			=> $config[ 'api' ] . 'revslider.zip',
				'recommended' 		=> true
			],
			'woocommerce' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'woocommerce' ),
				'recommended' 		=> true
			],
			'contact-form-7' => [
				'name' 				=> Codevz_Core_Strings::get( 'cf7' ),
				'recommended' 		=> true
			],
			'litespeed-cache' 	=> [
				'name' 				=> Codevz_Core_Strings::get( 'litespeed' ),
				'recommended' 		=> true
			]

		];

		// Demos.
		$config[ 'demos' ] 		= [

			/*'demo_name' 	=> [

				'title'				=> esc_html__( 'DEMO NAME', 'xtra' ),
				'elementor' 		=> true,
				'only_elementor' 	=> true, // important if only elementor available
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service', // service or shop or blog
				'keywords', 		=> 'key1 key2 key3', // demo search purpose
				'plugins' 			=> [ 'PLUGIN_SLUG' => true ], // Required to define it before
				'free' 				=> true

			],*/

			// Free demos.

			'gadgets' 	=> [

				'title'				=> esc_html__( 'gadgets', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'shop', 
				'free' 				=> true

			],
			'supermarket' 	=> [

				'title'				=> esc_html__( 'supermarket', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'shop', 
				'free' 				=> true

			],
			'book-shop' 	=> [

				'title'				=> esc_html__( 'book-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'shop', 
				'free' 				=> true

			],
			'portfolio' 		=> [

				'title'				=> esc_html__( 'portfolio', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'free' 				=> true,
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service'

			],
			'photographer2' 	=> [

				'title'				=> esc_html__( 'Photographer 2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'portfolio', 
				'free' 				=> true

			],
			'agency-2' 			=> [

				'title'				=> esc_html__( 'agency-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service', 
				'free' 				=> true

			],
			'photography3'      => [

				'title'				=> esc_html__( 'photography3', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'portfolio', 
				'free' 				=> true

			],
			'camping-adventures'=> [

				'title'				=> esc_html__( 'camping-adventures', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'blog', 
				'free' 				=> true

			],
			'logo-portfolio'    => [

				'title'				=> esc_html__( 'logo-portfolio', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service', 
				'free' 				=> true

			],
			'metro-blog'      	=> [

				'title'				=> esc_html__( 'metro-blog', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'blog', 
				'free' 				=> true

			],
			'game'              => [

				'title'				=> esc_html__( 'game', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'blog', 
				'free' 				=> true

			],
			'cryptocurrency' 	=> [

				'title'				=> esc_html__( 'cryptocurrency', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service', 
				'free' 				=> true

			],

			'pro_line' => true,

			// Premium demos.

			'architect-3'  => [

				'title'         => esc_html__( 'Architect 3', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'restaurant-2'  => [

				'title'         => esc_html__( 'Restaurant 2', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'cryptocurrency-3'  => [

				'title'         => esc_html__( 'Cryptocurrency 3', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'kids-2'  => [

				'title'         => esc_html__( 'Kids 2', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'bike-shop'  => [

				'title'         => esc_html__( 'Bike Shop', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'shop'

			],
			'fashion-shop-3'  => [

				'title'         => esc_html__( 'Fashion shop 3', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'shop'

			],
			'hosting-2'  => [

				'title'         => esc_html__( 'Hosting 2', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'gym-2'  => [

				'title'         => esc_html__( 'GYM 2', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'cafe'  => [

				'title'         => esc_html__( 'Cafe', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'service'

			],

			'car-auto-parts'  => [

				'title'         => esc_html__( 'Car Auto Parts', 'xtra' ),
				'js_composer'   => true,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => true, 'elementor' => true ],
				'category' 		=> 'shop'

			],

			'mechanic-2'  => [

				'title'         => esc_html__( 'Mechanic 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'seo-3'  => [

				'title'         => esc_html__( 'SEO 3', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'           => [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'logistic-2'  => [

			  'title'         => esc_html__( 'Logistic 2', 'xtra' ),
			  'js_composer'   => false,
			  'elementor'     => true,
			  'rtl'           => [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'home-renovation-2'  => [

			  'title'         => esc_html__( 'Home Renovation 2', 'xtra' ),
			  'js_composer'   => false,
			  'elementor'     => true,
			  'rtl'           => [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'spa-2'  => [

			  'title'         => esc_html__( 'SPA 2', 'xtra' ),
			  'js_composer'   => false,
			  'elementor'     => true,
			  'rtl'           => [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'app-3'  => [

				'title'         => esc_html__( 'Application 3', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'fashion-shop-2'  => [

				'title'         => esc_html__( 'Fashion Shop 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'shop'

			],
			'gardening-2'  => [

				'title'         => esc_html__( 'Gardening 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'medical-2'  => [

				'title'         => esc_html__( 'Medical 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'business-6'  => [

				'title'         => esc_html__( 'Business 6', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'dentist-2'  => [

				'title'         => esc_html__( 'Dentist 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'digital-marketing-2'  => [

				'title'         => esc_html__( 'Digital Marketing 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'construction-3'  => [

				'title'         => esc_html__( 'Construction 3', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'horse-club'  => [

				'title'         => esc_html__( 'Horse Club', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],
			'barber-2'  => [

				'title'         => esc_html__( 'Barber 2', 'xtra' ),
				'js_composer'   => false,
				'elementor'     => true,
				'rtl'         	=> [ 'js_composer' => false, 'elementor' => true ],
				'category' 		=> 'service'

			],

			'big-shop' 	=> [

				'title'				=> esc_html__( 'Big Shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'furniture-shop-2' 	=> [

				'title'				=> esc_html__( 'Furniture Shop 2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],

			'app-2' 	=> [

				'title'				=> esc_html__( 'app-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'pet-shop' 	=> [

				'title'				=> esc_html__( 'pet-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'event' 	=> [

				'title'				=> esc_html__( 'event', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],

			'car-rental' 	=> [

				'title'				=> esc_html__( 'car-rental', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'factory-2' 	=> [

				'title'				=> esc_html__( 'factory-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'beauty-salon-2' 	=> [

				'title'				=> esc_html__( 'beauty-salon-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'music-and-band' 	=> [

				'title'				=> esc_html__( 'music-and-band', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'nail-salon' 		=> [

				'title'				=> esc_html__( 'nail-salon', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'perfume-shop' 	=> [

				'title'				=> esc_html__( 'perfume-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'watch-shop' 	=> [

				'title'				=> esc_html__( 'watch-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],

			'flower-shop' 	=> [

				'title'				=> esc_html__( 'flower-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'magazine' 	=> [

				'title'				=> esc_html__( 'magazine', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'blog'

			],
			'architect-2' 		=> [

				'title'				=> esc_html__( 'architect-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'photographer' 		=> [

				'title'				=> esc_html__( 'photographer', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'portfolio'

			],
			'elderly-care' 		=> [

				'title'				=> esc_html__( 'elderly-care', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'investment' 		=> [

				'title'				=> esc_html__( 'investment', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'dance' 			=> [

				'title'				=> esc_html__( 'dance', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business-5' 		=> [

				'title'				=> esc_html__( 'business-5', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'construction-2' 	=> [

				'title'				=> esc_html__( 'construction-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'advisor' 			=> [

				'title'				=> esc_html__( 'advisor', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'seo-2' 			=> [

				'title'				=> esc_html__( 'seo-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service'

			],
			'personal-blog-2' 	=> [

				'title'				=> esc_html__( 'personal-blog-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'blog'

			],
			'insurance' 		=> [

				'title'				=> esc_html__( 'insurance', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'corporate-2' 		=> [

				'title'				=> esc_html__( 'corporate-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business-4' 		=> [

				'title'				=> esc_html__( 'business-4', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'startup' 			=> [

				'title'				=> esc_html__( 'startup', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service'

			],
			'medical' 			=> [

				'title'				=> esc_html__( 'medical', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'factory' 			=> [

				'title'				=> esc_html__( 'factory', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'furniture' 		=> [

				'title'				=> esc_html__( 'furniture', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'carwash' 			=> [

				'title'				=> esc_html__( 'carwash', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'rims' 				=> [

				'title'				=> esc_html__( 'rims', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'jewelry' 			=> [

				'title'				=> esc_html__( 'jewelry', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'church' 			=> [

				'title'				=> esc_html__( 'church', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'yoga' 				=> [

				'title'				=> esc_html__( 'yoga', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'moving' 			=> [

				'title'				=> esc_html__( 'moving', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'plumbing' 			=> [

				'title'				=> esc_html__( 'plumbing', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'travel' 			=> [

				'title'				=> esc_html__( 'travel', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'beauty-salon'      => [

				'title'				=> esc_html__( 'beauty-salon', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'home-renovation' 	=> [

				'title'				=> esc_html__( 'home-renovation', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'creative-business' => [

				'title'				=> esc_html__( 'creative-business', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'mechanic'        	=> [

				'title'				=> esc_html__( 'mechanic', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'lawyer'         	=> [

				'title'				=> esc_html__( 'lawyer', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'web-agency'        => [

				'title'				=> esc_html__( 'web-agency', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'gardening'         => [

				'title'				=> esc_html__( 'gardening', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'corporate'         => [

				'title'				=> esc_html__( 'corporate', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business-3'        => [

				'title'				=> esc_html__( 'business-3', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'digital-marketing' => [

				'title'				=> esc_html__( 'digital-marketing', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business-classic'  => [

				'title'				=> esc_html__( 'business-classic', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'charity'        	=> [

				'title'				=> esc_html__( 'charity', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'creative-studio'   => [

				'title'				=> esc_html__( 'creative-studio', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'kids'      	    => [

				'title'				=> esc_html__( 'kids', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'smart-home'        => [

				'title'				=> esc_html__( 'smart-home', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'logistic'          => [

				'title'				=> esc_html__( 'logistic', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'industrial'      	=> [

				'title'				=> esc_html__( 'industrial', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'tattoo'      		=> [

				'title'				=> esc_html__( 'tattoo', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'personal-blog'    	=> [

				'title'				=> esc_html__( 'personal-blog', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service'

			],
			'cleaning'      	=> [

				'title'				=> esc_html__( 'cleaning', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'parallax'      	=> [

				'title'				=> esc_html__( 'parallax', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'3d-portfolio'      => [

				'title'				=> esc_html__( '3d-portfolio', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'agency'            => [

				'title'				=> esc_html__( 'agency', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'spa'               => [

				'title'				=> esc_html__( 'spa', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'app'               => [

				'title'				=> esc_html__( 'app', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'architect'         => [

				'title'				=> esc_html__( 'architect', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'barber'            => [

				'title'				=> esc_html__( 'barber', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'building'          => [

				'title'				=> esc_html__( 'building', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business'          => [

				'title'				=> esc_html__( 'business', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'coffee'            => [

				'title'				=> esc_html__( 'coffee', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'conference' 		=> [

				'title'				=> esc_html__( 'conference', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'business-2' 		=> [

				'title'				=> esc_html__( 'business-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'construction' 		=> [

				'title'				=> esc_html__( 'construction', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'cryptocurrency-2' 	=> [

				'title'				=> esc_html__( 'cryptocurrency-2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'cv-resume'         => [

				'title'				=> esc_html__( 'cv-resume', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'plugins' 			=> [ 'revslider' => false ],
				'category' 			=> 'service'

			],
			'dentist'           => [

				'title'				=> esc_html__( 'dentist', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'fashion-shop'      => [

				'title'				=> esc_html__( 'fashion-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'fast-food'         => [

				'title'				=> esc_html__( 'fast-food', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'finance'           => [

				'title'				=> esc_html__( 'finance', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'gym'               => [

				'title'				=> esc_html__( 'gym', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'hosting'           => [

				'title'				=> esc_html__( 'hosting', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'hotel' 			=> [

				'title'				=> esc_html__( 'hotel', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'interior'          => [

				'title'				=> esc_html__( 'interior', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'lawyers'           => [

				'title'				=> esc_html__( 'lawyers', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'music'             => [

				'title'				=> esc_html__( 'music', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'photography'       => [

				'title'				=> esc_html__( 'photography', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'portfolio'

			],
			'photography2'      => [

				'title'				=> esc_html__( 'photography2', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'portfolio'

			],
			'plastic-surgery'   => [

				'title'				=> esc_html__( 'plastic-surgery', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'restaurant'        => [

				'title'				=> esc_html__( 'restaurant', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'dubai-investment'  => [

				'title'				=> esc_html__( 'dubai-investment', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'seo'               => [

				'title'				=> esc_html__( 'seo', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			'single-shop'       => [

				'title'				=> esc_html__( 'single-shop', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'shop'

			],
			'wedding'           => [

				'title'				=> esc_html__( 'wedding', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],
			esc_html__( 'winery', 'xtra' ) => [

				'title'				=> esc_html__( 'winery demo', 'xtra' ),
				'elementor' 		=> true,
				'rtl' 				=> [ 'js_composer' => true, 'elementor' => true ],
				'category' 			=> 'service'

			],

		];

		// --- Elementor ---
		$config[ 'templates' ] = [
	        '001' => [ 'Business 4, Light, green, Service box, Columns, Boxes, Features, Four' ],
	        '002' => [ 'Business 4, Light, green, About us, Hero section, features, introduce, welcome' ],
	        '003' => [ 'Business 4, Light, green, Steps, About us, process, how works, points' ],
	        '004' => [ 'Business 4, Light, green, Testimonials, quote, Carousel, Slider, fade, Horizontal, Single' ],
	        '005' => [ 'Business 4, Light, green, Client logos, images, brands, famous, hover' ],
	        '006' => [ 'Business 4, Light, green, Call to action, box, button, overlay, shadow' ],
	        '007' => [ 'Business 4, Light, green, About us, stas, statistics, numbers, who we are' ],
	        '008' => [ 'Business 4, Light, green, Call to action, background box, button, contact, banner' ],
	        '009' => [ 'Business 4, Dark, green, Steps, process, how we work, timeline, project steps' ],
	        '010' => [ 'Business 4, Light, green, Info box background gradient, call to action' ],
	        '011' => [ 'Business 4, Light, green, Pricing table, prices, plans, packages, subscription, buy' ],
	        '012' => [ 'Business 4, Light, green, Steps, process, how we work, timeline, project steps' ],
	        '013' => [ 'Business 4, Light, green, Contact form, call, email, quote, address' ],
	        '014' => [ 'Business 4, Light, green, Accordion, toggle, faq, question, list, show more' ],
		    '015' => [ 'Corporate, Dark, blue, Carousel, hero, counters, stats, statistics, slider, overlay' ],
		    '016' => [ 'Corporate, Light, blue, Story, about us, features, vision, mission, company, two button' ],
		    '017' => [ 'Corporate, Dark, blue, Tabs, background full width row, tabbed, four, fullwide' ],
		    '018' => [ 'Corporate, Light, blue, How works, steps, features, process, list, about' ],
		    '019' => [ 'Corporate, Light, blue, Service, Video popup, play, youtube, vimeo, features' ],
		    '020' => [ 'Corporate, Light, blue, Blog carouse, slider, news, updates, articles, overflow' ],
		    '021' => [ 'Corporate, Dark, blue, Team members, group, company, about us, ours, we, social, dark' ],
		    '022' => [ 'Corporate, Light, blue, Logos, cleints, customers, gallery' ],
		    '023' => [ 'Corporate, Light, blue, About us, fade slider, list, features' ],
		    '024' => [ 'Corporate, Light, blue, History line, timeline, timeframe, story, about, old, start, end' ],
		    '025' => [ 'Corporate, Dark, blue, Counters, particles, stats, statistics, fullwide, dark' ],
		    '026' => [ 'Corporate, Light, blue, Pricing table, price, plans, packages, subscription, buy' ],
		    '027' => [ 'Corporate, Light, blue, Service Boxes, quick access, links, three, help, category, menu' ],
		    '028' => [ 'Corporate, Light, blue, Accordion, toggle, faq, question, contact, frequently asked questions' ],
		    '029' => [ 'Corporate, Light, blue, Project details, carousel, slider, info, portfolio, single, gallery' ],
		    '030' => [ 'Corporate, Light, blue, Project details, info, portfolio, single, metro, gallery' ],
		    '031' => [ 'Corporate, Light, blue, Contact, phone, email, quote, address, map, google map, mobile, address' ],
		    '032' => [ 'Construction 2, Dark, yellow, Features, intro, boxes, flip, back, overlay' ],
	        '033' => [ 'Construction 2, Light, About us, features, introduce, yellow, welcome, company, list, stylish, overlay image' ],
		    '034' => [ 'Construction 2, Light, Service boxes, call to action, yellow, features, what we do' ],
		    '035' => [ 'Construction 2, Light, steps, how works, process, what we do, overlay, yellow' ],
		    '036' => [ 'Construction 2, Light, yellow, project, portfolio, posts, post type, cpt' ],
		    '037' => [ 'Construction 2, Light, yellow, contact, free quote, price, get' ],
		    '038' => [ 'Construction 2, Light, yellow, Testimonials, quote, Carousel, Slider, Client' ],
		    '039' => [ 'Construction 2, Light, yellow, logos, images, clients, brands, famous' ],
		    '040' => [ 'Construction 2, Light, about, stylish, list, features, company, introduce' ],
		    '041' => [ 'Construction 2, Light, yellow, boxes, service, banner, hover, overlay, rotate' ],
		    '042' => [ 'Construction 2, Dark, yellow, statistics, stats, numbers, counter' ],
		    '043' => [ 'Construction 2, Light, yellow, video popup, progress, bar, how work' ],
		    '044' => [ 'Construction 2, Dark, call to action, button, banner, right, full' ],
		    '045' => [ 'Construction 2, Light, yellow, pricing, table, price, buy, payment, package' ],
		    '046' => [ 'Construction 2, Dark, yellow, boxes, back, flip, content, about us, company' ],
		    '047' => [ 'Construction 2, Light, yellow, services, special, call to action, overlay' ],
		    '048' => [ 'Construction 2, Light, yellow, box, call to action, shadow, full' ],
		    '049' => [ 'Construction 2, Light, yellow, Accordion, toggle, faq, frequently asked questions, contact, form, sidebar, full' ],
		    '050' => [ 'Construction 2, Light, yellow, contact form, get in touch, cf7, email, phone, address' ],
			'051' => [ 'GYM 2, Dark, Neon Green, about us, overlay, list icon, button, outline, two images' ],
			'052' => [ 'GYM 2, Dark, Neon Green, background, overlay, four, post type, classes, train, title' ],
			'053' => [ 'GYM 2, white, Neon Green, call to action, button, banner, box, badge' ],
			'054' => [ 'GYM 2, Dark, Neon Green, discount, overlay, two, desc, button, membership' ],
			'055' => [ 'GYM 2, Dark, Neon Green, price, pricing, table, two, three, button, packages, plans, classes' ],
			'056' => [ 'GYM 2, Dark, Neon Green, gallery, carousel, slider, odd, even, button, modal' ],
			'057' => [ 'GYM 2, Light, Neon Green, contact form, contact-form-7, cf7, register, quote, email, send' ],
			'058' => [ 'GYM 2, Dark, Neon Green, private class, about, list style, button, package, project' ],
			'059' => [ 'GYM 2, Dark, Neon Green, service box, features, items, products, four columns' ],
			'060' => [ 'GYM 2, Light, Neon Green, why choose us, how, when, services, banner, overlay, model, hero' ],
			'061' => [ 'GYM 2, Dark, Neon Green, progress, process, bars, two, col, mission, vision, statistics, stats, numbers, counter, result' ],
			'062' => [ 'GYM 2, Dark, Neon Green, testimonials, cleints, customers, quote, Carousel, Slider, full' ],
			'063' => [ 'GYM 2, Dark, Neon Green, team members, staff, expert, trainer, four, support, social' ],
			'064' => [ 'GYM 2, Dark, Neon Green, hero, about, us, timeline, history, story, process road, three, steps' ],
			'065' => [ 'GYM 2, Dark, Neon Green, light, service box, Three, overlay, banner, overlay, minimal, contact, download, app, address, email, phone, faq' ],
			'066' => [ 'GYM 2, Dark, Neon Green, faq, banner, online support, frequently asked questions, help, how, know' ],
			'067' => [ 'GYM 2, Light, Neon Green, contact form, head, office, email, address, location, how, ask, question, send' ],
			'068' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, about, parallax, since, project, details, info, brochure, company' ],
			'069' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, project, details, info, brochure, company, meta, data, showcase' ],
			'070' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, clients, testimonials, customers, carousel, slider, video, popup, background, fullwide, quote' ],
			'071' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, contact, email, address, phone, consultation, free, call, mobile' ],
			'072' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, blog, posts, carousel, overflow, overlay, stretch right left, articles, news, updates, latest' ],
			'073' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, contact, location, address, background, fullwide, menu, hover, info, office' ],
			'074' => [ 'Architect 3, Dark, Bright Red, Midnight Navy, Charcoal, parallax, services, features, stretch left right, two, what we do, about, company, details' ],
			'075' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, about, company, mission, vision, benefit, two, even, odd, image' ],
			'076' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, testimonials, clients, fullwide, background, overlay, carousel, slider, arrow, quotes, Two' ],
			'077' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, two, parallax, image, progress, bars, process, statistics, stats, numbers, counter, result, overlay, explore, about' ],
			'078' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, tabs, tebbed, years, history, story, company, old, start, end, timeline, explore' ],
			'079' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, logos, clients, famous, gallery, trusted, brands' ],
			'080' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, call to action, stretch, button, next step, how works, layer' ],
			'081' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, journey, sertvices, button, call to action, three' ],
			'082' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, image, details, project, item, info, brochure, two, meta, data, showcase, product' ],
			'083' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, services box, background, fullwide, choose, why, cube, three' ],
			'084' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, parallax, two columns, quote, info, standard' ],
			'085' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, steps, how works, button, call to action, boxes, three, workflow, process' ],
			'086' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, project, slider, carousel, details, info, brochure, single, meta, data, showcase, portfolio' ],
			'087' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, faq, Accordion, toggle, Frequently, question, ask, show more, contact form, cf7, common' ],
			'088' => [ 'Architect 3, Light, Bright Red, Midnight Navy, Charcoal, contact form, email, address, phone, consultation, quote, call, mobile, location, google map, touch, send' ],
			'089' => [ 'Bike Shop, Dark, Orange, hero, product, bicycle, price, add to cart' ],
			'090' => [ 'Bike Shop, Dark, Orange, about, bicycle, two, list style, icon, about us, features, revolution, parallax' ],
			'091' => [ 'Bike, Dark, Orange, box, call to action, ride, explore, store, find, quick access' ],
			'092' => [ 'Bike Shop, Dark, Orange, products, items, store, buy, purchase, add to cart, sale, sell, market, woocommerce' ],
			'093' => [ 'Bike Shop, Dark, Orange, two boxes, featured, packages, category, collection, products' ],
			'094' => [ 'Bike, Dark, Orange, testimonials, carousel, slider, arrow, quotes, Two, clients, customers, people, says, what' ],
			'095' => [ 'Bike, Dark, Orange, newsletter, subscription, subscribe, form, single, input, email, offers, get' ],
			'096' => [ 'Bike, Dark, Orange, two, list style icon, stylish, about us, smart, who we are, desc, paragraphe' ],
			'097' => [ 'Bike, Dark, Orange, about us, fullwidth, fullwide, featured, boxes, background, hover, banner, story, button' ],
			'098' => [ 'Bike Shop, Dark, Orange, carousel, slider, gallery, arrow, bullet, explore, touch' ],
			'099' => [ 'Bike Shop, Dark, Orange, gallery, logos, clients, customers, famous, six, partners, trusted' ],
			'100' => [ 'Bike Shop, Dark, Orange, services box, overlay, zoom, featured, setup, packages, plans, popular' ],
			'101' => [ 'Bike Shop, Dark, Orange, two, background, featured, hero, about us, learn, stylish, list icon, button, fade' ],
			'102' => [ 'Bike, Dark, Orange, faq, Frequently, asked, question, common, Accordion, toggle, show more' ],
			'103' => [ 'Bike, Dark, Orange, faq, Frequently, asked, question, common, Accordion, toggle, show more, contact form' ],
			'104' => [ 'Bike, Dark, Orange, contact form, address, location, email, ask, question, send, phone, social media, facebook, support, touch, google map, marker' ],
			'105' => [ 'Building, Light, Yellow, hero, features, steps, how works, what we do, construction, title line, numbers' ],
			'106' => [ 'Building, Light, Yellow, projects, portfolio, items, carousel, slider, overflow, fullwide, bullet' ],
			'107' => [ 'Building, Light, Yellow, video popup, about us, why choose, list stylish, button, two, check, tick' ],
			'108' => [ 'Building, Light, Yellow, who we are, statistics, stats, numbers, counter, result, video popup, experience' ],
			'109' => [ 'Building, Light, Yellow, testimonials, quote, slider, carousel, arrow, clients, customers, says, people, what, rate, rating' ],
			'110' => [ 'Building, Light, Yellow, partners, clients, logos, gallery, six, brands' ],
			'111' => [ 'Building, Light, Yellow, who we are, what we do, list style, icons, check, features, description, introduce' ],
			'112' => [ 'Building, Light, Yellow, team members, staff, support, engineer, four, inner, manager, expert' ],
			'113' => [ 'Building, Light, Yellow, video popup, progress, bars, process, statistics, stats, numbers, counter, result, why choose us, player' ],
			'114' => [ 'Building, Light, Yellow, our services, boxes, overlay, five, three columns, two row, features' ],
			'115' => [ 'Building, Light, Yellow, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'116' => [ 'Building, Light, Yellow, google map, marker, pin, office, location, address' ],
			'117' => [ 'Building, Light, Yellow, contact form, address, location, email, ask, question, send, phone, social media, facebook, support, touch' ],
			'118' => [ 'Building, Light, Yellow, project, single, gallery, details, info, brochure, single, meta, data, showcase, portfolio' ],
			'119' => [ 'Building, Light, Yellow, project, slider, carousel, single, gallery, details, info, brochure, single, meta, data, showcase, portfolio' ],
			'120' => [ 'Building, Light, Yellow, project, gallery, single, sticky column, details, info, brochure, single, meta, data, showcase, portfolio' ],
			'121' => [ 'Architect 3, Light, silver, google map, marker, pin, office, location, address' ],
			'122' => [ 'Business 4, Light, green, google map, marker, pin, office, location, address' ],
			'123' => [ 'Medical, Light, blue, categories, features, serivces box, fullwidth, fullwide, featured, quick access, links, hospital, clinic, dentist, doctor, nurse' ],
			'124' => [ 'Medical, Light, blue, list style, features, services, why choose us, two overlay, image, hospital, clinic, dentist, doctor, nurse' ],
			'125' => [ 'Medical, Light, blue, counter, numbers, stats, statistics, three, hospital, clinic, dentist, doctor, nurse' ],
			'126' => [ 'Medical, Light, blue, tabs, tabbed, about us, five, template, fullwide, hospital, clinic, dentist, doctor, nurse' ],
			'127' => [ 'Medical, Light, blue, call to action, stretch, button, hospital, clinic, dentist, doctor, nurse' ],
			'128' => [ 'Medical, Light, blue, about us, vision, mission, three, button, hospital, clinic, dentist, doctor, nurse' ],
			'129' => [ 'Medical, Light, blue, contact form, cf7, appointment, send, request, hospital, clinic, dentist, doctor, nurse' ],
			'130' => [ 'Medical, Light, blue, testimonials, quote, slider, carousel, arrow, clients, customers, says, people, what, hospital, clinic, dentist, doctor, nurse' ],
			'131' => [ 'Medical, Light, blue, video popup, player, box, overlay, counter, numbers, stats, statistics, hospital, clinic, dentist, doctor, nurse' ],
			'132' => [ 'Medical, Light, blue, list style, about us, features, experience, expert, hospital, clinic, dentist, doctor, nurse' ],
			'133' => [ 'Medical, Light, blue, progress, process, bars, video popup, player, box, overlay, counter, numbers, stats, statistics, hospital, clinic, dentist, doctor, nurse' ],
			'134' => [ 'Medical, Light, blue, gallery, metro, particles, overlay, hospital, clinic, dentist, doctor, nurse' ],
			'135' => [ 'Medical, Light, blue, call to action, full box, banner, button, hospital, clinic, dentist, doctor, nurse' ],
			'136' => [ 'Medical, Light, blue, Services, three, banner, hover, category, hospital, clinic, dentist, doctor, nurse' ],
			'137' => [ 'Medical, Light, blue, price, pricing, table, two, three, button, packages, plans, hospital, clinic, dentist, doctor, nurse' ],
			'138' => [ 'Medical, Light, blue, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form, hospital, clinic, dentist, doctor, nurse' ],
			'139' => [ 'Medical, Light, blue, contact form, cf7, appointment, send, request, hospital, clinic, dentist, doctor, nurse' ],
			'140' => [ 'Super market, Light, green, hero, featured, two button, model, shop, store, online' ],
			'141' => [ 'Super market, Light, green, featured boxes, metro, categories, shop now, store' ],
			'142' => [ 'Super market, Light, green, categories, boxes, tags, quick access, links, menus, store, shop' ],
			'143' => [ 'Super market, Light, green, Call to action, banner, ads, advertise, mobile, application, android, ios, apple, full box' ],
			'144' => [ 'Super market, Light, green, posts, blog, news, updates, articles, carousel, slider, arrow' ],
			'145' => [ 'Super market, Light, green, full box, subscribe, button, newsletter, subscription, subscribe, form, updates, email' ],
			'146' => [ 'Super market, Light, green, contact form, cf7, appointment, send, request, support, touch, google, map, marker, pin, office, address, location, email, ask, question, send' ],
			'147' => [ 'Super market, Light, green, about us, company, our vision, mission, list style, stylish, features, image caption' ],
			'148' => [ 'Super market, Light, green, testimonials, quote, clients, customers, says, people, what' ],
			'149' => [ 'Super market, Light, green, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'150' => [ 'Super market, Light, green, categories, boxes, tags, quick access, links, menus, store, shop' ],
			'151' => [ 'Book Shop, Light, Blue, Collections, categories, metro, background box, content, pack, packages, market' ],
			'152' => [ 'Book Shop, Light, Blue, top sellers, shop, products, year, best' ],
			'153' => [ 'Book, Light, Blue, testimonials, quote, clients, carousel, slider, overflow, visible, customers, says, people, what' ],
			'154' => [ 'Book, Light, Blue, Call to action, banner, ads, advertise, full box, backgorund, off, discount, offer, special' ],
			'155' => [ 'Book, Light, Blue, writer, team members, author, famous, people, person' ],
			'156' => [ 'Book, Light, Blue, full box, subscribe, button, newsletter, subscription, subscribe, form, updates, email' ],
			'157' => [ 'Book, Light, Blue, about, our team, who we are, since, details, info, brochure, company' ],
			'158' => [ 'Book, Light, Blue, testimonials, quote, clients, customers, says, people, what, who, said' ],
			'159' => [ 'Book, Light, Blue, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'160' => [ 'Book, Light, Blue, google map, marker, pin, office, location, address, contact form, cf7, appointment, send, request' ],
			'161' => [ 'Car Auto Parts, Light, Red, Carousel, hero, service, category, about, product, showcase, intro, introduce, view, special' ],
			'162' => [ 'Car Auto Parts, Light, Red, brands, logos, famous, clients, customers, trusted' ],
			'163' => [ 'Car Auto Parts, Black, dark, Red, two full columns, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, stretch' ],
			'164' => [ 'Car Auto Parts, Black, dark, Red, Call to action, banner, ads, advertise, full box, backgorund, off, discount, offer, special' ],
			'165' => [ 'Car Auto Parts, Light, Red, posts, blog, news, updates, articles, carousel, slider, arrow' ],
			'166' => [ 'Car Auto Parts, Black, dark, Red, top sellers, shop, products, year, best, carousel, arrow, slider, popular' ],
			'167' => [ 'Car Auto Parts, Light, Red, about, our team, who we are, since, details, info, brochure, company, parallax, hub, mechanic' ],
			'168' => [ 'Car Auto Parts, Black, dark, Red, who we are, statistics, stats, numbers, counter, result, particles, experience' ],
			'169' => [ 'Car Auto Parts, Light, Red, dark, history, timeline, story, overlay, two, image, line, who, when, company' ],
			'170' => [ 'Car Auto Parts, Light, Red, testimonials, quote, clients, customers, says, people, what, who, said, logos, famous, clients, customers, trusted' ],
			'171' => [ 'Car Auto Parts, Light, Red, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'172' => [ 'Car Auto Parts, Light, Red, services box, overlay, zoom, featured, setup, packages, plans, popular' ],
			'173' => [ 'Car Auto Parts, Black, dark, Red, full, stretch, Steps, process, how we work, timeline, project steps' ],
			'174' => [ 'Car Auto Parts, Light, Red, pricing, table, price, buy, payment, package' ],
			'175' => [ 'Car Auto Parts, Black, Red, dark, particles, Call to action, banner, ads, advertise, full box, backgorund, off, discount, offer, special' ],
			'176' => [ 'Car Auto Parts, Light, Red, four, get touch, faq, phone, location, email, box, contact, mobile' ],
			'177' => [ 'Car Auto Parts, Light, Red, contact form, address, map, google maps, pin, marker, box' ],
			'178' => [ 'Watch shop, Light, Blue, introduce, welcome, product, special, intro, hero' ],
			'179' => [ 'Watch, Dark, Blue, banner, box, introduce, welcome, background, call to action, features, special, section' ],
			'180' => [ 'Watch, Light, Blue, top sellers, shop, products, year, best, popular' ],
			'181' => [ 'Watch, Light, Blue, testimonials, quote, clients, customers, says, people, what, who, said' ],
			'182' => [ 'Watch, Dark, Blue, Call to action, banner, ads, advertise, full box, backgorund, off, discount, offer, special' ],
			'183' => [ 'Watch, Light, Blue, about, our team, who we are, since, details, info, brochure, company, hub' ],
			'184' => [ 'Watch, Light, Blue, about, our team, who we are, since, details, info, brochure, company, video popup, counter, stats, statistics, numbers, progress, hub' ],
			'185' => [ 'Watch, Light, Blue, counter, stats, statistics, numbers, progress, stretch, full, background, overlay' ],
			'186' => [ 'Watch, Light, Blue, testimonials, quote, clients, customers, says, people, what, who, said' ],
			'187' => [ 'Watch, Light, Blue, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'188' => [ 'Watch, Light, Blue, box, hover, email, phone, mobile, address, location, details, contact' ],
			'189' => [ 'Watch, Light, Blue, Google map, contact form, 7, cf7, pin, marker, location, address' ],
			'190' => [ 'Watch, Light, Blue, social, icon, facebook, twitter, x, instagram, media' ],
			'191' => [ 'Industrial, Light, Blue, Yellow, features, service, introduce, intro, overlay, three, Horizontal' ],
			'192' => [ 'Industrial, Light, Blue, Yellow, title, counter, result, number, statistics, stats, progress, full' ],
			'193' => [ 'Industrial, Dark, Blue, Yellow, full, about, our team, who we are, since, details, info, brochure, company, hub' ],
			'194' => [ 'Industrial, Light, Blue, Yellow, quote, famous, two, testimonial, single, special, hero' ],
			'195' => [ 'Industrial, Light, Blue, Yellow, service, box, three, special, features' ],
			'196' => [ 'Industrial, Light, Blue, Yellow, Call to action, banner, ads, advertise, full box, backgorund, off, discount, offer, special' ],
			'197' => [ 'Industrial, Light, Blue, Yellow, faq, Frequently, asked, question, common, Accordion, toggle, show' ],
			'198' => [ 'Industrial, Light, Blue, Yellow, posts, blog, news, updates, articles' ],
			'199' => [ 'Industrial, Light, Blue, Yellow, testimonials, quote, clients, customers, says, people, what, who, said, logos, famous, clients, customers, trusted' ],
			'200' => [ 'Industrial, Light, Blue, Yellow, about, our team, who we are, since, details, info, brochure, company, hub' ],

			// T.
		    '201' => ['factory, Light, red, Service box, Four Columns, Boxes, Features, Four'],
	        '202' => ['factory, Dark, red, Hero, cta, Call to action, background, Dark, title, black, Two Buttons'],
	        '203' => ['factory, Light, red, Counter,Four Columns, number, four, red'],
	        '204' => ['factory, Light, red, Service Box, Four Columns, four, fullwidth'],
	        '205' => ['factory, Light, red, Sponsors, Logo, brand, Two Columns, Two'],
	        '206' => ['factory, Dark, red, Call to action, cta, quote, Dark, button'],
	        '207' => ['factory, Light, red, About, Two Columns, Three Columns, two, three, stylish list' ],
	        '208' => ['factory, Light, red, Gallery, Two Columns, stylish list, text, title'],
	        '209' => ['factory, Light, red, Counter,Two Columns, number, two'],
	        '210' => ['factory, Dark, red, Call to action, Dark, button, fullwidth'],
	        '211' => ['factory, Light, red, Accordion, FAQ, Frequently asked questions, Toggle, Two Columns, two'],
	        '212' => ['factory, Light, red, Sponsors, Logo, brand, 5 Columns, five, fullwidth, carousel, slider'],
	        '213' => ['factory, Light, red, Three Columns, Service Box, icon'],
	        '214' => ['factory, Light, red, Contact form, Two Columns, two'],
	        '215' => ['factory, Light, red, Contact Icons, Three Columns, icon, phone, email, tel, address'],
	        '216' => ['factory, Light, red, Contact form, Two Columns, two'],
	        '217' => ['factory, Dark, red, map, Dark, full, pin, google map'],
	        '218' => ['kids, Light, About, Two Columns, colorful, stylish list'],
	        '219' => ['kids, Light, Counter,Four Columns, number, four, colorful'],
	        '220' => ['kids, Light, Team members, staff, support, colorful, Two Columns'],
	        '221' => ['kids, Light, Sponsors, Logo, brand, 5 Columns, five'],
	        '222' => ['kids, Light, About, Program, Event, countdown, timer, '],
	        '223' => ['kids, Light, gallery, photo, carousel, slider, slides, Three Columns'],
	        '224' => ['kids, Light, gallery, photo, Three Columns grid'],
	        '225' => ['kids, Light, gallery, photo, masonry, Three Columns'],
	        '226' => ['fashion, Light, red, About, Two Columns, video, minimal'],
	        '227' => ['fashion, Light, red, Three Columns, category, banner, box, minimal'],
	        '228' => ['fashion, Light, testimonials, carousel, slider, arrow, quotes , minimal'],
	        '229' => ['fashion, Light, Sponsors, Logo, brand, 5 Columns, five, carousel, slider, slides, minimal'],
	        '230' => ['fashion, Light, social icons, instagram, facebook, twitter, follow, minimal'],
	        '231' => ['fashion, Light, red, About, history, Two Columns, Two Buttons, button, minimal'],
	        '232' => ['fashion, Light, red, Service Box, Three Columns, three, background, Three Boxes, minimal'],
	        '233' => ['fashion, Light, red, icon, contact, Three Columns, minimal'],
	        '234' => ['cryptocurrency, Dark, orange, about, Two Columns, two, button, Two Buttons'],
	        '235' => ['cryptocurrency, Dark, orange, title, text'],
	        '236' => ['cryptocurrency, Dark, orange, service box, Three Boxes, features, orange'],
	        '237' => ['cryptocurrency, Dark, orange, Three Columns, features, service box, icon'],
	        '238' => ['cryptocurrency, Dark, orange, about, text, Two Columns, background'],
	        '239' => ['cryptocurrency, Dark, orange, team members, staff, support, title, button'],
	        '240' => ['cryptocurrency, Dark, orange, features, hot spots, image'],
	        '241' => ['cryptocurrency, Dark, orange, timeline, history line, vertical, countdown, timer, process, step by Steps'],
	        '242' => ['cryptocurrency, Dark, orange, Accordion, faq, Frequently asked questions, Two Columns'],
	        '243' => ['cryptocurrency, Dark, orange, counter, result, number, Four Columns, title, background'],
	        '244' => ['cafe, coffee shop, Light, brown, about, parallax, title, button, Two Buttons, Two Columns '],
	        '245' => ['cafe, coffee shop, Light, brown, testimonials, carousel, slider, arrow, quotes, Two Columns'],
	        '246' => ['cafe, coffee shop, Dark, brown, counter, result, number, Four Columns'],
	        '247' => ['cafe, coffee shop, Light, brown, Two Columns, two, buttons, Two Buttons, subscribe, newsletter'],
	        '248' => ['cafe, coffee shop, Light, brown, Sponsors, Logo, brand, 5 Columns, five, title'],
	        '249' => ['cafe, coffee shop, Dark, brown,  testimonials, carousel, slider, arrow, quotes, Two Columns'],
	        '250' => ['cafe, coffee shop, Dark, brown, menu, Two Columns, food, list'],
	        '251' => ['cafe, coffee shop, Light, brown, menu, Two Columns, food, list'],
	        '252' => ['cafe, coffee shop, Dark, brown, menu, Two Columns, food, list'],
	        '253' => ['cafe, coffee shop, Light, brown, menu, Two Columns, food, list'],
	        '254' => ['cafe, coffee shop, Dark, brown, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle'],
	        '255' => ['cafe, coffee shop, Dark, brown, contact form, icon, social icons, instagram, facebook, phone, email'],
	        '256' => ['creative agency 2, Dark, teal, features, service box, two columns '],
	        '257' => ['creative agency 2, Dark, teal, team members, support, staff, two columns'],
	        '258' => ['creative agency 2, Light, teal, Testimonials, quote, Carousel, slider, slides'],
	        '259' => ['creative agency 2, Dark, teal, Sponsors, Logo, brand, 5 Columns, five'],
	        '260' => ['creative agency 2, Light, teal, about, Two Columns, two, stylish list, text, title'],
	        '261' => ['creative agency 2, Light, teal, team members, support, staff, four columns'],
	        '262' => ['creative agency 2, Light, teal, Testimonials, quote, Carousel, slider, slides, two columns'],
	        '263' => ['creative agency 2, Light, teal, service box, Three Boxes, features, four columns, icon'],
	        '264' => ['creative agency 2, Dark, teal, service box, Three Boxes, features, three columns, icon'],
	        '265' => ['factory 2, industrial, Light, orange, amber, about, Two Columns, two, stylish list, text, title, images'],
	        '266' => ['factory 2, industrial, Dark, orange, amber, hero, call to action, cta, title, background, fullwide fullwidth'],
	        '267' => ['factory 2, industrial, Light, orange, amber, service box, Four Columns, icon, Features'],
	        '268' => ['factory 2, industrial, Light, orange, amber, projects list, grid, portfolio, gallery'],
	        '269' => ['factory 2, industrial, Dark, orange, amber, Testimonials, quote, Carousel, slider, slides, one column'],
	        '270' => ['factory 2, industrial, Dark, orange, amber, about, Two Columns, stylish list, text, title'],
	        '271' => ['factory 2, industrial, Light, orange, amber, blog, news, grid, three columns, posts, article'],
	        '272' => ['factory 2, industrial, Dark, orange, amber, newsletter, subscription, subscribe, email, fullwidth, fullwide'],
	        '273' => ['factory 2, industrial, Dark, orange, amber, three columns, city, address, branches, map'],
	        '274' => ['factory 2, industrial, Dark, orange, amber, menu, logo, footer, social icons, instagram, facebook, twitter'],
	        '275' => ['factory 2, industrial, Light, orange, amber, about, history, Two Columns, two, stylish list, text, title, image'],
	        '276' => ['factory 2, industrial, Dark, orange, amber, counter, result, number, Four Columns, background, fullwidth, fullwide, title'],
	        '277' => ['factory 2, industrial, Light, orange, amber, Accordion, faq, Frequently asked questions, Two Columns'],
	        '278' => ['factory 2, industrial, Light, orange, amber, Sponsors, Logo, brand, 5 Columns, five'],
	        '279' => ['factory 2, industrial, Light, orange, amber, service box, Three Boxes, features, three columns, icon'],
	        '280' => ['factory 2, industrial, Light, orange, amber, projects details, slider, portfolio, spec'],
	        '281' => ['factory 2, industrial, Light, orange, amber, gallery, four columns, grid, project, portfolio'],
	        '282' => ['factory 2, industrial, Light, orange, amber, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle'],
	        '283' => ['factory 2, industrial, Light, orange, amber, contact form, icon, social icons, instagram, facebook, phone, email'],
	        '284' => ['factory 2, industrial, Light, orange, amber, icon, contact, Three Columns, minimal, address, email, phone, map, google maps'],
	        '285' => ['perfume shop, Light, orange, about, Two Columns, stylish list, text, title'],
	        '286' => ['perfume shop, Light, orange, Carousel, slider, slides, Two Columns, product, product slide show'],
	        '287' => ['perfume shop, Light, orange, Two Columns, category, banner, title'],
	        '288' => ['perfume shop, Light, orange, products grid, shop, store, '],
	        '289' => ['perfume shop, Light, orange, Testimonials, quote, Carousel, slider, slides, two columns, fullwidth, fullwide'],
	        '290' => ['perfume shop, Light, orange, two columns, features, hero, button, cta, call to action, stylish list'],
	        '291' => ['perfume shop, Light, orange, newsletter, subscription, subscribe, email, box'],
	        '292' => ['perfume shop, Light, orange, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle'],
	        '293' => ['perfume shop, Light, orange, icon, contact, Three Columns, minimal, address, email, phone'],
	        '294' => ['perfume shop, Light, orange, contact form, address, map, google maps'],
	        '295' => ['interior, Dark, orange, four columns, button, cta, category'],
	        '296' => ['interior, Light, orange, about, two columns, years, experience'],
	        '297' => ['interior, Light, orange, about, Two Columns, stylish list, text, title'],
	        '298' => ['interior, Light, orange, about, Two Columns, stylish list, text, title'],
	        '299' => ['interior, Dark, orange, service box, Three Boxes, features, three columns, icon, flip box'],
	        '300' => ['interior, Light, orange, team members, support, staff, four columns, carousel, slider, slides'],
	        '301' => ['interior, Light, orange, hotspot, image, photo, showcase, title, full, interactive'],
	        '302' => ['interior, Dark, orange, number, counter, three columns'],
	        '303' => ['interior, Light, orange, about, two columns, history, progress bar'],
	        '304' => ['interior, Dark, orange, social icons, instagram, facebook, dribbble, youtube, box'],
	        '305' => ['interior, Dark, orange, service box, Three Boxes, features, three columns, icon, flip box'],
	        '306' => ['interior, Dark, orange, questions, ask, email, cta'],
	        '307' => ['interior, Dark, orange, tab, content'],
	        '308' => ['interior, Light, orange, two buttons, cta, call to action'],
	        '309' => ['interior, Light, orange, icon, contact, Three Columns, minimal, address, email, phone'],
	        '310' => ['interior, Dark, orange, contact form, address, map, google maps,two columns'],
			'311' => ['Beauty Salon 2, Light, purple, about, Two Columns, text, title'],
	        '312' => ['Beauty Salon 2, Light, purple, service box, 3 Columns, icon, title '],
	        '313' => ['Beauty Salon 2, Light, purple, gallery, images'],
	        '314' => ['Beauty Salon 2, Light, purple, team members, support, staff, three columns, carousel, slider, slides'],
	        '315' => ['Beauty Salon 2, Light, purple, Sponsors, Logo, brand, 5 Columns, five'],
	        '316' => ['Beauty Salon 2, Light, purple, Testimonials, quote, Carousel, slider, slides, three columns'],
	        '317' => ['Beauty Salon 2, Light, purple, about, two columns, social, icons'],
	        '318' => ['Beauty Salon 2, Light, purple, number, counter, four columns, title'],
	        '319' => ['Beauty Salon 2, Light, purple, about, Two Columns, stylish list, text, title'],
	        '320' => ['Beauty Salon 2, Light, purple, Testimonials, quote, Carousel, slider, slides'],
	        '321' => ['Beauty Salon 2, Light, purple, gallery, images, metro, title'],
	        '322' => ['Beauty Salon 2, Light, purple, gallery, images, Carousel, slider, slides, four columns'],
	        '323' => ['Beauty Salon 2, Light, purple, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle'],
	        '324' => ['Beauty Salon 2, Light, purple, icon, contact, Three Columns, minimal, address, email, phone'],
	        '325' => ['Beauty Salon 2, Light, purple, contact form, address, map, google maps'],
	        '326' => ['Beauty Salon 2, Light, purple, icon, social icons, instagram, facebook, phone, email, linkedin, twitter'],
	        '327' => ['Web Agency, Light, blue, service box, Three Boxes, features, three columns, icon'],
	        '328' => ['Web Agency, Light, blue, parallax, images, 1 column, why, title'],
	        '329' => ['Web Agency, Light, blue, number, counter, four columns'],
	        '330' => ['Web Agency, Dark, blue, about, Two Columns, text, title'],
	        '331' => ['Web Agency, Light, blue, tab, tabbed, two columns'],
	        '332' => ['Web Agency, Light, blue, features, app, stylish list, download, mobile, android, ios, two columns'],
	        '333' => ['Web Agency, Dark, blue, showcase, carousel, slide, slider, works, '],
	        '334' => ['Web Agency, Light, blue, Sponsors, Logo, brand, four Columns'],
	        '335' => ['Web Agency, Dark, blue, service box, 3 Columns, icon, call to action, cta'],
	        '336' => ['Web Agency, Dark, blue, number, counter, three columns'],
	        '337' => ['Web Agency, Light, blue, about, Two Columns, text, title, fullwide, fullwidth'],
	        '338' => ['Web Agency, Dark, blue, team members, support, staff, three columns'],
	        '339' => ['Web Agency, Light, blue, Sponsors, Logo, brand, four Columns, carousel, slide, slider'],
	        '340' => ['Web Agency, Light, blue, about, text, title'],
	        '341' => ['Web Agency, Dark, blue, about, text, box, cta , call to action'],
	        '342' => ['Web Agency, Light, blue, pricing, three columns'],
	        '343' => ['Web Agency, Dark, blue, cta, contac, icon, text, box, call to action'],
	        '344' => ['Web Agency, Light, blue, about, two columns, stylish list, features, laptop'],
	        '345' => ['Web Agency, Light, blue, service box, 3 Columns, icon, call to action, cta'],
	        '346' => ['Web Agency, Light, blue, projects details, four columns, portfolio, spec'],
	        '347' => ['Web Agency, Light, blue, projects details, slider, carousel, portfolio, spec'],
	        '348' => ['Web Agency, Light, blue, projects details, portfolio, spec'],
	        '349' => ['Web Agency, Light, blue, projects details, slider, carousel, portfolio, spec, three columns'],
	        '350' => ['Web Agency, Light, blue, contact form, address, map, google maps, icons, phone, email'],
	        '351' => ['Event, Dark, purple, green, sponsor, logo, data, location'],
	        '352' => ['Event, Light, purple, green, video, player, two columns, about, button'],
	        '353' => ['Event, Light, purple, green, number, counter, four columns, title'],
	        '354' => ['Event, Light, purple, green, gallery, images, grid, lightbox, zoom'],
	        '355' => ['Event, Light, purple, green, countdown, two columns, timer, time'],
	        '356' => ['Event, Dark, purple, green, Sponsors, Logo, brand, five Columns'],
	        '357' => ['Event, Light, purple, green, team members, support, staff, three columns'],
	        '358' => ['Event, Light, purple, green, tab, tabbed, schedule, timeline, program'],
	        '359' => ['Event, Light, purple, green, pricing, three columns'],
	        '360' => ['Event, Light, purple, green, about, two columns, stylish list, history'],
	        '361' => ['Event, Light, purple, green, Testimonials, quote, Carousel, slider, slides, three columns'],
	        '362' => ['Event, Light, purple, green, contact, cta, call to action, phone number, box'],
	        '363' => ['Event, Light, purple, green, video, player, two columns, about, button, stylish list'],
	        '364' => ['Event, Light, purple, green, schedule, timeline, program'],
	        '365' => ['Event, Light, purple, green, about, person, speaker, single, social, icons, schedule'],
	        '366' => ['Event, Light, purple, green, title, faq, call us, cta, call to action, question'],
	        '367' => ['Event, Light, purple, green, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle'],
	        '368' => ['Event, Light, purple, green, icon, contact, Three Columns, minimal, address, email, phone'],
	        '369' => ['Event, Light, purple, green, contact form, address, map, google maps, call us, phone, email'],
	        '370' => ['Construction, Dark, navy blue, orange, service box, four Boxes, features, four columns, icon'],
	        '371' => ['Construction, Light, navy blue, orange, about, two columns, stylish list, history'],
	        '372' => ['Construction, Dark, navy blue, orange, hero, fullwide, fullwidth, animated text , get a quote'],
	        '373' => ['Construction, Light, navy blue, orange, projects, four columns, gallery, works, showcase'],
	        '374' => ['Construction, Dark, navy blue, orange, hero, fullwide, fullwidth, two buttons, background'],
	        '375' => ['Construction, Light, navy blue, orange, two columns, sponsor, logo, clients, testimonials, quote, carousel, slider, slide'],
	        '376' => ['Construction, Dark, navy blue, orange, team, members, staff, three columns, carousel, slider, slides'],
	        '377' => ['Construction, Light, navy blue, orange, address, map, google maps, phone, email, fullwidth, fullwide'],
	        '378' => ['Construction, Light, navy blue, orange, about, Two Columns, text, title, stylish list, features'],
	        '379' => ['Construction, Dark, navy blue, orange, number, counter, four columns, hero, background, fullwide, fullwidth'],
	        '380' => ['Construction, Light, navy blue, orange, service box, four Boxes, features, four columns, icon, title'],
	        '381' => ['Construction, Dark, navy blue, orange, hero, fullwide, fullwidth, testimonials, quote, background, carousel,slider'],
	        '382' => ['Construction, Light, navy blue, orange, service box, three Boxes, features, three columns, icon, title'],
	        '383' => ['Construction, Light, navy blue, orange, service box, three Boxes, features, three columns, icon, button'],
	        '384' => ['Construction, Light, navy blue, orange, projects, metro, gallery, works, showcase'],
	        '385' => ['Construction, Light, navy blue, orange, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title, call us'],
	        '386' => ['Construction, Light, navy blue, orange, icon, contact, Three Columns, minimal, address, email, phone'],
	        '387' => ['Construction, Dark, navy blue, orange, contact form, address, map, google maps, call us, phone, email'],
	        '388' => ['Travel, Light, blue, service box, three Boxes, features, three columns, icon, title'],
	        '389' => ['Travel, Dark, blue, text, two columns, button, video, about, description'],
	        '390' => ['Travel, Light, blue, tab, tabbed, icon, content'],
	        '391' => ['Travel, Dark, blue, hero, fullwide, fullwidth, video, cta, call to action, wedding'],
	        '392' => ['Travel, Light, blue, package, carousel, slider, slides, tour, portfolio, works'],
	        '393' => ['Travel, Light, blue, hotspot, image, photo, showcase, title, full, interactive, world, map, world, branches'],
	        '394' => ['Travel, Dark, blue, cta, call to action, box, button,'],
	        '395' => ['Travel, Dark, blue, number, counter, four columns, hero, background, fullwide, fullwidth, icon'],
	        '396' => ['Travel, Light, blue, blog, posts, metro style, news'],
	        '397' => ['Travel, Light, blue, icons, fullwide, fullwidth, background, join us, subscribe, newsletter, logo, phone, address,email'],
	        '398' => ['Travel, Light, blue, service box, three Boxes, features, three columns, icon, title'],
	        '399' => ['Travel, Dark, blue, hero, text, description, two buttons, cta, call to action'],
	        '400' => ['Travel, Light, blue, about, Two Columns, text, title, history, image'],
	        '401' => ['Travel, Light, blue, about, Two Columns, text, title, history, image'],
	        '402' => ['Travel, Light, blue, about, Two Columns, text, title, history, image, skills, progress bar, stats,'],
	        '403' => ['Travel, Dark, blue, cta, call to action, box, button, title'],
	        '404' => ['Travel, Light, blue, number, counter, four columns, icon'],
	        '405' => ['Travel, Light, blue, ponsors, Logo, brand, three Columns, two rows'],
	        '406' => ['Travel, Light, blue, icon, contact, Three Columns, minimal, address, email, phone'],
	        '407' => ['Travel, Light, blue, contact form, address, map, google maps'],
	        '408' => ['Travel, Light, blue, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title'],
	        '409' => ['Flower Shop, Light, green, cta, call to action, button, featured, flower'],
	        '410' => ['Flower Shop, Light, green, shop, grid, products, flower, plants, add to cart'],
	        '411' => ['Flower Shop, Light, green, hero, carousel, description, slides, slider, fullwide, fullwidth, background'],
	        '412' => ['Flower Shop, Light, green, category, flower, plants, masonry, grid'],
	        '413' => ['Flower Shop, Light, green, video, fullwide, how it works, overlay, text, button, read more'],
	        '414' => ['Flower Shop, Light, green, about, two columns, history, stylish list, text, title, experience, image'],
	        '415' => ['Flower Shop, Light, green, video, about, icon, history, text, title'],
	        '416' => ['Flower Shop, Dark, green, number, counter, four columns, statistics'],
	        '417' => ['Flower Shop, Light, green, Testimonials, quote, Carousel, slider, slides, fullwide, fullwidth, one column'],
	        '418' => ['Flower Shop, Light, green, icon, contact, Three Columns, minimal, address, email, phone'],
	        '419' => ['Flower Shop, Light, green, contact form, address, map, google maps'],
	        '420' => ['Flower Shop, Light, green, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title'],
	        '421' => ['Advisor, Light, orange, box, call us, phone, experience, years, consultation'],
	        '422' => ['Advisor, Light, orange, about, title, button, text'],
	        '423' => ['Advisor, Light, orange, hero, cta, call to action, services, two columns, two boxes, icon, background, fullwide, fullwidth'],
	        '424' => ['Advisor, Light, orange, number, counter, three columns, statistics, result, stats, box'],
	        '425' => ['Advisor, Light, orange, how is works, steps, strategy, two columns, grid'],
	        '426' => ['Advisor, Light, orange, two buttons, video, player, fullwide, fullwidth, about, two columns'],
	        '427' => ['Advisor, Light, orange, Testimonials, quote, Carousel, slider, slides, one column'],
	        '428' => ['Advisor, Light, orange, team, members, staff, carousel, slides, three columns'],
	        '429' => ['Advisor, Light, orange, Sponsors, Logo, brand, five Columns'],
	        '430' => ['Advisor, Dark, orange, cta, call to action, call us, phone, box, icon'],
	        '431' => ['Advisor, Light, orange, about, Two Columns, text, title, history, image, stylish list, years, experience'],
	        '432' => ['Advisor, Light, orange, number, counter, four columns, statistics, result, stats, fullwide, fullwidth, particles,background'],
	        '433' => ['Advisor, Light, orange, team, members, staff, four columns, grid'],
	        '434' => ['Advisor, Dark, orange, Sponsors, Logo, brand, four Columns, particles, background'],
	        '435' => ['Advisor, Light, orange, Testimonials, quote, Carousel, slider, slides, two column'],
	        '436' => ['Advisor, Light, orange, service, box, icon, three columns, title'],
	        '437' => ['Advisor, Dark, orange, cta, call to action, call us, phone, box, icon'],
	        '438' => ['Advisor, Dark, orange, how is works, strategy, two columns, about, image'],
	        '439' => ['Advisor, Light, orange, pricing table, three columns'],
	        '440' => ['Advisor, Light, orange, how is works, steps, strategy, four columns, grid'],
	        '441' => ['Advisor, Light, orange, two buttons'],
	        '442' => ['Advisor, Light, orange, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title'],
	        '443' => ['Advisor, Light, orange, icon, contact, Three Columns, minimal, address, email, phone'],
	        '444' => ['Advisor, Light, orange, contact form, address, map, google maps'],
	        '445' => ['Advisor, Light, orange, social, icons, instagram, facebook, twitter, email, linkedin'],
	        '446' => ['Seo 2, Light, blue, service, box, icon, three columns, title'],
	        '447' => ['Seo 2, Dark, blue, about, title, button, text, image, stats, number'],
	        '448' => ['Seo 2, Light, blue, service, box, icon, three columns, title, grid, image'],
	        '449' => ['Seo 2, Dark, blue, hero, video player, button, fullwidth, fullwide, particles, background'],
	        '450' => ['Seo 2, Dark, blue, about, title, button, text, image, stylish list, features'],
	        '451' => ['Seo 2, Light, blue, testimonials, quote, three columns, grid'],
	        '452' => ['Seo 2, Light, blue, newsletter, pricing, monthly, yearly, three columns, subscribe, background'],
	        '453' => ['Seo 2, Dark, blue, two columns, faq, Frequently asked questions, Toggle, Accordion, image'],
	        '454' => ['Seo 2, Light, blue, blog, posts, three columns, news'],
	        '455' => ['Seo 2, Dark, blue, cta, call to action, box, background'],
	        '456' => ['Seo 2, Light, blue, about, title, button, text, image, stylish list, features'],
	        '457' => ['Seo 2, Dark, blue, about, title, stylish list, features, icons'],
	        '458' => ['Seo 2, Light, blue, number, counter, three columns, statistics, result, stats'],
	        '459' => ['Seo 2, Dark, blue, testimonials, quote, three columns, grid'],
	        '460' => ['Seo 2, Light, blue, Sponsors, Logo, brand, six Columns'],
	        '461' => ['Seo 2, Light, blue, service, box, icon, three columns, title, grid, image'],
	        '462' => ['Seo 2, Dark, blue, about, title, button, text, image, stats, number, progress bar, skills, video player'],
	        '463' => ['Seo 2, Light, blue, how is works, steps, strategy, four columns, grid'],
	        '464' => ['Seo 2, Dark, blue, contact, cta, call to action, button, fullwidth, fullwide'],
	        '465' => ['Seo 2, Light, blue, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title'],
	        '466' => ['Seo 2, Light, blue, icon, contact, Two Columns, address, email, phone, title'],
	        '467' => ['Seo 2, Dark, blue, contact form, address, map, google maps'],
	        '468' => ['Furniture, shop, Light, orange, two columns, experience, year, box, cta, call to action'],
	        '469' => ['Furniture, shop, Light, orange, category, six Columns, icon box, selection'],
	        '470' => ['Furniture, shop, Light, orange, hotspot, image, product, photo, details, interactive'],
	        '471' => ['Furniture, shop, Dark, orange, about, two columns, background, fullwide, fullwidth'],
	        '472' => ['Furniture, shop, Light, orange, tab, products, store, grid, three columns, two buttons, tabbed'],
	        '473' => ['Furniture, shop, Dark, orange, hero, two columns, image, cta , fullwide, fullwidth, background, parallax'],
	        '474' => ['Furniture, shop, Light, orange, Sponsors, Logo, five Columns, brands'],
	        '475' => ['Furniture, shop, Dark, orange, newsletter, footer, social, icons, phone, address, email, facebook, subscription, subscribe'],
	        '476' => ['Furniture, shop, Light, orange, about, history, two columns, skills, progress, video player'],
	        '477' => ['Furniture, shop, Dark, orange, number, counter, four columns, statistics, stats, background, fullwide, fullwidth'],
	        '478' => ['Furniture, shop, Light, orange, Testimonials, quote, Carousel, slider, slides, one column, fullwidth'],
	        '479' => ['Furniture, shop, Light, orange, Sponsors, Logo, four Columns, brands, carousel, slider, slides'],
	        '480' => ['Furniture, shop, Light, orange, faq, Frequently asked questions, ask, contact form, Accordion, answer, toggle, title'],
	        '481' => ['Furniture, shop, Light, orange, icon, contact, three Columns, address, email, phone, title'],
	        '482' => ['Furniture, shop, Light, orange, contact form, address, map, google maps'],
	        '483' => ['Startup, Light, purple, service box, two columns, icon, button, background'],
	        '484' => ['Startup, Light, purple, about, two columns, image, video, player, parallax, step'],
	        '485' => ['Startup, Light, purple, about, two columns, image, stylish list, features, parallax, step'],
	        '486' => ['Startup, Light, purple, about, two columns, image, buttons, cta, parallax, step'],
	        '487' => ['Startup, Light, purple, Sponsors, Logo, four Columns, brands, grid, background'],
	        '488' => ['Startup, Light, purple, pricing table, yearly, monthly, separator, divider, three columns, membership'],
	        '489' => ['Startup, Light, purple, faq, Frequently asked questions, Accordion, answer, toggle, title'],
	        '490' => ['Startup, Dark, purple, newsletter, subscription, subscribe, email, box, background'],
	        '491' => ['Startup, Light, purple, about, history, text, description, stylish list, features, two columns'],
	        '492' => ['Startup, Dark, purple, numbers, stats, statistics, counter, fullwidth, fullwide, background, particles'],
	        '493' => ['Startup, Light, purple, team, staff, members, carousel, slider, slides, three columns'],
	        '494' => ['Startup, Light, purple, our result, skills, progress, two columns, text'],
	        '495' => ['Startup, Light, purple, Sponsors, Logo, brand, grid, three columns'],
	        '496' => ['Startup, Light, purple, service box, two columns, icon, button, grid'],
	        '497' => ['Startup, Light, purple, service box, three columns, icon, button, grid'],
	        '498' => ['Startup, Dark, purple, how it works, steps, cta, call to action, fullwide, fullwidth'],
	        '499' => ['Startup, Light, purple, faq, Frequently asked questions, Accordion, answer, toggle, title'],
	        '500' => ['Startup, Light, purple, contact form, two columns, ask us, faq'],
	        '501' => ['Startup, Dark, purple, call us, phone, cta, call to action, fullwide, fullwidth, background, particles'],
	        '502' => ['Startup, Light, purple, icon, contact, three Columns, address, email, phone, title'],
	        '503' => ['Startup, Light, purple, contact form, address, map, google maps'],
	        '504' => ['Startup, Light, purple, social, icons, facebook, twitter, linkedin, instagram, email'],
	        '505' => ['Startup, Dark, purple, cta, call to action, consultations, box, icon, button'],

	        // B.
			'601' => [ 'Industrial, Light, Blue, Yellow, about, our team, who we are, since, details, info, brochure, company, hub, mission, vision, goal' ],
			'602' => [ 'Industrial, Light, Blue, Yellow, counter, stats, statistics, numbers, progress' ],
			'603' => [ 'Industrial, Light, Blue, Yellow, service, box, three, special, features' ],
			'604' => [ 'Industrial, Light, Blue, Yellow, call to action, particles, full, banner, ads, advertise, full backgorund, special' ],
			'605' => [ 'Industrial, Light, Blue, Yellow, services, overlay, stretch right, items, list' ],
			'606' => [ 'Industrial, Light, Blue, Yellow, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'607' => [ 'Industrial, Light, Blue, Yellow, phone, three, mobile, email, address, location, contact' ],
			'608' => [ 'Industrial, Light, Blue, Yellow, contact form, cf7, 7, send, request' ],
			'609' => [ 'Investment, Dark, Charcoal, Very Light Gray, trusted, famous, companies, box, logos, brands' ],
			'610' => [ 'Investment, Light, Charcoal, Very Light Gray, solutions, services, overlay, box, three, long, who, we, team, members, master, manager, founder' ],
			'611' => [ 'Investment, Light, Charcoal, Very Light Gray, counter, result, number, statistics, stats, hover, progress' ],
			'612' => [ 'Investment, Dark, Charcoal, Very Light Gray, mission, vision, about, list items, cases, what, can, do' ],
			'613' => [ 'Investment, Light, Charcoal, Very Light Gray, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'614' => [ 'Investment, Light, Charcoal, Very Light Gray, about, experience, years, quote, overlay, overflow, three, trust' ],
			'615' => [ 'Investment, Light, Charcoal, Very Light Gray, blog, posts, news, articles, updates, readmore' ],
			'616' => [ 'Investment, Light, Charcoal, Very Light Gray, call to action, box, banner, two buttons, appointment, make, request, contact' ],
			'617' => [ 'Investment, Light, Charcoal, Very Light Gray, history, counter, numbers, stats, statistics, result, progress, three, fixed, mission, vision' ],
			'618' => [ 'Investment, Light, Charcoal, Very Light Gray, team members, staff, support, title, founder, manager, three' ],
			'619' => [ 'Investment, Light, Charcoal, Very Light Gray, particles, counter, numbers, stats, statistics, result, progress, grid' ],
			'620' => [ 'Investment, Light, Charcoal, Very Light Gray, logos, brands, trusted, carousel, slider, arrow, customers' ],
			'621' => [ 'Investment, Light, Charcoal, Very Light Gray, services, solutions, list items, boxes, ideas, learn, four' ],
			'622' => [ 'Investment, Light, Charcoal, Very Light Gray, steps, process road, Horizontal, box, how works, lines' ],
			'623' => [ 'Investment, Light, Charcoal, Very Light Gray, featured, call to action, title, quote, overlay, stretch right' ],
			'624' => [ 'Investment, Light, Charcoal, Very Light Gray, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'625' => [ 'Investment, Light, Charcoal, Very Light Gray, contact form, cf7, 7, send, request, email, address, location, phone, mobile, box' ],
			'626' => [ 'Gardening, Light, Green, solutions, services, box, special four, featured' ],
			'627' => [ 'Gardening, Light, Green, about, company, vision, goal, list items, stylish, overlay' ],
			'628' => [ 'Gardening, Light, Green, years, experience, counter, numbers, stats, statistics, result, progress, three' ],
			'629' => [ 'Gardening, Light, Green, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'630' => [ 'Gardening, Light, Green, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'631' => [ 'Gardening, Light, Green, choose, choice, details, progress, bars, vision, why work us, how, experience, expert' ],
			'632' => [ 'Gardening, Dark, Green, separator, background, full, counter, result, number, statistics, stats, hover, progress' ],
			'633' => [ 'Gardening, Light, Green, team members, staff, support, title, founder, manager, three' ],
			'634' => [ 'Gardening, Light, Green, service, solutions, what we can do, simple' ],
			'635' => [ 'Gardening, Light, Green, price, pricing, table, package, subscription, order, buy, store, pay, full, background' ],
			'636' => [ 'Gardening, Light, Green, two row section, about, our vision, goals, overlay' ],
			'637' => [ 'Gardening, Light, Green, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'638' => [ 'Gardening, Light, Green, contact form, cf7, 7, send, request, email, address, location, phone, mobile, box' ],
			'639' => [ 'Gardening, Light, Green, google maps, marker, pin, office, location, address' ],
			'640' => [ 'Elderly Care, Light, Brown, services, solutions, round, Horizontal, 3d, curve, hover' ],
			'641' => [ 'Elderly Care, Light, Brown, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'642' => [ 'Elderly Care, Light, Brown, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'644' => [ 'Elderly Care, Light, Brown, Overlay, box, footer, call to action, button, box, background, logo, full, separator, svg' ],
			'645' => [ 'Elderly Care, Light, Brown, expert, experience, year, list items stylish, who we are, what we do, about, vision, goals, company' ],
			'646' => [ 'Elderly Care, Light, Brown, carousel, slider, separator, counter, result, number, statistics, stats, hover, progress' ],
			'647' => [ 'Elderly Care, Light, Brown, simple, title, description, center, call to action, middle' ],
			'648' => [ 'Elderly Care, Light, Brown, why choose us, progress, experience, expert, bars, information, two overlay' ],
			'649' => [ 'Elderly Care, Light, Brown, gallery, metro, title, description, center, images, photos' ],
			'650' => [ 'Elderly Care, Light, Brown, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'651' => [ 'Elderly Care, Light, Brown, ontact form, cf7, 7, send, request, email, address, location, phone, mobile, box' ],
			'652' => [ 'Car Rental, Light, Yellow, Services, features, intro packages, motor, automobile' ],
			'653' => [ 'Car Rental, Light, Yellow, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'654' => [ 'Car Rental, Light, Yellow, introduce, carousel, slider arrows, hidden, overflow, full' ],
			'655' => [ 'Car Rental, Dark, Yellow, stretch, full, separator, auto, counter, result, number, statistics, stats, hover, progress' ],
			'656' => [ 'Car Rental, Light, Yellow, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'657' => [ 'Car Rental, Dark, Yellow, footer, separator, call to action, logo, social icons, end' ],
			'658' => [ 'Car Rental, Light, Yellow, quote, request, booking, consultation, submit, form, contact, cf7' ],
			'659' => [ 'Car Rental, Light, Yellow, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'660' => [ 'Car Rental, Light, Yellow, logos, brands, trusted, clients, customers' ],
			'661' => [ 'Car Rental, Light, Yellow, about, company, list style, stylish, features, why us' ],
			'662' => [ 'Car Rental, Dark, Yellow, counter, stats, statistics, numbers, progress' ],
			'663' => [ 'Car Rental, Light, Yellow, introduce, tabs, tabbed, about, company, vision, features, list, mission' ],
			'664' => [ 'Car Rental, Dark, Yellow, video popup, inline, play, stats, statistics, numbers, progress bar' ],
			'665' => [ 'Car Rental, Light, Yellow, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'666' => [ 'Logistic, Light, Orange, transport, intro, banner, call to action, overlay, product' ],
			'667' => [ 'Logistic, Light, Orange, transport, overlay, services, packages, steps, road, why choose us, how' ],
			'668' => [ 'Logistic, Light, Orange, Categories, transport, tags, icon list, packages, Horizontal list' ],
			'669' => [ 'Logistic, Light, Orange, transport, ask, booking, consultation, quote, submit,request, form, contact, cf7, list style, stylish' ],
			'670' => [ 'Logistic, Dark, Orange, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'671' => [ 'Logistic, Light, Orange, transport, logos, brands, trusted, clients, customers, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'672' => [ 'Logistic, Light, Orange, two columns, stretch, fullwide, or, this that, two ways, different, transport' ],
			'673' => [ 'Logistic, Light, Orange, transport, about, company, list style, stylish, features, why us' ],
			'674' => [ 'Logistic, Light, Orange, transport, counter, stats, statistics, numbers, progress' ],
			'675' => [ 'Logistic, Dark, Orange, transport, team members, group, company, about us, ours, we, social, dark' ],
			'676' => [ 'Logistic, Light, Orange, transport, logos, brands, trusted, clients, customers' ],
			'677' => [ 'Logistic, Light, Orange, transport, overlay, services, packages, steps, road, why choose us, how' ],
			'678' => [ 'Logistic, Dark, Orange, particles, transport, call to action, banner, fullwide, stretch, intro, welcome' ],
			'679' => [ 'Logistic, Light, Orange, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'680' => [ 'Logistic, Light, Orange, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'681' => [ 'Logistic, Light, Orange, details, info, Contact, icon list, stylish, phone, email, address, location' ],
			'682' => [ 'Logistic, Light, Orange, google maps, contact form, cf7, appointment, request, send, submit, address, location, list' ],
			'683' => [ 'Business 2, Dark, Blue, Services, box, intro, introduce, welcome banner, overlay, list style, title & icon' ],
			'684' => [ 'Business 2, Dark, Blue, mission, vision, goal, banner, group, list, Horizontal, service, boxes, hover' ],
			'685' => [ 'Business 2, Dark, Blue, features, full, stretch, light, stylish list, title icon, image icon' ],
			'686' => [ 'Business 2, Dark, Blue, team members, our, us, who, staff, support, engineer, founder, manager, four, social media' ],
			'687' => [ 'Business 2, Dark, Blue, two banner, big, full, stretch, wide, image, background, two columns' ],
			'688' => [ 'Business 2, Dark, Blue, counter, stats, statistics, numbers, progress' ],
			'689' => [ 'Business 2, Dark, Blue, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'690' => [ 'Business 2, Dark, Blue, about, two section, image, vision, goal, company, mission, list, style, stylish, us, our, who we are' ],
			'691' => [ 'Business 2, Dark, Blue, particles, light, full, counter, stats, statistics, numbers, progress' ],
			'692' => [ 'Business 2, Dark, Blue, logos, brands, trusted, clients, customers' ],
			'693' => [ 'Business 2, Dark, Blue, hidden, back, flip box, hover box, content, template' ],
			'694' => [ 'Business 2, Dark, Blue, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'695' => [ 'Business 2, Dark, Blue, google maps, contact form, cf7, appointment, request, send, submit, address, location, list' ],
			'696' => [ 'Home Renovation, Light, Blue, Orange, mission, about, company, tabs, tabbed, caption, list style, stylish, features, strategy, box, overlay' ],
			'697' => [ 'Home Renovation, Light, Blue, Orange, before after, video popup, watch, see, how we work, project, old new' ],
			'698' => [ 'Home Renovation, Light, Blue, Orange, counter, stats, statistics, numbers, progress, full, stretch' ],
			'699' => [ 'Home Renovation, Light, Blue, Orange, services, metro, boxes, what we do, can, features, fullwide, full row, stretch, two' ],
			'700' => [ 'Home Renovation, Light, Blue, Orange, work, process, progress, steps, how works, points, when, time' ],
			'701' => [ 'Home Renovation, Light, Blue, Orange, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, clients, customers, trusted' ],
			'702' => [ 'Home Renovation, Dark, Blue, Orange, full, stretch, projects, portfolio, cpt, grid, 8 items, four columns, posts' ],
			'703' => [ 'Home Renovation, Light, Blue, Orange, call to action, quote, button, submit, request, consultation, free, box' ],
			'704' => [ 'Home Renovation, Light, Blue, Orange, posts, blog, news, updates, articles, subscription, form, newsletter, cpt' ],
			'705' => [ 'Home Renovation, Light, Blue, Orange, content box, grid, left right, four columns, side image, features, services, boxes' ],
			'706' => [ 'Home Renovation, Dark, Blue, Orange, particles, light, full, counter, stats, statistics, numbers, progress' ],
			'707' => [ 'Home Renovation, Light, Blue, Orange, about, company, vision, goal, list items, stylish, overlay' ],
			'708' => [ 'Home Renovation, Light, Blue, Orange, popular, services, features, boxes, hexagon, box, hover, active, what we do, can' ],
			'709' => [ 'Home Renovation, Light, Blue, Orange, content box, grid, four columns, side image, top bottom, up down, features, services, boxes' ],
			'710' => [ 'Home Renovation, Light, Blue, Orange, request, quote, consultation, form, contact, free, price, get, list style, stylish, features' ],
			'711' => [ 'Home Renovation, Light, Blue, Orange, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'712' => [ 'Home Renovation, Light, Blue, Orange, faq, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'713' => [ 'Home Renovation, Light, Blue, Orange, single, project, post, metro, gallery, details, information' ],
			'714' => [ 'Home Renovation, Light, Blue, Orange, box, contact form, cf7, appointment, request, send, submit, address, location, list' ],
			'715' => [ 'SEO 2, Light, Blue, Navy, serivces, features, three columns, colorful, affordable, our work' ],
			'716' => [ 'SEO 2, Dark, Blue, Navy, about us, company, our, we, counter, stats, statistics, numbers, introduce' ],
			'717' => [ 'SEO 2, Light, Blue, Navy, why choose us, services, features, boxes, needs, packages, category, what we do' ],
			'718' => [ 'SEO 2, Light, Blue, Navy, particles, video popup, player, full, stretch, wide, icon, background, call to action' ],
			'719' => [ 'SEO 2, Dark, Blue, Navy, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'720' => [ 'SEO 2, Light, Blue, Navy, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted' ],
			'721' => [ 'SEO 2, Light, Blue, Navy, subscription, newsletter, form, email, plans, price, pricing, table, package, subscription, order, buy, store, pay, tabs, tabbed' ],
			'722' => [ 'SEO 2, Dark, Blue, Navy, Accordion, faq, Frequently, asked, question, common, taggle, hidden' ],
			'723' => [ 'SEO 2, Light, Blue, Navy, posts, blog, news, updates, articles, cpt' ],
			'724' => [ 'SEO 2, Light, Blue, Navy, call to action, box, background, overlay, icon title, button' ],
			'725' => [ 'SEO 2, Light, Blue, Navy, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'726' => [ 'SEO 2, Light, Blue, Navy, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success, icon title, what we can do' ],
			'727' => [ 'SEO 2, Light, Blue, Navy, counter, stats, statistics, numbers, progress, full, stretch, why choose us, expert' ],
			'728' => [ 'SEO 2, Dark, Light, Blue, Navy, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted' ],
			'729' => [ 'SEO 2, Light, Blue, Navy, why choose us, overlay, experience, services, features, boxes, modern, icon box' ],
			'730' => [ 'SEO 2, Dark, Blue, Navy, progress bar, numbers, stats, statistics, video popup, player, full, stretch, wide, advantages, solid' ],
			'731' => [ 'SEO 2, Light, Blue, Navy, steps, process road, Horizontal, numbers, columns, timeline, how works, points' ],
			'732' => [ 'SEO 2, Light, Blue, Navy, simple, call to action, solid background, full, wide' ],
			'733' => [ 'SEO 2, Light, Blue, Navy, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'734' => [ 'SEO 2, Light, Blue, Navy, contact details, information, image title, icon title' ],
			'735' => [ 'SEO 2, Light, Blue, Navy, google maps, contact form, cf7, appointment, request, send, submit, address, location' ],
			'736' => [ 'Digital Marketing 2, Light, Purple, Orange, red, hero, section, introduce, welcome, about, company, two buttons, headline, big title, background, wide, full' ],
			'737' => [ 'Digital Marketing 2, Light, Purple, Orange, red, services,  features, boxes, modern, experience, categories' ],
			'738' => [ 'Digital Marketing 2, Light, Purple, Orange, red, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, success, who we are' ],
			'739' => [ 'Digital Marketing 2, Light, Purple, Orange, red, services,  features, boxes, modern, experience, categories, vertical' ],
			'740' => [ 'Digital Marketing 2, Light, Purple, Orange, red, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, success' ],
			'741' => [ 'Digital Marketing 2, Light, Purple, Orange, red, modern, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted' ],
			'742' => [ 'Digital Marketing 2, Light, Purple, Orange, red, posts, blog, news, updates, articles, cpt, carousel, overflow, slider, arrows, modern' ],
			'743' => [ 'Digital Marketing 2, Light, Purple, Orange, red, footer, end, last, contact, contact-form-7, cf7, submit, request, consultation, phone, email ,address, social icons' ],
			'744' => [ 'Digital Marketing 2, Light, Purple, Orange, red, about us, our company, who we are, title and description, two' ],
			'745' => [ 'Digital Marketing 2, Light, Purple, Orange, red, year, timeline, steps, date, company, when, how, history, line, road, Horizontal, see' ],
			'746' => [ 'Digital Marketing 2, Light, Purple, Orange, red, quote, hero, company, about, what we do, mission, goal, vision, manager, important' ],
			'747' => [ 'Digital Marketing 2, Light, Purple, Orange, red, Team members, group, company, about us, ours, we, social' ],
			'748' => [ 'Digital Marketing 2, Light, Purple, Orange, red, Accordion, faq, Frequently, asked, question, common, taggle, hidden' ],
			'749' => [ 'Digital Marketing 2, Light, Purple, Orange, red, services,  features, boxes, modern, experience, categories' ],
			'750' => [ 'Digital Marketing 2, Light, Purple, Orange, red, quote, hero, company, about, what we do, mission, goal, testimonial, customer, client, special, vision, manager, important' ],
			'751' => [ 'Digital Marketing 2, Light, Purple, Orange, red, about us, our company, who we are, title and description, two' ],
			'752' => [ 'Digital Marketing 2, Light, Purple, Orange, red, counter, stats, statistics, numbers, progress, full, stretch, why choose us, expert' ],
			'753' => [ 'Digital Marketing 2, Light, Purple, Orange, red, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'754' => [ 'Digital Marketing 2, Light, Purple, Orange, red, google maps, contact form, cf7, appointment, request, send, submit, address, location' ],
			'755' => [ 'Logistic 2, Light, Yellow, Navy Blue, Hero, section, welcome, intro, introduce, banner, button, headline heading, title' ],
			'756' => [ 'Logistic 2, Light, Yellow, Navy Blue, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'757' => [ 'Logistic 2, Light, Yellow, Navy Blue, counter, stats, statistics, numbers, progress, full, stretch, separator, box, hover, banner, services, features content box' ],
			'758' => [ 'Logistic 2, Light, Yellow, Navy Blue, services,  features, boxes, modern, experience, categories' ],
			'759' => [ 'Logistic 2, Light, Yellow, Navy Blue, quote, review, trusted, customer, client, special, say' ],
			'760' => [ 'Logistic 2, Light, Yellow, Navy Blue, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success, counter, stats, statistics, numbers, progress' ],
			'761' => [ 'Logistic 2, Light, Yellow, Navy Blue, footer, contact form, cf7, contact box appointment, request, send, submit, address, location' ],
			'762' => [ 'Logistic 2, Light, Yellow, Navy Blue, three boxes, separator, boxes, steps, tracking, when, time' ],
			'763' => [ 'Logistic 2, Light, Yellow, Navy Blue, image box, services, features, image list, separator, divider' ],
			'765' => [ 'Logistic 2, Light, Yellow, Navy Blue, quote, free, consultation, contact form, cf7, request, submit, send, form' ],
			'766' => [ 'Logistic 2, Light, Yellow, Navy Blue, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'767' => [ 'Logistic 2, Light, Yellow, Navy Blue, experience, years, list stylish, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'768' => [ 'Logistic 2, Light, Yellow, Navy Blue, counter, stats, statistics, numbers, progress, full, stretch, separator, box, content box' ],
			'769' => [ 'Logistic 2, Light, Yellow, Navy Blue, who we are, progress bar, process, stats, statistics, numbers, progress, stretch, two images' ],
			'770' => [ 'Logistic 2, Light, Yellow, Navy Blue, why us, expert, features, experience, three, overlay, box' ],
			'771' => [ 'Logistic 2, Light, Yellow, Navy Blue, google maps, contact form, cf7, appointment, request, send, submit, address, location' ],
			'772' => [ 'Logistic 2, Light, Yellow, Navy Blue, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'773' => [ 'Gardening 2, Light, Green, Hero, section, welcome, intro, introduce, banner, button, headline heading, title, gallery, images, special' ],
			'774' => [ 'Gardening 2, Light, Green, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'775' => [ 'Gardening 2, Light, Green, call to action, two images, columns, overlay, button, title' ],
			'776' => [ 'Gardening 2, Light, Green, services,  features, boxes, modern, experience, categories' ],
			'777' => [ 'Gardening 2, Light, Green, counter, stats, statistics, numbers, progress, full, stretch' ],
			'778' => [ 'Gardening 2, Light, Green, list stylish, icon list, horizontal, separator, divider, services,  features, modern, experience, categories' ],
			'779' => [ 'Gardening 2, Light, Green, modern, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted' ],
			'780' => [ 'Gardening 2, Light, Green, contact form, cf7, appointment, request, send, submit, address, location' ],
			'781' => [ 'Gardening 2, Light, Green, what do we offer, services, vertical, icon box, features, boxes, two four, simple' ],
			'782' => [ 'Gardening 2, Light, Green, how we work, step by step, how it works, timeline, numbers, when, start' ],
			'783' => [ 'Gardening 2, Light, Green, metro gallery, images, photos, center image big, special image' ],
			'784' => [ 'Gardening 2, Light, Green, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'785' => [ 'Gardening 2, Light, Green, about, video, player, popup, history, story, company, who we are' ],
			'786' => [ 'Gardening 2, Light, Green, counter, stats, statistics, numbers, progress, full, stretch' ],
			'787' => [ 'Gardening 2, Light, Green, google maps, contact, email, address, location, phone, box, mobile, support' ],
			'788' => [ 'Gardening 2, Light, Green, google maps, contact form, cf7, appointment, request, send, submit, address, location' ],
			'789' => [ 'Gardening 2, Light, Green, social icons, facebook, instagram, twitter, x, youtube' ],
			'790' => [ 'Gardening 2, Light, Green, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'791' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, intro, banner, call to action, overlay, product' ],
			'792' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, about us, company, storyline, Accordion, toggle, info, questions, answers, common' ],
			'793' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, video popup player, youtube, vimeo, fullwide, stretch, overlay' ],
			'794' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, services, boxes, features, call to action, button, read more, quote, consultation, free, special box' ],
			'795' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'796' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, full, background, stretch, projects, portfolio, cpt, grid, works, post type, posts' ],
			'797' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, modern, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted, logos, brands, box border' ],
			'798' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, posts, blog, news, updates, articles, cpt' ],
			'799' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, steps, process road, Horizontal, numbers, columns, timeline, how works, points' ],
			'800' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'801' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, counter, stats, statistics, numbers, progress, full, stretch, title, headline, overlay' ],
			'802' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'803' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'804' => [ 'Plumbing, Light, Yellow, Navy Blue, transport, google maps, contact form, cf7, appointment, request, send, submit, address, location, email, address, location, phone, box, mobile, support' ],
			'805' => [ 'Nail Salon, Light, Brown, Gold, services, boxes, features, call to action, button, read more, special box' ],
			'806' => [ 'Nail Salon, Light, Brown, Gold, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success, experience, number' ],
			'807' => [ 'Nail Salon, Light, Brown, Gold, special, intro, separator, divider, counter, number, statistics, numbers, progress, stats' ],
			'808' => [ 'Nail Salon, Light, Brown, Gold, call to action, two images, columns, overlay, button, title' ],
			'809' => [ 'Nail Salon, Light, Brown, Gold, team members, staff, support, engineer, founder, manager, two, special, group' ],
			'810' => [ 'Nail Salon, Light, Brown, Gold, tabs, tabbed, about, company, mission, vision, benefit, goal, list style, stylish, features' ],
			'811' => [ 'Nail Salon, Light, Brown, Gold, full wide, gallery, images, photos, carousel, slider, arrows, modern, stretch' ],
			'812' => [ 'Nail Salon, Light, Brown, Gold, Testimonials, quote, Carousel, Slider, fade, Horizontal, Single' ],
			'813' => [ 'Nail Salon, Light, Brown, Gold, footer, contact, cf7, box appointment, logo, website, end, social, request, send, submit, address, location' ],
			'814' => [ 'Nail Salon, Light, Brown, Gold, particles, team members, staff, support, engineer, founder, manager, two, special, group' ],
			'815' => [ 'Nail Salon, Light, Brown, Gold, gallery, images, photos, carousel, slider, arrows' ],
			'816' => [ 'Nail Salon, Light, Brown, Gold, services, boxes, features, hover, round, four columns' ],
			'817' => [ 'Nail Salon, Light, Brown, Gold, two columns, working hours, days, weeks, closed, list, monday' ],
			'818' => [ 'Nail Salon, Light, Brown, Gold, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'819' => [ 'Rims, Light, Yellow, Gold, boxes, hover, steps, process road, Horizontal, numbers, columns, timeline, how works, points' ],
			'820' => [ 'Rims, Dark, Yellow, Gold, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'821' => [ 'Rims, Dark, Yellow, Gold, boxes, fullwide, stretch, background, prices, packages, plans, services, starting at, metro' ],
			'822' => [ 'Rims, Dark, Yellow, Gold, modern, testimonials, happy, quote, clients, customers, says, people, what, who, said, clients, customers, trusted, logos, brands, box border' ],
			'823' => [ 'Rims, Dark, Yellow, Gold, blog, posts, news, articles, updates, readmore, cpt, custom post type, center, middle, three columns, grid' ],
			'824' => [ 'Rims, Dark, Yellow, Gold, particles, about us, who we are, numbers, details, stats, statistics, company, progress, full, overlay' ],
			'825' => [ 'Rims, Dark, Yellow, Gold, timeline, history, story, process, steps, process road, vertical, box' ],
			'826' => [ 'Rims, Dark, Yellow, Gold, google maps, contact form, cf7, appointment, request, send, submit, address, location, email, address, location, phone, box, mobile, support' ],
			'827' => [ 'Big Shop, Light, Yellow, Blue, metro, special boxes, collections, category, introduce, products, packages, box background, store, market, woocommerce' ],
			'828' => [ 'Big Shop, Light, Yellow, Blue, categories, list styles, icon box, collections, packages, tags' ],
			'829' => [ 'Big Shop, Light, Yellow, Blue, special offer, section, row, fullwide, stretch, off, discount, overlay, parallax, ads, product, woo, market' ],
			'830' => [ 'Big Shop, Light, Yellow, Blue, brands, famous, logos, collection, products, woo, marks, category, tags' ],
			'831' => [ 'Big Shop, Light, Yellow, Blue, flash sale, badge, products, newsletter, subscription, subscribe, form, updates, email, overlay, border background' ],
			'832' => [ 'Big Shop, Light, Yellow, Blue, blog, posts, news, articles, updates, readmore, cpt, custom post type, center, middle, three columns, grid' ],
			'833' => [ 'Big Shop, Light, Yellow, Blue, carousel, slider, arrows, modern, footer, categories, tags, collection, products, woo, variations' ],
			'834' => [ 'Big Shop, Light, Yellow, Blue, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'835' => [ 'Big Shop, Light, Yellow, Blue, counter, stats, statistics, numbers, progress, full, stretch, title, headline, overlay' ],
			'836' => [ 'Big Shop, Light, Yellow, Blue, Testimonials, quote, Horizontal, Single, static, client, happy' ],
			'837' => [ 'Big Shop, Light, Yellow, Blue, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'838' => [ 'Big Shop, Light, Yellow, Blue, google maps, marker, pin, office, location, address, contact, details, information, boxes, overlay' ],
			'839' => [ 'Big Shop, Light, Yellow, Blue, contact form, cf7, appointment, request, send, submit, address, email' ],
			'840' => [ 'Big Shop, Light, Yellow, Blue, woocommerce, tracking orders, form, track order, store' ],
			'841' => [ 'Home Renovation 2, Light, Blue, intro, introduce, counter, number, statistics, numbers, progress, stats, full, overlay, circular button, title, headline' ],
			'842' => [ 'Home Renovation 2, Light, Blue, table, compare, features, three columns, why choose us' ],
			'843' => [ 'Home Renovation 2, Light, Blue, book, boxes, contact, phone, location, email, consultation' ],
			'844' => [ 'Home Renovation 2, Light, Blue, projects, portfolio, works, jobs, posts, cpt, post type, carousel, full, slider, arrows, modern' ],
			'845' => [ 'Home Renovation 2, Light, Blue, footer, logo, social icons, menus, widgets, quick access, contact info' ],
			'846' => [ 'Home Renovation 2, Light, Blue, services, icon image, what we do, boxes, rounded, home, what we do, mission, goals' ],
			'847' => [ 'Home Renovation 2, Light, Blue, call to action, box border, fullwidth, fullwide, stretch, about, company, mission, vision, benefit, goal, features, why us, road, success' ],
			'848' => [ 'Home Renovation 2, Light, Blue, price, pricing, table, package, subscription, order, buy, store, pay' ],
			'849' => [ 'Home Renovation 2, Light, Blue, project, single page, portfolio, two columns, project details information, list style, working hours' ],
			'850' => [ 'Home Renovation 2, Light, Blue, particles, counter, numbers, stats, statistics, numbers, progress, full, stretch, experience' ],
			'851' => [ 'Home Renovation 2, Light, Blue, video player, video popup, vertical service boxes, features, icon list, about us' ],
			'852' => [ 'Home Renovation 2, Light, Blue, team members, staff, support, engineer, founder, manager, three, fullwide, stretch' ],
			'853' => [ 'Home Renovation 2, Light, Blue, call to action, box, banner, call us, consultation, contact' ],
			'854' => [ 'Home Renovation 2, Light, Blue, google maps, marker, pin, form, cf7, office, location, address, contact, details, information, boxes, overlay' ],
			'855' => [ 'Music Band, Dark, Pink, Content box, overlay, music player, sound, audio, playlist, soundmanager, featured album, download, volume' ],
			'856' => [ 'Music Band, Dark, Pink, team members, staff, support, engineer, founder, manager, sticky title, headline' ],
			'857' => [ 'Music Band, Dark, Pink, albums, discography, fullwide, stretch, background, cpt, posts, update, releases' ],
			'858' => [ 'Music Band, Dark, Pink, events, tours, upcoming, festival, table list, ticket' ],
			'859' => [ 'Music Band, Dark, Pink, photo gallery, grid, images, flex, lighbox' ],
			'860' => [ 'Music Band, Dark, Pink, contact form, cf7, appointment, request, send, submit, information, overlay, box, background, fullwide' ],
			'861' => [ 'Music Band, Dark, Pink, newsletter, subscription, subscribe, form, updates, email, border box' ],
			'862' => [ 'Music Band, Dark, Pink, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'863' => [ 'Music Band, Dark, Pink, counter, stats, statistics, numbers, progress, full, stretch' ],
			'864' => [ 'Music Band, Dark, Pink, image gallery, photo gallery, carousel, single, center, slider, arrows' ],
			'865' => [ 'Music Band, Dark, Pink, logos, brands, customers, clients, famous, companies, trusted' ],
			'866' => [ 'Music Band, Dark, Pink, music player, sound, audio, playlist, soundmanager, featured album, download, volume' ],
			'867' => [ 'Music Band, Dark, Pink, metro, gallery, images, photos, grid, masonry' ],
			'868' => [ 'Music Band, Dark, Pink, form, cf7, office, location, address, contact from, details, information, boxes, overlay' ],
			'869' => [ 'Medical 2, Light, Pink, Yellow, Blue, intro, introduce, about, hero, contact, boxes, overflow, parallax, button, book, appointment' ],
			'870' => [ 'Medical 2, Light, Pink, Yellow, Blue, About us, company, features, contact form, appointment, request, quote, submit, say hello' ],
			'871' => [ 'Medical 2, Light, Pink, Yellow, Blue, why choose us, coutner, experience, numbers, stats, statistics' ],
			'872' => [ 'Medical 2, Light, Pink, Yellow, Blue, services, boxes, three columns, icon box, hover box, features' ],
			'873' => [ 'Medical 2, Light, Pink, Yellow, Blue, team members, staff, support, engineer, founder, manager, three, doctors' ],
			'874' => [ 'Medical 2, Light, Pink, Yellow, Blue, footer, working hours, days, weeks, closed, widgets, logo, button, book, booking, consultation' ],
			'875' => [ 'Medical 2, Light, Pink, Yellow, Blue, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'876' => [ 'Medical 2, Light, Pink, Yellow, Blue, tabs, tabbed, counter, stats, statistics, numbers, progress, full, stretch, about, company, mission, vision, benefit, goal' ],
			'877' => [ 'Medical 2, Light, Pink, Yellow, Blue, join, subscription, subscribe, newsletter, form, updates, mailing list, email' ],
			'878' => [ 'Medical 2, Light, Pink, Yellow, Blue, services, boxes, three columns, image box, hover box, features' ],
			'879' => [ 'Medical 2, Light, Pink, Yellow, Blue, call to action, image gallery slider carousel, photo slider, list style, stylish, features, why choose us, about us' ],
			'880' => [ 'Medical 2, Light, Pink, Yellow, Blue, how we works, abc, services process, process road, steps, points, when, 123' ],
			'881' => [ 'Medical 2, Light, Pink, Yellow, Blue, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'882' => [ 'Medical 2, Light, Pink, Yellow, Blue, contact information, address, location, email, phone, mobile, support, boxes, say hello' ],
			'883' => [ 'Medical 2, Light, Pink, Yellow, Blue, contact form, cf7, appointment, contact-form-7, send, submit, request, send message' ],
			'884' => [ 'Medical 2, Light, Pink, Yellow, Blue, make an appointment, request, quote, send message, book, booking, consultation, free' ],
			'885' => [ 'Pet Shop, Light, Green, Orange, hero, intro, introduce, about us, experience, icon list stylish, quote form, consultation, contact, appointment' ],
			'886' => [ 'Pet Shop, Light, Green, Orange, sertvices, features, boxes, list style, stylish, who we are, three, special section' ],
			'887' => [ 'Pet Shop, Light, Green, Orange, testimonials, clients, customers, says, people, what, who, said, carousel, slider, arrows, modern, quote, trusted, happy' ],
			'888' => [ 'Pet Shop, Light, Green, Orange, About us, company, features, contact, appointment, request, quote, submit, consultation' ],
			'889' => [ 'Pet Shop, Light, Green, Orange, counter, stats, statistics, numbers, progress, number list, our expert' ],
			'891' => [ 'Pet Shop, Light, Green, Orange, blog, posts, news, articles, updates, readmore, cpt, custom, carousel, slider, arrow' ],
			'892' => [ 'Pet Shop, Light, Green, Orange, our servicesm what we do, goals, features, boxes, four clumns, premium' ],
			'893' => [ 'Pet Shop, Light, Green, Orange, steps, points, full, stretch, wide, overlay, process, road, call to action, box, progress' ],
			'894' => [ 'Pet Shop, Light, Green, Orange, table, pricing, package, subscription, order, buy, store, pay, order, packages, ultimate' ],
			'895' => [ 'Pet Shop, Light, Green, Orange, call to action, half, box, banner, contact button, quick access' ],
			'896' => [ 'Pet Shop, Light, Green, Orange, testimonials, customers, clients, people, says, said, what, who, trusted, happy' ],
			'897' => [ 'Pet Shop, Light, Green, Orange, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'898' => [ 'Pet Shop, Light, Green, Orange, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'899' => [ 'Pet Shop, Light, Green, Orange, video player, video popup, about us, progress, numbers, stats, statistics, result, process' ],
			'900' => [ 'Business 6, Dark, Brown, hero, section, special, intro, introduce, about, title, headline, button' ],
			'901' => [ 'Business 6, Dark, Brown, boxes, services, border box, outlined, icon box, packages' ],
			'902' => [ 'Business 6, Dark, Brown, counter, two columns, numbers, stats, statistics, about, overlay, progress' ],
			'903' => [ 'Business 6, Dark, Brown, progress bars, numbers, stats, statistics, skills, experience, expert' ],
			'904' => [ 'Business 6, Dark, Brown, pricing, table, package, subscription, order, buy, store, pay, two columns, dollar' ],
			'905' => [ 'Business 6, Dark, Brown, faq, question, Frequently, asked, toggle, Accordion, answer, border box, show hide' ],
			'906' => [ 'Business 6, Dark, Brown, testimonials, clients, customers, says, people, what, who, said' ],
			'907' => [ 'Business 6, Dark, Brown, footer, logo, widgets, quick access, menus, social icons, list style, icon list' ],
			'908' => [ 'Business 6, Dark, Brown, footer, subscription, join, newsletter, form, email, mailing, updates' ],
			'910' => [ 'Business 6, Dark, Brown, list style, experience, about, company, mission, vision, benefit, goal, list style, stylish, features, why us, road, success' ],
			'911' => [ 'Business 6, Dark, Brown, counter, numbers, stats, statistics, result, progress, four boxes, progress bars, stretch, satisfied, information, data' ],
			'912' => [ 'Business 6, Dark, Brown, features box, slills, introduce, three icon box, image box' ],
			'913' => [ 'Business 6, Dark, Brown, team members, staff, support, engineer, founder, manager, four clumns, co-founder, head' ],
			'914' => [ 'Business 6, Dark, Brown, services, boxes, features, providing, what we do, what we can, packages' ],
			'915' => [ 'Business 6, Dark, Brown, call to action, overlay box, white, stretch, strategy, contact, form, quote, consultation, appointment, free, form box' ],
			'916' => [ 'Business 6, Dark, Brown, boxed, border box, outlined, icon box, packages, services, features, providing' ],
			'917' => [ 'Business 6, Dark, Brown, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'918' => [ 'Business 6, Dark, Brown, contact information, details, location, address, email, phone, icon list, circle, rounded, social icons' ],
			'919' => [ 'Business 6, Dark, Brown, google maps, marker, pin, form, cf7, office, location, address, contact, details, information, boxes' ],
			'920' => [ 'App 2, Light, Blue, Yellow, hero, first, intro, introduce, about, title, headline, application, mobile, phone, two buttons, logos, android, ios, apple, logo carousel' ],
			'921' => [ 'App 2, Light, Blue, features, boxes, services, applications, help, what we do, what we can do, overlay' ],
			'922' => [ 'App 2, Light, Blue, Yellow, video popup, video player, list style, stylish, icon list, title, about us, company, our team' ],
			'923' => [ 'App 2, Light, Blue, Yellow, what we provide, faq, question, Frequently, asked, Accordion, toggle, show, applications' ],
			'924' => [ 'App 2, Light, Blue, Yellow, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, arrows, simple' ],
			'925' => [ 'App 2, Light, Blue, Yellow, pricing, table, package, subscription, order, buy, store, pay, plan, lifetime, yearly, monthly' ],
			'926' => [ 'App 2, Light, Blue, Yellow, simple services, icon box, what we can do, packages, plans' ],
			'927' => [ 'App 2, Light, Blue, Yellow, about us, company, our, list style, stylish, icon list, single image, features' ],
			'928' => [ 'App 2, Light, Blue, Yellow, what we provide, faq, question, Frequently, asked, Accordion, toggle, show, applications' ],
			'929' => [ 'App 2, Light, Blue, Yellow, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'930' => [ 'SEO 3, Light, Orange, Red, Navy Blue, hero, first, intro, introduce, about, title, headline, two buttons, rocket, business' ],
			'931' => [ 'SEO 3, Light, Orange, Red, Navy Blue, full, solid color, services, features, image box, headline, title, logos, trusted clients, customers' ],
			'932' => [ 'SEO 3, Light, Orange, Red, Navy Blue, about our services, box, vertical, three, why choose us, target, goals' ],
			'933' => [ 'SEO 3, Light, Orange, Red, Navy Blue, pricing, table, package, subscription, order, buy, store, pay, full, overlay, plans, recommended' ],
			'934' => [ 'SEO 3, Light, Orange, Red, Navy Blue, overlay, counters, stats, statistics, numbers, progress, quotes, testimonials, companies, clients, case studies, stories' ],
			'935' => [ 'SEO 3, Light, Orange, Red, Navy Blue, blog, grid, posts, news, articles, updates, readmore, cpt, custom post type' ],
			'936' => [ 'SEO 3, Light, Orange, Red, Navy Blue, results, two columns vertical overlay, quote, consultation, testimonials, carousel, slides, arrows, analysis, traffic, boost' ],
			'937' => [ 'SEO 3, Light, Orange, Red, Navy Blue, footer, logo, copyright, widgets, social icons, menus, list' ],
			'938' => [ 'SEO 3, Light, Orange, Red, Navy Blue, rocket, how it works?, overlay boxes, features, goals, vision, mission, boost, help' ],
			'939' => [ 'SEO 3, Light, Orange, Red, Navy Blue, vertical, services boxes, features, what we can do, goals, targets, boxes, image box, icon box, jobs' ],
			'940' => [ 'SEO 3, Light, Orange, Red, Navy Blue, pricing, table, package, subscription, order, buy, store, pay overlay, boxes, image box, monthly, plans' ],
			'941' => [ 'SEO 3, Light, Orange, Red, Navy Blue, where can help, single image, simple, icon list, quick, footer' ],
			'942' => [ 'SEO 3, Light, Orange, Red, Navy Blue, simple, solid background, single image, counters, stats, statistics, numbers, progress, full, stretch' ],
			'943' => [ 'SEO 3, Light, Orange, Red, Navy Blue, faq, Accordion, toggle, Frequently, asked, question, common, testimonials, clients, customers, says, people, what, who, carousel, slider, arrow, quotes' ],
			'944' => [ 'SEO 3, Light, Orange, Red, Navy Blue, full backgorund image, call to action, space, button, stretch' ],
			'945' => [ 'SEO 3, Light, Orange, Red, Navy Blue, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'946' => [ 'SEO 3, Light, Orange, Red, Navy Blue, google maps, marker, pin, form, cf7, office, location, address, contact, details, information, boxes' ],
			'947' => [ 'Game, Dark, Blue, posts, news, games, vertical posts, carousel, slider, arrows, modern' ],
			'948' => [ 'Game, Dark, Blue, video popup, player, get, news ticker, posts, text news, trending, important news, subscribe, subscription, newsletter, form, email, mailing, updates' ],
			'949' => [ 'Game, Dark, Blue, right image, advertisement banner, banner box, overlay, png, off, discount, offer, special, call to action, ads' ],
			'950' => [ 'Game, Dark, Blue, left image, advertisement banner, banner box, overlay, png, off, discount, offer, special, call to action, ads' ],
			'951' => [ 'Game, Dark, Blue, about our services, box, vertical, three, why choose us, target, goals, list style, stylish, icon list, features, wha we do, who we are' ],
			'952' => [ 'Game, Dark, Blue, counters, stats, statistics, numbers, progress, boxes, process, experience, expert, clients' ],
			'953' => [ 'Game, Dark, Blue, testimonials, quote, clients, customers, says, people, what, who, said, simple' ],
			'954' => [ 'Game, Dark, Blue, contact information, details, location, address, email, phone, icon list, cube' ],
			'955' => [ 'Game, Dark, Blue, simple contact form, cf7, social icons' ],
			'956' => [ 'Metro Blog, Light, Black, posts, news, articles, updates, readmore, cpt, custom, metro, grid, masonry, isotope, ajax posts, minimal' ],
			'957' => [ 'Metro Blog, Light, Black, timeline, history, story, process, steps, process road, vertical, box' ],
			'958' => [ 'Metro Blog, Light, Black, contact form, box, information, details, location, address, email, phone, icon list, cube' ],
			'959' => [ 'Photography 3, Light, Black, lightbox, gallery, photos, images, grid, fit row gallery, row images, photographer, full section photos' ],
			'960' => [ 'Photography 3, Light, Black, about, why choose us, target, goals, list style, stylish, icon list, features, wha we do, who we are' ],
			'961' => [ 'Photography 3, Light, Black, counters, stats, statistics, numbers, progress, process, experience, expert' ],
			'962' => [ 'Photography 3, Light, Black, progress bars, numbers, stats, statistics, about us, who we are, expert team, skills' ],
			'963' => [ 'Photography 3, Light, Black, studio, sertvices, features, what we can do, goals, targets, boxes, three, packages' ],
			'964' => [ 'Photography 3, Light, Black, masonry, isotope, gallery, photos, images, lightbox, fit columns' ],
			'965' => [ 'Photography 3, Light, Black, phone, call, mobile, support, contact form, cf7, appointment, request, send, submit, consultation' ],
			'966' => [ 'Portfolio, Light, Black, posts, works, projects, portfolio, cpt, grid, masonry, filter, categories posts, headline, minimal, simple' ],
			'967' => [ 'Portfolio, Light, Black, studio, sertvices, features, what we can do, goals, targets, three, packages' ],
			'968' => [ 'Portfolio, Light, Black, call to action, simple minimal, button, consultation, quote' ],
			'969' => [ 'Portfolio, Light, Black, about us, studio, company, hover image caption, description' ],
			'970' => [ 'Portfolio, Light, Black, counters, stats, statistics, numbers, progress, process, experience, expert' ],
			'971' => [ 'Portfolio, Light, Black, progress bars, numbers, stats, statistics, about us, who we are, expert team, skills' ],
			'972' => [ 'Portfolio, Light, Black, phone, call, mobile, support, contact form, cf7, appointment, request, send, submit, consultation' ],
			'973' => [ 'Photographer 2, Dark, Black, Brown, hero, first section, introduce, welcome, about, call to action, headline, slider' ],
			'974' => [ 'Photographer 2, Dark, Black, Brown, video popup button, player, lightgallery, about me, studio, background layer dots' ],
			'975' => [ 'Photographer 2, Dark, Black, Brown, photos gallery, images, photography, grid, masonry, isotope, parallax, scroll' ],
			'976' => [ 'Photographer 2, Dark, Black, Brown, subscription, newsletter, form, email, mailing, updates, overlay layers, join now, good staff' ],
			'977' => [ 'Photographer 2, Dark, Black, Brown, news, posts, slider, carousel, arrows, post type, blog, journal, articles' ],
			'978' => [ 'Photographer 2, Dark, Black, Brown, about me, studio, features, stylish, list style box, icon list, icon box, biography' ],
			'979' => [ 'Photographer 2, Dark, Black, Brown, counters, stats, statistics, numbers, progress, process, experience, expert' ],
			'980' => [ 'Photographer 2, Dark, Black, Brown, progress bars, numbers, stats, statistics, overlay, about me, studio, photography' ],
			'981' => [ 'Photographer 2, Dark, Black, Brown, simple features box, boxes, three columns, services, studio' ],
			'982' => [ 'Photographer 2, Dark, Black, Brown, what we can do, services, icon box, vertical icon list, simple' ],
			'983' => [ 'Photographer 2, Dark, Black, Brown, our vision, goals, targets, simple about us, company, single image' ],
			'984' => [ 'Photographer 2, Dark, Black, Brown, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],
			'985' => [ 'Photographer 2, Dark, Black, Brown, contact information, icon box, icon list, email, support, location, social' ],
			'986' => [ 'Photographer 2, Dark, Black, Brown, contact form, box, information, details, location, address, email, phone, icon list, cube, social icons' ],
			'987' => [ 'Magazine, Light, Blue, posts, news, articles, updates, readmore, cpt, custom, carousel, slider, arrow, modern, horizontal, blog' ],
			'988' => [ 'Magazine, Light, Blue, contact form, box, information, details, location, address, email, phone, icon list, cube, social icons' ],
			'989' => [ 'App, Light, Yellow, horizontal parallax, about us, what is product, information, introduce, welcome, two section, half mobile, why choose us, reasons' ],
			'990' => [ 'App, Light, Yellow, full section, backgorund, stretch, boxes, features, services, icon box, vertical icon box info' ],
			'991' => [ 'App, Light, Yellow, images, gallery, photos, lightbox, carousel, slider, arrow, slideshow' ],
			'992' => [ 'App, Light, Yellow, table, pricing, package, subscription, order, buy, store, pay, plans' ],
			'993' => [ 'App, Light, Yellow, contact form, box, information, details, location, address, email, phone, icon list, social icons' ],
			'994' => [ 'App, Light, Yellow, download, applications, android, ios, apple, call to action, two buttons, trial, free get' ],
			'995' => [ 'Cryptocurrency, Light, Blue, separator, divider, video button, player, popup, lightbox, headline, intro, about, introduce, welcome, starter' ],
			'996' => [ 'Cryptocurrency, Light, Blue, background gradient, features box, services box, three columns, details, what we do' ],
			'997' => [ 'Cryptocurrency, Light, Blue, video popup player, video lightbox, timeline, history line, core features, information' ],
			'998' => [ 'Cryptocurrency, Light, Blue, counters, stats, statistics, numbers, progress, process, experience, expert, features, list style, stylish, about our services, targets' ],
			'999' => [ 'Cryptocurrency, Light, Blue, blog, posts, news, articles, updates, readmore, cpt, custom, post types' ],
			'1000' => [ 'Cryptocurrency, Light, Blue, particles, background image, stretch, call to action, middle, center, button, headline' ],
			'1001' => [ 'Cryptocurrency, Light, Blue, testimonials, quote, clients, customers, says, people, what, who, said, carousel, slider, arrows, simple' ],
			'1002' => [ 'Cryptocurrency, Light, Blue, call to action, boxed, icon box, button, simple, bitcoin, tether' ],
			'1003' => [ 'Cryptocurrency, Light, Blue, timeline, history, story, about company, when we started, who we are, about us, historical' ],
			'1004' => [ 'Cryptocurrency, Light, Blue, video popup player, middle, center, watch, youtube, vimeo, full section' ],
			'1005' => [ 'Cryptocurrency, Light, Blue, table, pricing, package, subscription, order, buy, store, pay, plans' ],
			'1006' => [ 'Cryptocurrency, Light, Blue, faq, modern, Frequently, asked, question, common, Accordion, toggle, show, contact form' ],

		];

		// Move free demos at end after activation.
		if ( ! Codevz_Core_Theme::is_free() ) {

			$free = array_filter( $config[ 'demos' ], function( $demo ) {
				return isset( $demo[ 'free' ] );
			});

			$premium = array_diff_key( $config[ 'demos' ], $free );

			$config[ 'demos' ] = array_merge( $premium, $free );

		}

		// Default options.
		$config[ 'options' ] 	= array(
			'layout' 		=> 'none',
			'primary' 		=> 'primary',
			'secondary' 	=> 'secondary',
			'responsive' 	=> true,
			'css' 			=> '',
			'page_title_tag' => 'h2',
			'site_color' 	=> '#0045a0',
			'_css_widgets' 	=> 'background-color:rgba(255,255,255,0.01);margin-bottom:35px;border-style:solid;border-width:1px;border-color:#d8d8d8;border-radius:6px;',
			'_css_widgets_headline' => 'font-size:20px;font-weight:700;',
			'_css_logo_css' => 'CDVZtext-transform:uppercase;CDVZ',
			'_css_menu_a_hover_before_header_1' => '_class_menu_fx:cz_menu_fx_left_to_right;',
			'menus_indicator_header_1' => 'fa fa-angle-down',
			'menus_indicator2_header_1' => 'fa fa-angle-right',
			'header_2_left' => 
			array(
				0 => 
				array(
					'element' => 'logo',
					'element_id' => 'header_2_left',
					'logo_width' => '140px',
					'margin' => 
					array(
						'top' => '25px',
						'right' => '',
						'bottom' => '25px',
						'left' => '',
					),
				),
			),
			'header_2_right' => 
			array(
				0 => 
				array(
					'element' => 'search',
					'element_id' => 'header_2_right',
					'margin' => 
					array(
						'top' => '34px',
						'right' => '',
						'bottom' => '34px',
						'left' => '10px',
					),
					'logo_width' => '',
					'menu_location' => '',
					'menu_type' => '',
					'menu_icon' => '',
					'menu_title' => '',
					'sk_menu_icon' => '',
					'image' => '',
					'image_width' => '',
					'image_link' => '',
					'it_text' => '',
					'it_link' => '',
					'sk_it' => '',
					'it_icon' => '',
					'sk_it_icon' => '',
					'search_type' => 'icon_dropdown',
					'search_placeholder' => 'Type a keyword ...',
					'sk_search_title' => '',
					'search_form_width' => '',
					'sk_search_con' => 'background-color:#0045a0;margin-left:-3px;',
					'sk_search_input' => '',
					'search_icon' => '',
					'sk_search_icon' => 'font-size:14px;color:#ffffff;background-color:#0045a0;padding:5px;border-radius:2px;',
					'sk_search_icon_in' => 'color:#000000;',
					'search_cpt' => '',
					'search_count' => '',
					'search_view_all_translate' => '',
					'sk_search_ajax' => 'margin-top:15px;border-style:none;border-radius:5px;box-shadow:none;',
					'inview_position_widget' => 'inview_left',
					'sk_offcanvas' => '',
					'offcanvas_icon' => '',
					'sk_offcanvas_icon' => '',
					'hf_elm_page' => '',
					'sk_hf_elm' => '',
					'hf_elm_icon' => '',
					'sk_hf_elm_icon' => '',
					'shopcart_type' => 'cart_1',
					'sk_shop_count' => '',
					'shopcart_icon' => '',
					'sk_shop_icon' => '',
					'sk_shop_content' => '',
					'line_type' => 'header_line_2',
					'sk_line' => '',
					'btn_title' => '',
					'btn_link' => '',
					'sk_btn' => '',
					'sk_btn_hover' => '',
					'wpml_title' => 'translated_name',
					'wpml_current_color' => '',
					'wpml_background' => '',
					'wpml_color' => '',
					'header_elements' => '',
					'custom' => '',
					'avatar_size' => '',
					'sk_avatar' => '',
					'avatar_link' => '',
					'elm_on_sticky' => '',
				),
				1 => 
				array(
					'element' => 'menu',
					'element_id' => 'header_2_right',
					'margin' => 
					array(
						'top' => '34px',
						'right' => '0px',
						'bottom' => '34px',
						'left' => '0px',
					),
					'logo_width' => '',
					'menu_location' => '',
					'menu_type' => '',
					'menu_icon' => '',
					'menu_title' => '',
					'sk_menu_icon' => '',
					'image' => '',
					'image_width' => '',
					'image_link' => '',
					'it_text' => '',
					'it_link' => '',
					'sk_it' => '',
					'it_icon' => '',
					'sk_it_icon' => '',
					'search_type' => 'icon_dropdown',
					'search_placeholder' => '',
					'sk_search_title' => '',
					'search_form_width' => '',
					'sk_search_con' => '',
					'sk_search_input' => '',
					'search_icon' => '',
					'sk_search_icon' => '',
					'sk_search_icon_in' => '',
					'search_cpt' => '',
					'search_count' => '',
					'search_view_all_translate' => '',
					'sk_search_ajax' => '',
					'inview_position_widget' => 'inview_left',
					'sk_offcanvas' => '',
					'offcanvas_icon' => '',
					'sk_offcanvas_icon' => '',
					'hf_elm_page' => '',
					'sk_hf_elm' => '',
					'hf_elm_icon' => '',
					'sk_hf_elm_icon' => '',
					'shopcart_type' => 'cart_1',
					'sk_shop_count' => '',
					'shopcart_icon' => '',
					'sk_shop_icon' => '',
					'sk_shop_content' => '',
					'line_type' => 'header_line_2',
					'sk_line' => '',
					'btn_title' => '',
					'btn_link' => '',
					'sk_btn' => '',
					'sk_btn_hover' => '',
					'wpml_title' => 'translated_name',
					'wpml_current_color' => '',
					'wpml_background' => '',
					'wpml_color' => '',
					'header_elements' => '',
					'custom' => '',
					'avatar_size' => '',
					'sk_avatar' => '',
					'avatar_link' => '',
					'elm_on_sticky' => '',
				),
			),
			'_css_container_header_2' => 'border-style:solid;border-bottom-width:1px;border-color:#cccccc;',
			'_css_menu_a_header_2' => 'padding:6px 15px;margin-right:0px;margin-left:10px;',
			'_css_menu_a_hover_header_2' => 'color:#ffffff;',
			'_css_menu_a_hover_before_header_2' => '_class_menu_fx:cz_menu_fx_fade_in;width:100%;border-width:0px;border-radius:2px;bottom:0px;left:0px;',
			'menus_indicator_header_2' => 'fa fa-angle-down',
			'_css_menu_ul_header_2' => 'background-color:#0045a0;padding-top:20px;padding-bottom:20px;margin-top:1px;margin-left:30px;border-radius:2px;box-shadow:0px 9px 20px rgba(0,0,0,0.13);',
			'_css_menu_ul_a_header_2' => 'font-size:14px;color:#cecece;',
			'_css_menu_ul_a_hover_header_2' => 'color:#ffffff;',
			'menus_indicator2_header_2' => 'fa fa-angle-right',
			'menus_indicator_header_3' => 'fa fa-angle-down',
			'menus_indicator2_header_3' => 'fa fa-angle-right',
			'smart_sticky' => true,
			'_css_container_header_5' => 'background-color:#ffffff;',
			'menus_indicator_header_5' => 'fa fa-angle-down',
			'menus_indicator2_header_5' => 'fa fa-angle-right',
			'header_4_left' => 
			array(
				0 => 
				array(
					'element' => 'logo',
					'element_id' => 'header_4_left',
					'logo_width' => '120px',
					'margin' => 
					array(
						'top' => '20px',
						'right' => '',
						'bottom' => '20px',
						'left' => '',
					),
				),
			),
			'header_4_right' => 
			array(
				0 => 
				array(
					'element' => 'menu',
					'element_id' => 'header_4_right',
					'logo_width' => '',
					'menu_location' => '',
					'menu_type' => 'offcanvas_menu_right',
					'menu_icon' => '',
					'menu_title' => '',
					'sk_menu_icon' => 'font-size:18px;color:#ffffff;background-color:#0045a0;padding:3px;border-radius:0px;',
					'image' => '',
					'image_width' => '',
					'image_link' => '',
					'it_text' => '',
					'it_link' => '',
					'sk_it' => '',
					'it_icon' => '',
					'sk_it_icon' => '',
					'search_type' => 'icon_dropdown',
					'search_placeholder' => '',
					'sk_search_title' => '',
					'search_form_width' => '',
					'sk_search_con' => '',
					'sk_search_input' => '',
					'search_icon' => '',
					'sk_search_icon' => '',
					'sk_search_icon_in' => '',
					'search_cpt' => '',
					'search_count' => '',
					'search_view_all_translate' => '',
					'sk_search_ajax' => '',
					'inview_position_widget' => 'inview_right',
					'sk_offcanvas' => '',
					'offcanvas_icon' => '',
					'sk_offcanvas_icon' => '',
					'hf_elm_page' => '',
					'sk_hf_elm' => '',
					'hf_elm_icon' => '',
					'sk_hf_elm_icon' => '',
					'shopcart_type' => 'cart_1',
					'sk_shop_count' => '',
					'shopcart_icon' => '',
					'sk_shop_icon' => '',
					'sk_shop_content' => '',
					'line_type' => 'header_line_2',
					'sk_line' => '',
					'btn_title' => '',
					'btn_link' => '',
					'sk_btn' => '',
					'sk_btn_hover' => '',
					'wpml_title' => 'translated_name',
					'wpml_current_color' => '',
					'wpml_background' => '',
					'wpml_color' => '',
					'header_elements' => '',
					'custom' => '',
					'avatar_size' => '',
					'sk_avatar' => '',
					'avatar_link' => '',
					'elm_on_sticky' => '',
					'margin' => 
					array(
						'top' => '28px',
						'right' => '',
						'bottom' => '',
						'left' => '',
					),
				),
			),
			'_css_container_header_4' => 'border-style:solid;border-width:0 0 1px;border-color:#f4f4f4;',
			'_css_menu_a_header_4' => 'color:rgba(0,0,0,0.6);',
			'_css_menu_a_hover_header_4' => 'color:#0045a0;',
			'menus_indicator_header_4' => 'fa fa-angle-down',
			'_css_menu_ul_a_header_4' => 'color:#606060;',
			'_css_menu_ul_a_hover_header_4' => 'color:#3f51b5;',
			'menus_indicator2_header_4' => 'fa fa-angle-down',
			'page_cover' => 'title',
			'page_title' => '6',
			'breadcrumbs_home_icon' => 'fa fa-home',
			'breadcrumbs_separator' => 'fa fa-angle-right',
			'_css_page_title' => 'background-color:#0045a0;padding-top:10px;padding-bottom:10px;border-style:solid;border-width:0 0 1px;border-color:#f4f4f4;',
			'_css_page_title_color' => 'font-size:24px;color:#ffffff;padding-bottom:10px;padding-top:10px;',
			'_css_page_title_breadcrumbs_color' => 'color:#e8e8e8;',
			'_css_breadcrumbs_inner_container' => 'margin-top:12px;margin-right:10px;',
			'_css_footer' => 'background-color:#0045a0;padding-top:60px;padding-bottom:50px;',
			'_css_footer_widget' => 'color:#ffffff;padding:10px 10px 10px 10px;',
			'_css_footer_a' => 'font-size:13px;color:#ffffff;line-height: 2;',
			'_css_footer_a_hover' => 'color:#c6c6c6;',
			'footer_2_center' => 
			array(
				0 => 
				array(
					'element' => 'icon',
					'element_id' => 'footer_2_center',
					'header_elements' => '',
					'custom' => '',
					'margin' => 
					array(
						'top' => '30px',
						'right' => '',
						'bottom' => '25px',
						'left' => '',
					),
					'logo_width' => '',
					'menu_location' => 'primary',
					'menu_type' => '',
					'menu_icon' => '',
					'menu_title' => '',
					'sk_menu_icon' => '',
					'image' => '',
					'image_width' => '',
					'image_link' => '',
					'it_text' => '© All rights reserved.',
					'it_link' => '',
					'sk_it' => 'font-size:15px;color:rgba(255,255,255,0.8);',
					'it_icon' => '',
					'sk_it_icon' => '',
					'search_type' => 'form',
					'search_placeholder' => '',
					'sk_search_title' => '',
					'search_form_width' => '',
					'sk_search_con' => '',
					'sk_search_input' => '',
					'search_icon' => '',
					'sk_search_icon' => '',
					'sk_search_icon_in' => '',
					'search_cpt' => '',
					'search_count' => '',
					'search_view_all_translate' => '',
					'sk_search_ajax' => '',
					'inview_position_widget' => 'inview_left',
					'sk_offcanvas' => '',
					'offcanvas_icon' => '',
					'sk_offcanvas_icon' => '',
					'sk_offcanvas_icon_hover' => '',
					'hf_elm_page' => '',
					'sk_hf_elm' => '',
					'hf_elm_icon' => '',
					'sk_hf_elm_icon' => '',
					'shopcart_type' => 'cart_1',
					'sk_shop_count' => '',
					'shopcart_icon' => '',
					'sk_shop_icon' => '',
					'sk_shop_content' => '',
					'line_type' => 'header_line_2',
					'sk_line' => '',
					'btn_title' => '',
					'btn_link' => '',
					'sk_btn' => '',
					'sk_btn_hover' => '',
					'wpml_title' => 'translated_name',
					'wpml_current_color' => '',
					'wpml_background' => '',
					'wpml_color' => '',
					'avatar_size' => '',
					'sk_avatar' => '',
					'avatar_link' => '',
					'elm_on_sticky' => '',
				),
			),
			'_css_container_footer_2' => 'background-color:#0045a0;',
			'_css_backtotop' => 'color:#ffffff;background-color:#0045a0;border-style:none;border-width:0px;border-radius:10px;',
			'_css_cf7_beside_backtotop' => 'color:#0045a0;margin-right:3px;border-style:none;border-radius:50px 0 0 50px ;box-shadow:0px 0px 10px rgba(0,0,0,0.15);',
			'meta_data_post' => 
			array(
				0 => 'image',
				1 => 'mbot',
				2 => 'cats',
				3 => 'tags',
				4 => 'author_box',
				5 => 'next_prev',
			),
			'related_post' => 'You May Also Like ...',
			'slug_portfolio' => 'portfolio',
			'title_portfolio' => 'Portfolio',
			'cat_portfolio' => 'portfolio/cat',
			'tags_portfolio' => 'portfolio/tags',
			'tags_title_portfolio' => 'Tags',
			'meta_data_portfolio' => 
			array(
				0 => 'date',
				1 => 'cats',
				2 => 'tags',
			),
			'related_portfolio' => 'You May Also Like ...',
			'primary_portfolio' => 'primary',
			'secondary_portfolio' => 'secondary',
			'page_coverportfolio' => '1',
			'page_titleportfolio' => '1',
			'_css_footer_widget_headlines' => 'color:#ffffff;font-size:28px;font-weight:100;border-style:solid;border-width:0 0 1px;',
			'page_cover_portfolio' => '1',
			'_css_woo_products_thumbnails' => 'border-style:solid;border-color:rgba(0,0,0,0.27);border-radius:2px;',
			'page_title_portfolio' => '1',
			'page_cover_product' => '1',
			'page_title_product' => '1',
			'woo_col' => '4',
			'_css_woo_products_title' => 'margin-top:15px;',
			'_css_woo_products_stars' => 'display:none;',
			'_css_woo_products_add_to_cart' => 'font-size:14px;font-weight:400;background-color:#0045a0;border-radius:4px;position:absolute;bottom:100px;left:calc(50% - 75px);opacity:0;',
			'_css_woo_products_onsale' => 'font-size:10px;color:#ffffff;font-weight:400;background-color:#079700;top:10px;left:10px;',
			'_css_woo_products_price' => 'font-size:14px;color:#0045a0;background-color:rgba(255,255,255,0.01);top:5px;right:5px;',
			'_css_woo_product_price' => 'color:#0045a0;font-weight:700;',
			'_css_woo_buttons' => 'color:#ffffff;background-color:#0045a0;',
			'_css_woo_buttons_hover' => 'color:#0045a0;background-color:rgba(0,69,160,0.1);',
			'posts_per_page_portfolio' => '6',
			'cf7_beside_backtotop_icon' => 'fa fa-comments-o',
			'readmore' => 'Read More',
			'readmore_icon' => 'fa fa-angle-right',
			'_css_tags_categories_hover' => 'color:#ffffff;background-color:#0045a0;',
			'_css_pagination_li' => 'font-size:14px;color:#0045a0;font-weight:700;padding:0px;margin-right:5px;border-style:solid;border-width:1px;border-color:rgba(0,69,160,0.25);border-radius:4px;',
			'_css_pagination_hover' => 'color:#ffffff;',
			'_css_menu_ul_ul_header_2' => 'margin-top:-20px;margin-left:11px;',
			'related_post_col' => 's4',
			'_css_readmore' => 'color:rgba(255,255,255,0.8);border-radius:3px;',
			'_css_readmore_hover' => 'color:#ffffff;background-color:#0045a0;',
			'columns_portfolio' => '3',
			'template_style_portfolio' => '10',
			'related_portfolio_col' => 's4',
			'related_portfolio_ppp' => '3',
			'woo_template' => '1',
			'woo_related_col' => '3',
			'_css_post_avatar' => 'padding:2px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;box-shadow:none;CDVZwidth:42pxCDVZ',
			'_css_post_author' => 'font-size:14px;color:#000370;font-weight:600;',
			'_css_post_date' => 'font-size:12px;font-style:italic;',
			'_css_post_title' => 'font-size:28px;font-weight:500;',
			'_css_menu_ul_indicator_a_header_2' => '_class_indicator:fa fa-angle-right;color:#ffffff;',
			'_css_menu_indicator_a_header_2' => '_class_indicator:fa fa-angle-down;',
			'_css_sticky_post' => 'background-color:rgba(167,167,167,0.1);margin-bottom:40px;border-style:solid;border-width:2px;border-color:#000370;border-radius:6px;',
			'_css_overall_post' => 'padding-bottom:40px;margin-bottom:40px;border-style:solid;',
			'_css_post_meta_overall' => 'border-width:0px 0px 0px 6px;border-color:#0045a0;display:inline-block;',
			'_css_related_posts_sec_title' => 'font-size:22px;',
			'_css_single_comments_title' => 'font-size:22px;',
			'_css_next_prev_con' => 'background-color:rgba(255,255,255,0.01);margin-bottom: 35px;border-style: solid;border-width:1px;border-color:#d8d8d8;border-radius:6px;padding:50px;',
			'_css_next_prev_icons' => 'color:#000000;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:4px;',
			'_css_next_prev_icons_hover' => 'color:#ffffff;background-color:#0045a0;',
			'_css_next_prev_titles' => 'margin-right:8px;margin-left:8px;',
			'post_excerpt' => '-1',
			'prev_post' => 'Previous',
			'next_post' => 'Next',
			'related_posts_post' => 'Related Posts ...',
			'comments' => 'Comments',
			'cols_portfolio' => 's4',
			'related_posts_portfolio' => 'Related Posts ...',
			'_css_inner_title' => 'font-size:32px;',
			'_css_single_title' => 'font-size:32px;',
			'_css_single_mbot' => 'color:#727272;',
			'_css_single_mbot_i' => 'color:#000370;',
			'primary_buddypress' => 'primary',
			'secondary_buddypress' => 'secondary',
			'page_cover_buddypress' => '1',
			'page_title_buddypress' => '1',
			'lazyload' => true,
			'remove_query_args' => true,
			'vc_disable_modules' => 
			array(
				0 => 'vc_wp_search',
				1 => 'vc_wp_meta',
				2 => 'vc_wp_recentcomments',
				3 => 'vc_wp_calendar',
				4 => 'vc_wp_pages',
				5 => 'vc_wp_tagcloud',
				6 => 'vc_wp_custommenu',
				7 => 'vc_wp_text',
				8 => 'vc_wp_posts',
				9 => 'vc_wp_categories',
				10 => 'vc_wp_archives',
				11 => 'vc_wp_rss',
			),
			'css_out' => '

		/* Theme color */a:hover, .sf-menu > .cz.current_menu > a, .sf-menu > .cz > .current_menu > a, .sf-menu > .current-menu-parent > a {color: #0045a0} 
			button:not(.lg-icon):not(.customize-partial-edit-shortcut-button):not(.vc_general):not(.slick-arrow):not(.slick-dots-btn):not([role="presentation"]):not([aria-controls]),
			form button, button, .button,.sf-menu > .cz > a:before,.widget_product_search #searchsubmit, .post-password-form input[type="submit"], .wpcf7-submit, .submit_user, 
			#commentform #submit, .commentlist li.bypostauthor > .comment-body:after,.commentlist li.comment-author-admin > .comment-body:after, 
			.woocommerce input.button.alt.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce .woocommerce-error .button, .woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button,#add_payment_method table.cart input, .woocommerce-cart table.cart input:not(.input-text), .woocommerce-checkout table.cart input,.woocommerce input.button:disabled, .woocommerce input.button:disabled[disabled],#add_payment_method table.cart input, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce input.button.alt,
			.woocommerce #respond input#submit.alt:hover, .pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, 
			.pagination .prev:hover, input[type=submit], .sticky:before, .commentlist li.comment-author-admin .fn, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-MyAccount-navigation a:hover, .woocommerce-MyAccount-navigation .is-active a,
			input[type=submit],input[type=button],.cz_header_button,.cz_default_portfolio a, .dwqa-questions-footer .dwqa-ask-question a,
			.cz_readmore, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, 
			.woocommerce nav.woocommerce-pagination ul li span.current, .cz_btn, 
			.woocommerce .widget_price_filter .ui-slider .ui-slider-range, 
			.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .cz_readmore, .more-link, .search-form .search-submit {background-color: #0045a0}
			textarea:focus, input:focus, .nice-select.open, .nice-select:active, .nice-select:hover, .nice-select:focus {border-color: #0045a0 !important}
			.cs_load_more_doing, div.wpcf7 .wpcf7-form .ajax-loader, .cz_ajax_loader {border-right-color: #0045a0}
			::selection {background-color: #0045a0;color: #fff}::-moz-selection {background-color: #0045a0;color: #fff}

		/* Custom */.home.blog .page_cover { display: none } .home.blog .page_content { margin-top: 40px }.cz_readmore{line-height:1}

		/* Dynamic  */.widget{background-color:rgba(255,255,255,0.01);margin-bottom:35px;border-style:solid;border-width:1px;border-color:#d8d8d8;border-radius:6px}.widget > h4{font-size:20px;font-weight:700}.logo > a, .logo > h1, .logo h2{text-transform:uppercase}.header_2{border-style:solid;border-bottom-width:1px;border-color:#cccccc}#menu_header_2 > .cz > a{padding:6px 15px;margin-right:0px;margin-left:10px}#menu_header_2 > .cz > a:hover,#menu_header_2 > .cz:hover > a,#menu_header_2 > .current_menu > a,#menu_header_2 > .current-menu-parent > a{color:#ffffff}#menu_header_2 > .cz > a:before{width:100%;border-width:0px;border-radius:2px;bottom:0px;left:0px}#menu_header_2 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_2 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#0045a0;padding-top:20px;padding-bottom:20px;margin-top:1px;margin-left:30px;border-radius:2px;box-shadow:0px 9px 20px rgba(0,0,0,0.13)}#menu_header_2 .cz .cz a{font-size:14px;color:#cecece}#menu_header_2 .cz .cz a:hover,#menu_header_2 .cz .cz:hover > a,#menu_header_2 .cz .current_menu > a,#menu_header_2 .cz .current_menu > .current_menu{color:#ffffff}.onSticky{background-color:#ffffff}.header_4{border-style:solid;border-width:0 0 1px;border-color:#f4f4f4}#menu_header_4 > .cz > a{color:rgba(0,0,0,0.6)}#menu_header_4 > .cz > a:hover,#menu_header_4 > .cz:hover > a,#menu_header_4 > .current_menu > a,#menu_header_4 > .current-menu-parent > a{color:#0045a0}#menu_header_4 .cz .cz a{color:#606060}#menu_header_4 .cz .cz a:hover,#menu_header_4 .cz .cz:hover > a,#menu_header_4 .cz .current_menu > a,#menu_header_4 .cz .current_menu > .current_menu{color:#3f51b5}.page_title,.header_onthe_cover .page_title{background-color:#0045a0;padding-top:10px;padding-bottom:10px;border-style:solid;border-width:0 0 1px;border-color:#f4f4f4}.page_title .codevz-section-title{font-size:24px;color:#ffffff;padding-bottom:10px;padding-top:10px}.page_title a,.page_title a:hover,.page_title i{color:#e8e8e8}.breadcrumbs{margin-top:12px;margin-right:10px}.cz_middle_footer{background-color:#0045a0;padding-top:60px;padding-bottom:50px}.footer_widget{color:#ffffff;padding:10px 10px 10px 10px}.cz_middle_footer a{font-size:13px !important;color:#ffffff;line-height: 2}.cz_middle_footer a:hover{color:#c6c6c6}.footer_2{background-color:#0045a0}i.backtotop{color:#ffffff;background-color:#0045a0;border-style:none;border-width:0px;border-radius:10px}i.fixed_contact{color:#0045a0;margin-right:3px;border-style:none;border-radius:50px 0 0 50px ;box-shadow:0px 0px 10px rgba(0,0,0,0.15)}.footer_widget > h4{color:#ffffff;font-size:28px;font-weight:100;border-style:solid;border-width:0 0 1px}.woocommerce ul.products li.product a img{border-style:solid;border-color:rgba(0,0,0,0.27);border-radius:2px}.woocommerce ul.products li.product .woocommerce-loop-category__title, .woocommerce ul.products li.product .woocommerce-loop-product__title, .woocommerce ul.products li.product h3,.woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-category__title, .woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-product__title, .woocommerce.woo-template-2 ul.products li.product h3{margin-top:15px}.woocommerce ul.products li.product .star-rating{display:none}.woocommerce span.onsale, .woocommerce ul.products li.product .onsale{font-size:10px;color:#ffffff;font-weight:400;background-color:#079700;top:10px;left:10px}.woocommerce ul.products li.product .price{font-size:14px;color:#0045a0;background-color:rgba(255,255,255,0.01);top:5px;right:5px}.woocommerce div.product .summary p.price, .woocommerce div.product .summary span.price{color:#0045a0;font-weight:700}.tagcloud a:hover, .cz_post_cat a:hover{color:#ffffff;background-color:#0045a0}.pagination a, .pagination > b, .pagination span, .page-numbers a, .page-numbers span, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span{font-size:14px;color:#0045a0;font-weight:700;padding:0px;margin-right:5px;border-style:solid;border-width:1px;border-color:rgba(0,69,160,0.25);border-radius:4px}#menu_header_2 .sub-menu .sub-menu:not(.cz_megamenu_inner_ul){margin-top:-20px;margin-left:11px}.cz_readmore{color:rgba(255,255,255,0.8);border-radius:3px}.cz_readmore:hover{color:#ffffff;background-color:#0045a0}.cz_default_loop .cz_post_author_avatar img{padding:2px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;box-shadow:none;width:42px}.cz_default_loop .cz_post_author_name{font-size:14px;color:#000370;font-weight:600}.cz_default_loop .cz_post_date{font-size:12px;font-style:italic}.cz_default_loop .cz_post_title h3{font-size:36px;font-weight:700}#menu_header_2 .cz .cz a .cz_indicator{color:#ffffff}.cz_default_loop.sticky > div{background-color:rgba(167,167,167,0.1);margin-bottom:40px;border-style:solid;border-width:2px;border-color:#000370;border-radius:6px}.cz_default_loop > div{padding-bottom:40px;margin-bottom:40px;border-style:solid}.cz_default_loop .cz_post_meta{border-width:0px 0px 0px 6px;border-color:#0045a0;display:inline-block}.single-post .cz_related_posts > h4{font-size:22px}.single-post #comments > h3{font-size:22px}.single-post .next_prev i{color:#000000;border-style:solid;border-width:1px;border-color:#e5e5e5;border-radius:4px}.single-post .next_prev li:hover i{color:#ffffff;background-color:#0045a0}.single-post .next_prev h4{margin-right:8px;margin-left:8px} .content > h3:first-child, .content .codevz-section-title{font-size:32px}.single-post h3.codevz-section-title{font-size:32px}.single-post .cz_top_meta_i{color:#727272}.single-post .cz_top_meta_i a, .single-post .cz_top_meta_i .cz_post_date{color:#000370}button:not(.lg-icon):not(.customize-partial-edit-shortcut-button):not(.vc_general):not(.slick-arrow):not(.slick-dots-btn):not([role="presentation"]):not([aria-controls]),.dwqa-questions-footer .dwqa-ask-question a,input[type=submit],input[type=button],.button,.cz_header_button,.woocommerce a.button,.woocommerce input.button,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt{border-radius:2px}input,textarea,select,.qty{border-radius:2px}.pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, .pagination .prev:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current{color:#ffffff}#menu_header_2 .cz_parent_megamenu > [class^="cz_megamenu_"] > .cz, .cz_parent_megamenu > [class*=" cz_megamenu_"] > .cz{padding-right:10px;padding-left:10px;margin-top:10px;margin-bottom:10px;border-style:solid;border-color:rgba(255,255,255,0.1)}#menu_header_2 .cz .cz h6{color:#ffffff}.cz_default_loop .cz_post_image, .cz_post_svg{border-radius:4px}.cz_default_loop .cz_post_image, .cz_post_svg{border-radius:4px}

	.cz_next_prev_posts {background-color:rgba(255,255,255,0.01);margin-bottom: 35px;border-style: solid;border-width:1px;border-color:#d8d8d8;border-radius:6px;padding:50px;}
	footer .search-form {background: #fff;padding: 20px}
		/* Responsive */@media screen and (max-width:1170px){#layout{width:100%!important}#layout.layout_1,#layout.layout_2{width:95%!important}.row{width:90% !important;padding:0}blockquote{padding:20px}.slick-slide{margin:0!important}footer .elms_center,footer .elms_left,footer .elms_right,footer .have_center .elms_left, footer .have_center .elms_center, footer .have_center .elms_right{float:none;display:table;text-align:center;margin: 0 auto;flex:unset}}
			@media screen and (max-width:1025px){.header_1,.header_2,.header_3{width: 100%}#layout.layout_1,#layout.layout_2{width:94%!important}#layout.layout_1 .row,#layout.layout_2 .row{width:90% !important}}
			@media screen and (max-width:768px){.header_1,.header_2,.header_3,.header_5,.fixed_side{display: none !important}.header_4,.Corpse_Sticky.cz_sticky_corpse_for_header_4{display: block !important}.header_onthe_cover:not(.header_onthe_cover_dt):not(.header_onthe_cover_all){margin-top: 0 !important}body,#layout{padding: 0 !important;margin: 0 !important}body{overflow-x:hidden}.inner_layout,#layout.layout_1,#layout.layout_2,.col,.cz_five_columns > .wpb_column,.cz_five_columns > .vc_vc_column{width:100% !important;margin:0 !important;border-radius:0}.hidden_top_bar,.fixed_contact,.cz_process_road_a,.cz_process_road_b{display:none!important}.cz_parent_megamenu>.sub-menu{margin:0!important}.is_fixed_side{padding:0!important}.cz_tabs_is_v .cz_tabs_nav,.cz_tabs_is_v .cz_tabs_content{width: 100% !important;margin-bottom: 20px}.wpb_column {margin-bottom: 20px}.cz_fixed_footer {position: static !important}.Corpse_Sticky,.hide_on_tablet{display:none !important}header i.hide,.show_on_tablet{display:block}.cz_grid_item:not(.slick-slide){width:50% !important}.cz_grid_item img{width:auto !important}.cz_mobile_text_center{margin-right:auto;margin-left:auto}.cz_mobile_text_center, .cz_mobile_text_center *{text-align:center !important;float:none !important}.cz_mobile_btn_center{float:none !important;margin-left: auto !important;margin-right: auto !important;display: table !important;text-align: center !important}.vc_row[data-vc-stretch-content] .vc_column-inner[class^=\'vc_custom_\'],.vc_row[data-vc-stretch-content] .vc_column-inner[class*=\' vc_custom_\'] {padding:20px !important;}.wpb_column {margin-bottom: 0 !important;}.vc_row.no_padding .vc_column_container > .vc_column-inner, .vc_row.nopadding .vc_column_container > .vc_column-inner{padding:0 !important;}.cz_posts_container article > div{height: auto !important}.cz_split_box_left > div, .cz_split_box_right > div {width:100%;float:none}.woo-col-3.woocommerce ul.products li.product, .woo-col-3.woocommerce-page ul.products li.product, .woo-related-col-3.woocommerce ul.products .related li.product, .woo-related-col-3.woocommerce-page ul.products .related li.product {width: calc(100% / 2 - 2.6%)}.search_style_icon_full .search{width:86%;top:80px}.vc_row-o-equal-height .cz_box_front_inner, .vc_row-o-equal-height .cz_eqh, .vc_row-o-equal-height .cz_eqh > div, .vc_row-o-equal-height .cz_eqh > div > div, .vc_row-o-equal-height .cz_eqh > div > div > div, .cz_posts_equal > .clr{display:block !important}.cz_a_c.cz_timeline_container:before {left: 0}.cz_timeline-i i {left: 0;transform: translateX(-50%)}.cz_a_c .cz_timeline-content {margin-left: 50px;width: 70%;float: left}.cz_a_c .cz_timeline-content .cz_date{position: static;text-align: left}.cz_posts_template_13 article,.cz_posts_template_14 article{width:100%}}
			@media screen and (max-width:480px){.cz_grid_item img{width:auto !important}.hide_on_mobile,.show_only_tablet,.fixed_contact,.cz_cart_items{display:none}header i.hide,.show_on_mobile{display:block}.offcanvas_area{width:80%}.cz_tab_a,.cz_tabs_content,.cz_tabs_is_v .cz_tabs_nav{box-sizing:border-box;display: block;width: 100% !important;margin-bottom: 20px}.woocommerce ul.products li.product, .woocommerce-page ul.products li.product, .woocommerce-page[class*=columns-] ul.products li.product, .woocommerce[class*=columns-] ul.products li.product,.wpcf7-form p,.cz_default_loop,.cz_post_image,.cz_post_chess_content{width: 100% !important}.cz_post_chess_content{position:static;transform:none}.cz_post_image,.cz_default_grid{width: 100%;margin-bottom:30px !important}.wpcf7-form p {width: 100% !important;margin: 0 0 10px !important}[class^="cz_parallax_"],[class*=" cz_parallax_"]{transform:none !important}th, td {padding: 1px}dt {width: auto}dd {margin: 0}pre{width: 90%}.woocommerce .woocommerce-result-count, .woocommerce-page .woocommerce-result-count,.woocommerce .woocommerce-ordering, .woocommerce-page .woocommerce-ordering{float:none;text-align:center;width:100%}.woocommerce #coupon_code, .coupon input.button {width:100% !important;margin:0 0 10px !important}span.wpcf7-not-valid-tip{left:auto}.wpcf7-not-valid-tip:after{right:auto;left:-41px}.cz_video_popup div{width:fit-content}.cz_grid_item:not(.slick-slide){width:100% !important;margin: 0 !important}.cz_grid_item > div{margin:0 0 10px !important}.cz_grid{width:100% !important;margin:0 !important}.center_on_mobile,.center_on_mobile *{text-align:center !important;float:none !important}.center_on_mobile .cz_wh_left, .center_on_mobile .cz_wh_right {display:block}.center_on_mobile .item_small > a{display:inline-block;margin:2px 0}.center_on_mobile img,.center_on_mobile .cz_image > div{display:table !important;margin-left: auto !important;margin-right: auto !important}.tac_in_mobile{text-align:center !important;float:none !important;display:table;margin-left:auto !important;margin-right:auto !important}.next_prev li {float:none !important;width:100% !important;border: 0 !important;margin-bottom:30px !important}.services.left .service_custom,.services.right .service_custom,.services.left .service_img,.services.right .service_img{float:none;margin:0 auto 20px auto !important;display:table}.services div.service_text,.services.right div.service_text{padding:0 !important;text-align:center !important}.header_onthe_cover_dt{margin-top:0 !important}.alignleft,.alignright{float:none;margin:0 auto 30px}.woocommerce li.product{margin-bottom:30px !important}.woocommerce #reviews #comments ol.commentlist li .comment-text{margin:0 !important}#comments .commentlist li .avatar{left:-20px !important}.services .service_custom i{left: 50%;transform: translateX(-50%)}#commentform > p{display:block;width:100%}blockquote,.blockquote{width:100% !important;box-sizing:border-box;text-align:center;display:table !important;margin:0 auto 30px !important;float:none !important}.cz_related_post{margin-bottom: 30px !important}.right_br_full_container .lefter, .right_br_full_container .righter,.right_br_full_container .breadcrumbs{width:100%;text-align:center}a img.alignleft,a img.alignright{margin:0 auto 30px;display:block;float:none}.cz_popup_in{max-height:85%!important;max-width:90%!important;min-width:0;animation:none;box-sizing:border-box;left:5%;transform:translate(0,-50%)}.rtl .sf-menu > .cz{width:100%}.cz_2_btn a {box-sizing: border-box}.cz_has_year{margin-left:0 !important}.cz_history_1 > span:first-child{position:static !important;margin-bottom:10px !important;display:inline-block}.search-form .search-submit{margin: 0}.page_item_has_children .children, ul.cz_circle_list {margin: 8px 0 8px 10px}ul, .widget_nav_menu .sub-menu, .widget_categories .children, .page_item_has_children .children, ul.cz_circle_list{margin-left: 10px}.dwqa-questions-list .dwqa-question-item{padding: 20px 20px 20px 90px}.dwqa-question-content, .dwqa-answer-content{padding:0}.cz_subscribe_elm button{position:static !important}.cz_hexagon{position: relative;margin: 0 auto 30px}.cz_gallery_badge{right:-10px}.woocommerce table.shop_table_responsive tr td,.woocommerce-page table.shop_table_responsive tr td{display:flow-root !important}.quantity{float:right}}',
			'_css_buttons' => 'border-radius:2px;',
			'_css_input_textarea' => 'border-radius:2px;',
			'404_msg' => 'Page not found!',
			'404_btn' => 'Back to Homepage',
			'layout_post' => 'right',
			'template_style' => '3',
			'not_found' => 'Nothing found',
			'cm_disabled' => 'Comments are disabled.',
			'_css_pagination_li_hover' => 'color:#ffffff;',
			'no_comment' => 'No comment',
			'comment' => 'Comment',
			'search_title_prefix' => 'Search result for:',
			'layout_search' => '1',
			'layout_portfolio' => 'ws',
			'post_excerpt_portfolio' => '20',
			'readmore_portfolio' => 'Read More',
			'readmore_icon_portfolio' => 'fa fa-angle-right',
			'prev_portfolio' => 'Previous',
			'next_portfolio' => 'Next',
			'no_comment_portfolio' => 'No comment',
			'comment_portfolio' => 'Comment',
			'comments_portfolio' => 'Comments',
			'layout_product' => 'ws',
			'fonts_out' => 
			array(
				0 => 'font-family:Open Sans;',
			),
			'_css_menu_inner_megamenu_header_2' => 'padding-right:10px;padding-left:10px;margin-top:10px;margin-bottom:10px;border-style:solid;border-color:rgba(255,255,255,0.1);',
			'_css_menu_ul_a_h6_header_2' => 'color:#ffffff;',
			'_css_post_image' 			=> 'border-radius:4px;',
			'_css_portfolio_image' 		=> 'border-radius:4px;',
			'_css_post_excerpt' 		=> 'font-size:13px;line-height:24px;',
			'backtotop' 				=> '',
			'hover_icon_icon_post' 		=> 'fa fa-link',
			'related_post_ppp' 			=> '0',
			'hover_icon_icon_portfolio' => 'fa fa-link',
			'woo_cart' 					=> 'Cart',
			'woo_checkout' 				=> 'Checkout',
			'woo_no_products' 			=> 'No products in the cart',
			'footer_layout' 			=> 's3,s3,s3,s3'
		);

		return $key ? $config[ $key ] : $config;

	}

}