<?php
/**
 * The template for displaying posts in the Quote post format
 *
 * @author     Gaviasthemes Team     
 * @copyright  Copyright (C) 2020 gaviasthemes. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
?>
<?php 
	$thumbnail = 'post-thumbnail';
	if(isset($thumbnail_size) && $thumbnail_size){
		$thumbnail = $thumbnail_size;
	}
	if(is_single()){
		$thumbnail = 'full';
	}
	if(!isset($excerpt_words)){
    	$excerpt_words = ziston_get_option('blog_excerpt_limit', 20);
  	}
?>
<article id="post-<?php echo esc_attr(get_the_ID()); ?>" <?php post_class(); ?>>
	
	<div class="post-thumbnail">
		<?php the_post_thumbnail( $thumbnail , array( 'alt' => get_the_title() ) ); ?>
	</div>
	
	<div class="entry-content">
		<?php if(!is_single()){ ?>
         <div class="entry-meta">
            <?php ziston_posted_on(); ?>
         </div> 
      <?php } ?>  

      <div class="content-inner">
         
         <?php if( !is_single() ){ ?>
            <h2 class="entry-title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h2>
         <?php } ?> 

         <?php if ( is_single() ){ ?>
            <div class="entry-meta">
               <?php ziston_posted_on(); ?>
            </div>
            <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && is_single() ){ ?>
               <div class="cat-links"><i class="fas fa-tags"></i><?php echo get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'ziston' ) ); ?></div>
            <?php } ?>
            <h1 class="entry-title"><?php echo the_title() ?></h1>
         <?php } ?>

			<?php if(is_single()){
				echo '<div class="post-content clearfix">';
               the_content( sprintf(
                  esc_html__( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'ziston' ),
                  the_title( '<span class="screen-reader-text">', '</span>', false )
               ) );
               wp_link_pages( array(
                  'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'ziston' ) . '</span>',
                  'after'       => '</div>',
                  'link_before' => '<span>',
                  'link_after'  => '</span>',
               ) );
            echo '</div>';
			}else{
				echo '<div class="entry-description">' . ziston_limit_words( $excerpt_words, get_the_excerpt(), get_the_content() ) . '</div>';
			}
			?>
         <?php the_tags( '<footer class="entry-meta-footer"><span class="tag-links">', '', '</span></footer>' ); ?>
         <?php 
            if(is_single()){ 
               do_action( 'ziston_share' );
            }
         ?>
      </div>
      
	</div><!-- .entry-content -->	

</article><!-- #post-## -->
