<?php
/**
 	* $Desc
 	*
 	* @author     Gaviasthemes Team     
 	* @copyright  Copyright (C) 2020 gaviasthemes. All Rights Reserved.
 	* @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 	* 
*/

define( 'ZISTON_THEME_DIR', get_template_directory() );
define( 'ZISTON_THEME_URL', get_template_directory_uri() );

/*
	* Include list of files from Gavias Framework.
*/
require_once(ZISTON_THEME_DIR . '/includes/theme-functions.php'); 
require_once(ZISTON_THEME_DIR . '/includes/template.php'); 
require_once(ZISTON_THEME_DIR . '/includes/theme-hook.php'); 
require_once(ZISTON_THEME_DIR . '/includes/theme-layout.php'); 
require_once(ZISTON_THEME_DIR . '/includes/comment.php'); 
require_once(ZISTON_THEME_DIR . '/includes/metaboxes.php'); 
require_once(ZISTON_THEME_DIR . '/includes/menu/megamenu.php'); 
require_once(ZISTON_THEME_DIR . '/includes/sample/init.php');
require_once(ZISTON_THEME_DIR . '/includes/elementor/hooks.php');
require_once(ZISTON_THEME_DIR . '/includes/customize/custom-typo.php'); 
require_once(ZISTON_THEME_DIR . '/includes/customize/custom-color.php'); 

if( in_array( 'wp-job-manager/wp-job-manager.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
  	require_once(ZISTON_THEME_DIR . '/includes/listings/functions.php');
  	require_once(ZISTON_THEME_DIR . '/includes/listings/listing-data.php');
}

//Load Woocommerce
if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
  	add_theme_support( "woocommerce" );
  	require_once(ZISTON_THEME_DIR . '/includes/woocommerce/functions.php'); 
  	require_once(ZISTON_THEME_DIR . '/includes/woocommerce/hooks.php'); 
}

add_action('after_setup_theme', 'ziston_after_setup_theme');
function ziston_after_setup_theme(){
	// Load Redux - Theme options framework
	if( class_exists( 'Redux' ) ){
	  	require( ZISTON_THEME_DIR . '/includes/options/init.php' );
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-general.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-header.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-footer.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-breadcrumb.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-styling.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-typography.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-blog.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-lt-general.php'); 
	   require_once(ZISTON_THEME_DIR . '/includes/options/opts-lt-map.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-lt-filter.php'); 
	   require_once(ZISTON_THEME_DIR . '/includes/options/opts-lt-archives.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-lt-single.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-page.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-woo.php'); 
	  	require_once(ZISTON_THEME_DIR . '/includes/options/opts-event.php'); 
	} 
	register_nav_menus( array(
		'primary'      => esc_html__( 'Main menu', 'ziston' ),
	));
}

// TGM plugin activation
if ( is_admin() ) {
  	require_once( ZISTON_THEME_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php' );
  	require( ZISTON_THEME_DIR . '/includes/tgmpa/config.php' );
}
load_theme_textdomain( 'ziston', get_template_directory() . '/languages' );

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function ziston_widgets_init() {
	register_sidebar( array(
	  	'name' => esc_html__( 'Default Sidebar', 'ziston' ),
	  	'id' => 'default_sidebar',
	  	'description' => esc_html__( 'Appears in the Default Sidebar section of the site.', 'ziston' ),
	  	'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
	  	'after_widget' => '</aside>',
	  	'before_title' => '<h3 class="widget-title"><span>',
	  	'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'WooCommerce Sidebar', 'ziston' ),
		'id' => 'woocommerce_sidebar',
		'description' => esc_html__( 'Appears in the Plugin WooCommerce section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'WooCommerce Single', 'ziston' ),
		'id' => 'woocommerce_single_summary',
		'description' => esc_html__( 'Appears in the WooCommerce Single Page like social, description text ...', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'After Offcanvas Mobile', 'ziston' ),
		'id' => 'offcanvas_sidebar_mobile',
		'description' => esc_html__( 'Appears in the Offcanvas section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Blog Sidebar', 'ziston' ),
		'id' => 'blog_sidebar',
		'description' => esc_html__( 'Appears in the Blog sidebar section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Page Sidebar', 'ziston' ),
		'id' => 'other_sidebar',
		'description' => esc_html__( 'Appears in the Page Sidebar section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Footer first', 'ziston' ),
		'id' => 'footer-sidebar-1',
		'description' => esc_html__( 'Appears in the Footer first section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Footer second', 'ziston' ),
		'id' => 'footer-sidebar-2',
		'description' => esc_html__( 'Appears in the Footer second section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Footer third', 'ziston' ),
		'id' => 'footer-sidebar-3',
		'description' => esc_html__( 'Appears in the Footer third section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	register_sidebar( array(
		'name' => esc_html__( 'Footer four', 'ziston' ),
		'id' => 'footer-sidebar-4',
		'description' => esc_html__( 'Appears in the Footer four section of the site.', 'ziston' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
}
add_action( 'widgets_init', 'ziston_widgets_init' );


if ( ! function_exists( 'ziston_fonts_url' ) ) :
/**
 *
 * @return string Google fonts URL for the theme.
 */
function ziston_fonts_url() {
  	$fonts_url = '';
  	$fonts     = array();
  	$subsets   = '';
  	$protocol = is_ssl() ? 'https' : 'http';
  	/*
		* Translators: If there are characters in your language that are not supported
		* by Noto Sans, translate this to 'off'. Do not translate into your own language.
	*/
  	if ( 'off' !== _x( 'on', 'Poppins font: on or off', 'ziston' ) ) {
	 	$fonts[] = 'Barlow:wght@400;500;600;700;800';
  	}
  	if ( 'off' !== _x( 'on', 'Cabin font: on or off', 'ziston' ) ) {
	 	$fonts[] = 'Muli:wght@400;500;600;700';
  	}
  	if ( 'off' !== _x( 'on', 'Sacramento font: on or off', 'ziston' ) ) {
	 	$fonts[] = 'Sacramento';
  	}

  	if ( $fonts ) {
	 	$fonts_url = add_query_arg( array(
			'family' => ( implode( '&family=', $fonts ) ),
			'display' => 'swap',
	 	),  $protocol.'://fonts.googleapis.com/css2' );
  	}

  	return $fonts_url;
}

endif;

function ziston_custom_styles() {
  	$custom_css = get_option( 'ziston_theme_custom_styles' );
  	if($custom_css){
	 	wp_enqueue_style(
			'ziston-custom-style',
			ZISTON_THEME_URL . '/css/custom_script.css'
	 	);
	 	wp_add_inline_style( 'ziston-custom-style', $custom_css );
  	}
}
add_action( 'wp_enqueue_scripts', 'ziston_custom_styles', 9999 );

function ziston_init_scripts(){
  	global $post;
  	$protocol = is_ssl() ? 'https' : 'http';
  	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ){
	 	wp_enqueue_script( 'comment-reply' );
  	}

   $theme = wp_get_theme();
   $theme_version = $theme['Version'];

  	wp_enqueue_style( 'ziston-fonts', ziston_fonts_url(), array(), null );
  	wp_enqueue_script('bootstrap', ZISTON_THEME_URL . '/js/bootstrap.js', array('jquery') );
  	wp_enqueue_script('scrollbar', ZISTON_THEME_URL . '/js/perfect-scrollbar.jquery.min.js');
  	wp_enqueue_script('magnific', ZISTON_THEME_URL . '/js/magnific/jquery.magnific-popup.min.js');
  	wp_enqueue_script('cookie', ZISTON_THEME_URL . '/js/jquery.cookie.js', array('jquery'));
  	wp_enqueue_script('lightgallery', ZISTON_THEME_URL . '/js/lightgallery/js/lightgallery.min.js' );
  	wp_enqueue_script('sticky', ZISTON_THEME_URL . '/js/sticky.js', array('elementor-waypoints'));
  	wp_enqueue_script('owl-carousel', ZISTON_THEME_URL . '/js/owl-carousel/owl.carousel.min.js');
  	wp_enqueue_script('jquery.appear', ZISTON_THEME_URL . '/js/jquery.appear.js');
  	wp_enqueue_script('particles', ZISTON_THEME_URL . '/js/particles.min.js');
  	wp_enqueue_script('ziston-main', ZISTON_THEME_URL . '/js/main.js', array('imagesloaded', 'jquery-masonry'));
  	wp_enqueue_script('ziston-woocommerce', ZISTON_THEME_URL . '/js/woocommerce.js');

  	if(ziston_woocommerce_activated() ){
	 	wp_dequeue_script('wc-add-to-cart');
	 	wp_register_script( 'wc-add-to-cart', ZISTON_THEME_URL . '/js/add-to-cart.js' , array( 'jquery' ) );
	 	wp_enqueue_script('wc-add-to-cart');
  	}

  	wp_enqueue_style( 'dashicons' );
  	wp_enqueue_style('lightgallery', ZISTON_THEME_URL . '/js/lightgallery/css/lg-transitions.min.css');
  	wp_enqueue_style('owl-carousel', ZISTON_THEME_URL .'/js/owl-carousel/assets/owl.carousel.css');
  	wp_enqueue_style('magnific', ZISTON_THEME_URL .'/js/magnific/magnific-popup.css');
  	wp_enqueue_style('fontawesome', ZISTON_THEME_URL . '/css/fontawesome/css/all.css');
  	wp_enqueue_style('line-awesome', ZISTON_THEME_URL . '/css/line-awesome/css/line-awesome.min.css');

  	wp_enqueue_style('ziston-style', ZISTON_THEME_URL . '/style.css');

  	$skin = ziston_get_option('skin_color', '');
  	if(!empty($skin)){
	 	$skin = 'skins/' . $skin . '/'; 
  	}
  	wp_enqueue_style('bootstrap', ZISTON_THEME_URL . '/css/' . $skin . 'bootstrap.css', array(), $theme_version, 'all'); 
  	wp_enqueue_style('ziston-woocoomerce', ZISTON_THEME_URL . '/css/' . $skin . 'woocommerce.css', array(), $theme_version, 'all'); 
  	wp_enqueue_style('ziston-template', ZISTON_THEME_URL . '/css/' . $skin . 'template.css', array(), $theme_version, 'all');
   wp_dequeue_style('jquery-ui');
   
}
add_action('wp_enqueue_scripts', 'ziston_init_scripts', 999);

