<?php
function ziston_custom_color_theme(){
   $theme_color = ziston_get_option('color_theme', '');
   if( !empty($theme_color) ){ 
      ob_start();

   /* ----- Style Color Theme ----- */
?>

<?php if( !empty($theme_color) ){ ?>
.btn-link:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.page-link:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
 a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.page-links > a:hover, .page-links > span:not(.page-links-title):hover {
   border-color: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.page-links > span:not(.page-links-title) {
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.page-links .post-page-numbers:hover {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.page-links span.post-page-numbers {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
blockquote {
   border-left: 2px solid <?php echo esc_attr($theme_color) ?>;
}
blockquote:after {
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.feature-list > li:after, ul.list-style-1 > li:after {
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.list-style-2 > li {
   color: <?php echo esc_attr($theme_color) ?>;
}
.pager .paginations a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.pager .paginations a.active {
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.bg-theme {
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.bg-theme-2 {
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.text-theme {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.hover-color-theme a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.hover-color-theme-2 a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.btn-theme, .btn, .btn-white, .btn-theme-2, .btn-theme-2 input[type*="submit"], .btn-black, input[type*="submit"]:not(.fa):not(.btn-theme), #tribe-events .tribe-events-button, .tribe-events-button, .load_more_jobs {
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-gray-icon:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-gray-icon.bg-theme {
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-theme-2 {
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn:after, input[type*="submit"]:not(.fa):not(.btn-theme):not(.wpcf7-submit):after {
   background: <?php echo esc_attr($theme_color) ?>;
}
 #tribe-events .tribe-events-button:hover, .tribe-events-button:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-inline {
   color: <?php echo esc_attr($theme_color) ?>;
}
.socials a i {
   background: <?php echo esc_attr($theme_color) ?>;
}
.socials-2 li a i:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.alert-danger {
   background: <?php echo esc_attr($theme_color) ?>;
}
.desc-slider a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.header-mobile .header-mobile-content .header-right .mobile-user .login-popup .sign-in-link .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.header-mobile .header-mobile-content .mini-cart-header a.mini-cart .mini-cart-items {
   background: <?php echo esc_attr($theme_color) ?>;
}
.header-default .header-bottom .header-bottom-inner .gsc-search-box .control-search:hover svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
ul.gva-nav-menu > li:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
ul.gva-nav-menu > li:hover > a, ul.gva-nav-menu > li:active > a, ul.gva-nav-menu > li:focus > a, ul.gva-nav-menu > li.current_page_parent > a {
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.gva-nav-menu > li .submenu-inner li a:hover, ul.gva-nav-menu > li .submenu-inner li a:focus, ul.gva-nav-menu > li .submenu-inner li a:active, ul.gva-nav-menu > li ul.submenu-inner li a:hover, ul.gva-nav-menu > li ul.submenu-inner li a:focus, ul.gva-nav-menu > li ul.submenu-inner li a:active {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gavias-off-canvas-toggle {
   background: <?php echo esc_attr($theme_color) ?>;
}
 
#gavias-off-canvas .off-canvas-top .top-social > a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
 
#gavias-off-canvas .off-canvas-top .gavias-off-canvas-close:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas ul#menu-main-menu > li > a.active > a {
   color: <?php echo esc_attr($theme_color) ?>;
}
 
#gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li a:hover, #gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li a:focus {
   color: <?php echo esc_attr($theme_color) ?>;
}
 
#gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li.active > a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content .close-canvas a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li.menu-item-has-children .caret:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li ul.submenu-inner li a:hover, .gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li div.submenu-inner li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.megamenu-main .widget.widget-html ul li strong {
   color: <?php echo esc_attr($theme_color) ?>;
}
.bg-row-theme, .bg-col-theme > .elementor-column-wrap {
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.row-style-1 > div.elementor-container {
   border-top: 10px solid <?php echo esc_attr($theme_color) ?>;
}
.row-style-1 > div.elementor-container:after {
   border-top: 10px solid <?php echo esc_attr($theme_color) ?>;
}
.row-style-2 > div.elementor-container:after {
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.col-bg-theme-inner > .elementor-column-wrap > .elementor-widget-wrap {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-productscategory-navigation .widget-title {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-products-list .widget-title {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-social-links.style-v2 ul.socials > li > a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team .team-position {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team.team-horizontal .team-header .social-list a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.gsc-team.team-horizontal .team-name:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team.team-vertical .team-body .info {
   background: <?php echo esc_attr($theme_color) ?>;
}
.post-small .post .cat-links a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.elementor-accordion .elementor-accordion-item .elementor-tab-title a span {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-call-to-action .sub-title {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-career .box-content .job-type {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-hover-box-carousel .hover-box-item .box-content .box-icon {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-countdown {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box .highlight-icon .box-icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box .highlight-icon .box-icon svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box .highlight-icon .icon-container {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.style-1 .icon-box-item-content .icon-box-item-inner .box-icon i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.style-1 .icon-box-item-content .icon-box-item-inner .box-icon svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.layout-carousel.style-1 .owl-stage-outer .owl-item.center .icon-box-item-content .icon-box-item-inner {
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-1 .icon-box-content .box-icon i, .gsc-icon-box-styles.style-1 .icon-box-content .box-icon svg {
   color: <?php echo esc_attr($theme_color) ?>;
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-1:hover .icon-box-content, .gsc-icon-box-styles.style-1.active .icon-box-content {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-2 .box-icon {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-2:hover .content-inner, .gsc-icon-box-styles.style-2.active .content-inner {
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-1 .box-content .milestone-icon .icon:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-2 .box-content .milestone-icon .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-2 .box-content .milestone-icon .icon svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-3 .box-content {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gallery-post a.zoomGallery {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gallery-post a.zoomGallery:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .heading-video .video-link {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .title .highlight, .gsc-heading .title strong {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .sub-title {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v2 .box-content .read-more svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v3 .box-content {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v4 .box-content .read-more svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gva-posts-grid .posts-grid-filter ul.nav-tabs > li > a.active {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .testimonial-item:hover .testimonial-image {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .testimonial-item:hover .testimonial-content-inner .quote-icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .owl-item.first .testimonial-image {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .owl-item.first .testimonial-content-inner .quote-icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-2 .testimonial-item .testimonial-information span.testimonial-name {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-2 .testimonial-item .testimonial-information span.dot {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-2 .testimonial-item:hover .icon-quote {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-1 .video-inner .video-content .video-action .popup-video {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-video-carousel .video-item-inner .video-link {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-pricing.style-1 .content-inner .plan-price .price-value {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-pricing.style-1 .content-inner .plan-price .interval {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-pricing.style-1 .content-inner .plan-list li .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-pricing.style-2 .content-inner .price-meta .plan-price .price-value {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-pricing.style-2 .content-inner .price-meta .plan-price .interval {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-socials ul.social-links li a {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .nav_tabs > li a.active {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .nav_tabs > li a.active:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .tab-content .tab-pane .tab-content-item ul > li:after {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-work-process .box-content .number-text {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-work-process:hover .box-content .number-text, .gsc-work-process.active .box-content .number-text {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-1 .listings-banner-item-content .number-listings {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-1 .listings-banner-item-content .banner-content .subtitle {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-1 .listings-banner-item-content .banner-content .link-term {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-2 .listings-banner-item-content .banner-content:before, .gsc-listings-banner-group.style-2 .listings-banner-item-content .banner-content:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-2 .listings-banner-item-content .banner-content .link-term {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner-group.style-3 .listings-banner-item-content .banner-hover .number-listings {
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner .number-listings {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-search-form .search-form-content .lt_search_location .search-location-inner .places_list_autocomplete ul li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-user .login-account .profile:hover, .topbar-mobile .login-account .profile:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-user .login-account .user-account .menu-item-logout a:hover, .topbar-mobile .login-account .user-account .menu-item-logout a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-user .login-register a .icon, .topbar-mobile .login-register a .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-user .login-register a:hover, .topbar-mobile .login-register a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget .widget-title:after, .widget .widgettitle:after, .widget .wpb_singleimage_heading:after, .wpb_single_image .widget-title:after, .wpb_single_image .widgettitle:after, .wpb_single_image .wpb_singleimage_heading:after, .wpb_content_element .widget-title:after, .wpb_content_element .widgettitle:after, .wpb_content_element .wpb_singleimage_heading:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.color-theme .widget-title, .color-theme .widgettitle {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.wp-sidebar ul li a:hover, .elementor-widget-sidebar ul li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.wp-sidebar .post-author, .wp-sidebar .post-date, .elementor-widget-sidebar .post-author, .elementor-widget-sidebar .post-date {
   color: <?php echo esc_attr($theme_color) ?>;
}
#wp-footer .widget ul li a:hover, #wp-footer .wpb_single_image ul li a:hover, #wp-footer .widget_nav_menu ul li a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
#wp-footer .widget_calendar td a {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
#wp-footer .widget_categories a:hover, #wp-footer .widget_archive a:hover, #wp-footer .wp-sidebar .widget_nav_menu a:hover, #wp-footer #wp-footer .widget_nav_menu a:hover, #wp-footer .elementor-widget-sidebar .widget_nav_menu a:hover, #wp-footer .widget_pages a:hover, #wp-footer .widget_meta a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.widget_calendar .wp-calendar-table td a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_calendar .wp-calendar-table #today {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_calendar .wp-calendar-table #today:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget_tag_cloud .tagcloud > a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget_categories ul > li > a:hover, .widget_archive ul > li > a:hover, .wp-sidebar .widget_nav_menu ul > li > a:hover, #wp-footer .widget_nav_menu ul > li > a:hover, .elementor-widget-sidebar .widget_nav_menu ul > li > a:hover, .widget_pages ul > li > a:hover, .widget_meta ul > li > a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_categories ul > li.current_page_item > a, .widget_archive ul > li.current_page_item > a, .wp-sidebar .widget_nav_menu ul > li.current_page_item > a, #wp-footer .widget_nav_menu ul > li.current_page_item > a, .elementor-widget-sidebar .widget_nav_menu ul > li.current_page_item > a, .widget_pages ul > li.current_page_item > a, .widget_meta ul > li.current_page_item > a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_rss ul > li a .post-date, .widget_recent_entries ul > li a .post-date {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_rss > ul li .rss-date {
   color: <?php echo esc_attr($theme_color) ?>;
}
.opening-time .phone {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_gva_give_categories_widget ul.categories-listing li:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.support-box {
   background: <?php echo esc_attr($theme_color) ?>;
}
.download-box a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.modal-ajax-user-form .close {
   background: <?php echo esc_attr($theme_color) ?>;
}
.modal-ajax-user-form .ajax-user-form .title:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.modal-ajax-user-form .ajax-user-form .lost-password a, .modal-ajax-user-form .ajax-user-form .user-registration a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.modal-ajax-user-form .ajax-form-content.ajax-preload .form-action:after {
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.user-wishlist .wishlist-link:hover .wishlist-icon i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.user-wishlist .wishlist-link:hover .wishlist-icon svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.post .entry-meta .meta-inline > span i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.post .entry-meta .entry-date {
   background: <?php echo esc_attr($theme_color) ?>;
}
.post .tag-links > a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.post-style-2 .entry-content .entry-meta .left {
   border: 2px solid <?php echo esc_attr($theme_color) ?>;
}
.post-style-2 .entry-content .entry-meta .right i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.post-style-2 .entry-content .read-more .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.post-style-2:hover .entry-content .entry-meta .left {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.single.single-post #wp-content > article.post .cat-links i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single.single-post #wp-content > article.post .cat-links a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single.single-post #wp-content > article.post .post-content input[type="submit"] {
   background: <?php echo esc_attr($theme_color) ?>;
}
.social-networks-post > li:not(.title-share) a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.post-navigation a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-event-list-block .tribe-event-left .content-inner .tribe-start-date {
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-event-list-block .tribe-event-right .content-inner .tribe-events-event-meta .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-event-list-block.v2 .event-action a {
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.tribe-events .tribe-events-c-ical__link {
   border-color: <?php echo esc_attr($theme_color) ?>;
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events .tribe-events-c-ical__link:hover, .tribe-events .tribe-events-c-ical__link:active, .tribe-events .tribe-events-c-ical__link:focus {
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn {
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-common .tribe-common-c-btn:hover, .tribe-common .tribe-common-c-btn:active, .tribe-common .tribe-common-c-btn:focus, .tribe-common a.tribe-common-c-btn:hover, .tribe-common a.tribe-common-c-btn:active, .tribe-common a.tribe-common-c-btn:focus {
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-schedule .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-single-detail .tribe-event-single-meta-detail > div .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-organizer > .content-inner .meta-item .icon svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-venue > .content-inner {
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-venue > .content-inner:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.post-type-archive-tribe_events #tribe-events-bar #tribe-bar-form .tribe-bar-submit .tribe-events-button {
   background: <?php echo esc_attr($theme_color) ?>;
}
.post-type-archive-tribe_events table.tribe-events-calendar tbody td .tribe-events-tooltip .tribe-events-event-body .tribe-event-duration {
   color: <?php echo esc_attr($theme_color) ?>;
}
.post-type-archive-tribe_events table.tribe-events-calendar tbody td:hover {
   border-bottom: 2px solid <?php echo esc_attr($theme_color) ?> !important;
}
.team-progress-wrapper .team__progress .team__progress-bar {
   background: <?php echo esc_attr($theme_color) ?>;
}
.team-progress-wrapper .team__progress .team__progress-bar .percentage {
   background: <?php echo esc_attr($theme_color) ?>;
}
.team-progress-wrapper .team__progress .team__progress-bar .percentage:after {
   border-top-color: <?php echo esc_attr($theme_color) ?>;
}
.team-block.team-v1 .team-content .socials-team a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.team-block.team-v1:hover .team-content {
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.owl-item.center .team-block .team-content {
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.team-block-single .heading:after, .team-block-single .heading-contact:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.team-block-single .team-quote:after {
   color: <?php echo esc_attr($theme_color) ?>;
}
.team-block-single .socials-team a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.lt-review-show-start .review-results .votes-stars span {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block .listing-image .wishlist-icon-content a.wishlist-added .icon:before {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block .listing-content .listing-meta .location .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block .listing-content .listing-meta .phone .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block .listing-content .content-footer .lt-avg-review {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block.job_position_featured .listing-image .lt-featured:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.listing-block.style-2:hover .listing-content .title a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-block.style-2:hover .listing-content .content-footer .lt_block-category .cat-name:hover, .listing-block.style-2:hover .listing-content .content-footer .lt_block-category .more-cat-number:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.leaflet-container .leaflet-marker-icon.gva-logo-map .logo-map svg {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.leaflet-popup .leaflet-popup-content-wrapper .leaflet-popup-content .gva-map-content-popup .content-inner .title a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.leaflet-container a.leaflet-popup-close-button {
   color: <?php echo esc_attr($theme_color) ?>;
}
.leaflet-container a.leaflet-popup-close-button:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.my-listing-item .listing-content .listing-status {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt_block-category .cat-item a .icon {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt_block-category .cat-item a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt_block-category .more-cat .more-cat-number:hover {
   cursor: pointer;
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.lt_block-category .more-cat:hover .more-cat-number {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .search_jobs .lt-filter-by-amenities .title:hover {
   cursor: pointer;
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .search_jobs .lt-filter-by-amenities ul.amenities-list > li .pretty .state .icon {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .search_jobs .lt_search_location .search-location-inner .places_list_autocomplete ul li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .search_jobs .lt-filter-distance-slider .lt-filter-slider .ui-slider-range {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .search_jobs .lt-filter-distance-slider .lt-filter-slider .ui-slider-handle {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt-listing-filters .showing_jobs a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-page_layout-filters_left .lt-sidebar-search > .content-inner .control-search-mobile, .lt-page_layout-filters_right .lt-sidebar-search > .content-inner .control-search-mobile {
   background: <?php echo esc_attr($theme_color) ?>;
}
div.job_listings .load_more_jobs {
   background-color: <?php echo esc_attr($theme_color) ?>;
}
div.job_listings .load_more_jobs:hover, div.job_listings .load_more_jobs:focus {
   background: <?php echo esc_attr($theme_color) ?>;
}
div.job_listings .load_more_jobs.loading {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
nav.job-manager-pagination ul li a:hover, nav.job-manager-pagination ul li span:hover {
   background: <?php echo esc_attr($theme_color) ?>;
   color: #fff;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
nav.job-manager-pagination ul li span.current {
   background: <?php echo esc_attr($theme_color) ?>;
   color: #fff;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.listing-single-content .listing-cover-gallery .item .image-expand:hover {
   background: <?php echo esc_attr($theme_color) ?>;
   color: #fff;
}
.listing-single-content .listing-top-content .lt-content-top-left .content-right .lt-category a:hover .cat-name {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.listing-single-content .content-top-right .listing-price-wishlist > div.lt-price-range {
   margin-right: 30px;
   color: <?php echo esc_attr($theme_color) ?>;
   letter-spacing: 2px;
}
.listing-single-content .content-top-right .listing-price-wishlist > div.wishlist .ajax-wishlist-link .icon {
   color: <?php echo esc_attr($theme_color) ?>;
   margin-left: 2px;
}
.listing-single-content .content-top-right .listing-price-wishlist > div.wishlist .ajax-wishlist-link:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-single-content .listing-main-content .listing-tags .block-content a.tag-item:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.listing-single-content .listing-amenities .block-content .amenities-list > li.amenity-item .icon-box .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.listing-single-content .listing-amenities .block-content .amenities-list > li.amenity-item.without-icon .icon-box .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-reviews-text .review-avg-content .review-star .lt-review-name {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-reviews-text .review-avg-items .review-avg-item .review-value {
   color: <?php echo esc_attr($theme_color) ?>;
}
.lt-reviews-text .review-avg-items .more-reviews:hover .icon-more {
   color: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.review-progress-wrapper .review__progress .review__progress-bar {
   background: <?php echo esc_attr($theme_color) ?>;
}
.review-progress-wrapper .review__progress .review__progress-bar .percentage {
   background: <?php echo esc_attr($theme_color) ?>;
}
.review-progress-wrapper .review__progress .review__progress-bar .percentage:after {
   border-top-color: <?php echo esc_attr($theme_color) ?>;
}
.single_listing-map #lt-listing--map #listing-single-icon {
   fill: <?php echo esc_attr($theme_color) ?>;
}
.single_listing-information > div.item i {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single_listing-information > div.item a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single_listing-social a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single_listing-open-hours .current-time {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single_lising-contact .lt-email .icon {
   color: <?php echo esc_attr($theme_color) ?>;
}
#submit-job-form .fieldset-logged_in .button {
   background: <?php echo esc_attr($theme_color) ?>;
}
#submit-job-form fieldset.fieldset-lt_amenities ul.job-manager-term-checklist > li .pretty .state .icon {
   background: <?php echo esc_attr($theme_color) ?>;
}
.fieldset-type-file .field .job-manager-uploaded-files .job-manager-uploaded-file .job-manager-remove-uploaded-file {
   background: <?php echo esc_attr($theme_color) ?>;
}
#job-manager-job-dashboard .sidebar .content-inner .user-navigation ul li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
#job-manager-job-dashboard .sidebar .content-inner .user-navigation ul li.active a {
   color: <?php echo esc_attr($theme_color) ?>;
}
#job-manager-job-dashboard .my-packages .package-item .title:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
#job-manager-job-dashboard .main-dashboard .dashboard-card {
   background: <?php echo esc_attr($theme_color) ?>;
}
.lt-change-profile-form .job-manager-uploaded-files .job-manager-uploaded-file .job-manager-remove-uploaded-file {
   background: <?php echo esc_attr($theme_color) ?>;
}
.pagination .disabled {
   background: <?php echo esc_attr($theme_color) ?>;
}
.pagination .current {
   background: <?php echo esc_attr($theme_color) ?>;
}
.not-found-wrapper .not-found-home > a {
   background: <?php echo esc_attr($theme_color) ?>;
}
.not-found-wrapper .not-found-home > a:hover, .not-found-wrapper .not-found-home > a:active, .not-found-wrapper .not-found-home > a:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
.content-page-index .post-masonry-index .post.sticky .entry-content:after {
   color: <?php echo esc_attr($theme_color) ?>;
}
.wpcf7-form select {
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments .comments-title:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments #add_review_button,
 #comments #submit {
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments #reply-title {
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-rate .on {
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-info:after {
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-info a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-review-avg {
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-action-wrap a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.comment-rating .comment-star-rating > li a.active {
   color: <?php echo esc_attr($theme_color) ?>;
}
.comment-with-review #lt-comment-reviews .comment-reviews-content .avg-total-tmp span.value {
   color: <?php echo esc_attr($theme_color) ?>;
}
.cld-like-dislike-wrap .cld-like-wrap {
   color: <?php echo esc_attr($theme_color) ?>;
}
.cld-like-dislike-wrap .cld-like-wrap a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.pretty input:checked ~ .state.p-success label:after, .pretty.p-toggle .state.p-success label:after {
   background-color: <?php echo esc_attr($theme_color) ?> !important;
}
.pretty input:checked ~ .state.p-success-o label:before, .pretty.p-toggle .state.p-success-o label:before {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.pretty input:checked ~ .state.p-success-o .icon, .pretty input:checked ~ .state.p-success-o .svg, .pretty input:checked ~ .state.p-success-o svg, .pretty.p-toggle .state.p-success-o .icon, .pretty.p-toggle .state.p-success-o .svg, .pretty.p-toggle .state.p-success-o svg {
   color: <?php echo esc_attr($theme_color) ?>;
   stroke: <?php echo esc_attr($theme_color) ?>;
}
.pretty.p-default:not(.p-fill) input:checked ~ .state.p-success-o label:after {
   background-color: <?php echo esc_attr($theme_color) ?> !important;
}
.pretty.p-switch input:checked ~ .state.p-success:before {
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.pretty.p-switch.p-fill input:checked ~ .state.p-success:before {
   background-color: <?php echo esc_attr($theme_color) ?> !important;
}
.owl-carousel .owl-nav > div:hover, .owl-carousel .owl-nav > div:focus, .flex-control-nav .owl-nav > div:hover, .flex-control-nav .owl-nav > div:focus, .ctf-tweets .owl-nav > div:hover, .ctf-tweets .owl-nav > div:focus {
   background: <?php echo esc_attr($theme_color) ?>;
}
.owl-carousel .owl-dots .owl-dot.active, .flex-control-nav .owl-dots .owl-dot.active, .ctf-tweets .owl-dots .owl-dot.active {
   background: <?php echo esc_attr($theme_color) ?>;
}
ul.nav-tabs > li > a:hover, ul.nav-tabs > li > a:focus, ul.nav-tabs > li > a:active {
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.nav-tabs > li.active > a {
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.select2-container .select2-dropdown ul.select2-results__options li.select2-results__option--highlighted {
   color: <?php echo esc_attr($theme_color) ?>;
}
.select2-container .select2-dropdown ul.select2-results__options li[aria-selected="true"] {
   color: <?php echo esc_attr($theme_color) ?>;
}
.select2-container .select2-selection .select2-selection__rendered .select2-selection__clear {
   background: <?php echo esc_attr($theme_color) ?>;
}
.select2-selection.select2-selection--multiple .select2-selection__rendered li.select2-selection__choice .select2-selection__choice__remove {
   background: <?php echo esc_attr($theme_color) ?>;
}
#ui-datepicker-div button {
   background: <?php echo esc_attr($theme_color) ?>;
}
#ui-datepicker-div .ui-widget-header {
   background: <?php echo esc_attr($theme_color) ?>;
}

 .woocommerce-tabs .nav-tabs > li.active > a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-tab-product-info .submit {
   background: <?php echo esc_attr($theme_color) ?>;
}
.minibasket.light i {
   color: <?php echo esc_attr($theme_color) ?>;
}
table.variations a.reset_variations {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.single-product .social-networks > li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .image_frame .woocommerce-product-gallery__trigger:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .image_frame .onsale {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product ol.flex-control-nav.flex-control-thumbs .owl-item img.flex-active {
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-main.product-type-grouped table.group_table tr td.label a:hover, .single-product .product-single-main.product-type-grouped table.group_table tr td label a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .entry-summary .price {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .cart .button, .single-product .product-single-inner .add-cart .button {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .cart .button:hover, .single-product .product-single-inner .add-cart .button:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .yith-wcwl-add-to-wishlist a {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .yith-wcwl-add-to-wishlist a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner a.compare {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner a.compare:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .table-product-group td.label a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .add-cart button {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .add-cart button:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product_meta > span a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-account .woocommerce-MyAccount-navigation ul > li.is-active a {
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce #breadcrumb a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-page .content-page-inner input.button, .woocommerce-page .content-page-inner a.button {
   background: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-cart-form__contents .woocommerce-cart-form__cart-item td.product-remove a.remove {
   background: <?php echo esc_attr($theme_color) ?>;
}
.shop-loop-actions .quickview a:hover, .shop-loop-actions .yith-wcwl-add-to-wishlist a:hover, .shop-loop-actions .yith-compare a:hover, .shop-loop-actions .add-to-cart a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.shop-loop-price .price {
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-countdown .countdown-times > div.day {
   color: <?php echo esc_attr($theme_color) ?>;
}
.product_list_widget .minicart-close:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.product_list_widget.cart_list .widget-product .name a:hover {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.product_list_widget.cart_list .widget-product .remove {
   background: <?php echo esc_attr($theme_color) ?>;
}
.woo-display-mode > a:hover, .woo-display-mode > a:active, .woo-display-mode > a:focus, .woo-display-mode > a.active {
   background: <?php echo esc_attr($theme_color) ?>;
}
.filter-sidebar .filter-sidebar-inner.layout-offcavas .filter-close {
   background: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce .button[type*="submit"] {
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_layered_nav ul > li a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_product_categories li.current-cat > a {
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.widget.widget_product_categories ul.product-categories > li.has-sub .cat-caret:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_product_categories ul.product-categories > li ul a:hover {
   color: <?php echo esc_attr($theme_color) ?>;
}
.package-block .product-block-inner .package-content .content-inner .add-to-cart a:hover {
   background: <?php echo esc_attr($theme_color) ?>;
}
.package-block:hover .product-block-inner .package-top {
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.product-type-lt_package.featured .package-block .product-block-inner .package-top {
   background-color:  <?php echo esc_attr($theme_color) ?>;
}


<?php } //End Color Theme ?> 

<?php

      $styles = ob_get_clean();
      
      $styles = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $styles );
      
      $styles = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '   ', '    ' ), '', $styles );

      if($styles){
         wp_enqueue_style( 'ziston-custom-style-color', ZISTON_THEME_URL . '/css/custom_script.css');
         wp_add_inline_style( 'ziston-custom-style-color', $styles );
      }

   }
}

add_action( 'wp_enqueue_scripts', 'ziston_custom_color_theme', 99999 );