<?php
if( class_exists('WP_Job_Manager_Shortcodes') ){
	remove_action( 'job_manager_job_filters_end', array(WP_Job_Manager_Shortcodes::instance(), 'job_filter_job_types'), 20 );
}

add_filter( 'job_manager_job_listings_output', 'ziston_layout_listings_page', 10, 1 );

add_theme_support( 'job-manager-templates' );

add_action('admin_enqueue_scripts', 'ziston_init_listings_scripts', 99);
add_action('wp_enqueue_scripts', 'ziston_init_listings_scripts', 99);

function ziston_init_listings_scripts(){
	// Scripts Listings

	$map_options = ziston_map_options();
	if( $map_options['map_source'] == 'google' ){
		wp_register_script('map-api', 'https://maps.googleapis.com/maps/api/js?libraries=places&key=' . esc_attr($map_options['map_api_key']), array( 'jquery' ));
	}

	wp_register_script('leaflet', ZISTON_THEME_URL . '/js/leaflet/js/leaflet.js');
	wp_register_script('leaflet-markercluster', ZISTON_THEME_URL . '/js/leaflet/js/leaflet.markercluster.js');
	wp_register_script('leaflet-googlemutant', ZISTON_THEME_URL . '/js/leaflet/Leaflet.GoogleMutant.js');
	wp_register_script('geocoder-control', ZISTON_THEME_URL . '/js/leaflet/control.geocoder.js', array( 'jquery' )); 
	wp_register_script('ziston-listing', ZISTON_THEME_URL . '/js/listing/listing.js', array( 'jquery',  'jquery-ui-slider' ));  
	
	wp_register_script('ziston-listing-fields', ZISTON_THEME_URL . '/js/listing/listing-fields.js', array( 'jquery' ));  

	wp_register_style('leaflet', ZISTON_THEME_URL . '/js/leaflet/css/leaflet.css');
	wp_register_style('marker-cluster', ZISTON_THEME_URL . '/js/leaflet/css/MarkerCluster.css');
	wp_register_style('marker-cluster-default', ZISTON_THEME_URL . '/js/leaflet/css/MarkerCluster.Default.css');
	wp_register_style('geocoder-control', ZISTON_THEME_URL . '/js/leaflet/css/Control.Geocoder.css');

	wp_localize_script( 'ajax-form', 'ziston_ajax_object', array( 
	  'ajaxurl' => admin_url( 'admin-ajax.php' ),
	  'security_nonce' => wp_create_nonce( "ziston-ajax-security-nonce" )
	));

}

function ziston_layout_listings_page( $html ) {
	
	global $post;

	wp_enqueue_script('map-api');
	wp_enqueue_script('leaflet');
	wp_enqueue_script('leaflet-markercluster');
	wp_enqueue_script('leaflet-googlemutant');
	wp_enqueue_script('geocoder-control');
	wp_enqueue_script('select2');
	wp_enqueue_script('ziston-listing'); 
  
	wp_enqueue_style('leaflet');
	wp_enqueue_style('marker-cluster');
	wp_enqueue_style('marker-cluster-default');
	wp_enqueue_style('geocoder-control');
	wp_enqueue_style('select2');

	$map_options = ziston_map_options();
	$map_options['mode'] = 'map';
	wp_localize_script( 'ziston-listing', 'ziston_map_options', $map_options );
	
	$layout_settings = ziston_listings_layout_page();
  
	$layout = $layout_settings['layout'];
	$show_map = $layout_settings['show_map_top'];
	$output = '';
	if($layout == 'half_map'){

		$output .= '<div class="lt--map-layout lt--warpper">';
			$output .= '<div class="lt--content-inner show-content">';
			  
				$output .= '<div class="lt-layout-row">';

					$output .= '<div class="lt-mobile-control">';
						$output .= '<a href="#" class="btn-small btn-theme btn-show-map"><i class="far fa-map"></i>' . esc_html__('Map View', 'ziston') . '</a>';
						$output .= '<a href="#" class="btn-small btn-theme btn-show-content"><i class="fas fa-list"></i>' . esc_html__('Content View', 'ziston') . '</a>';
					$output .= '</div>';

					$output .= '<div class="lt--results-content">';
						$output .= '<div class="lt-content-inner clearfix">';
							
					 		$output .= $html;

						$output .= '</div>';
					$output .= '</div>';

					$output .= '<div class="lt--map-content">';
						$output .= '<div id="lt-listing--map" class="lt-listing--map lt-map-main hidden-sm hidden-xs"></div>';
					$output .= '</div>';

				$output .= '</div>'; //End row    

			$output .= '</div>';
		$output .= '</div>';

	}elseif($layout == 'filters_left' || $layout == 'filters_right'){

		$output .= '<div class="lt--filters-slidebar-layout lt--warpper">';
			$output .= '<div class="lt--content-inner">';
					
				$output .= '<div class="lt--results-content">';
					$output .= '<div class="lt-content-inner container">';
						$output .= '<div class="row">';
							
							$output .= $html;

						$output .= '</div>';	
					$output .= '</div>';
				$output .= '</div>';

			$output .= '</div>';
		$output .= '</div>';

  	}elseif($layout == "filters_hidden" ){

	  	$output .= '<div class="lt--hidden-filters-layout lt--warpper">';
			$output .= '<div class="lt--content-inner">';
					
				$output .= '<div class="lt--results-content">';
					$output .= '<div class="lt-content-inner container">';
						$output .= '<div class="row">';
							
							$output .= $html;

						$output .= '</div>';	
					$output .= '</div>';
				$output .= '</div>';

			$output .= '</div>';
		$output .= '</div>';

  	}elseif($layout == 'full_map'){

  		$output .= '<div class="lt--full-map-layout lt--warpper">';
			$output .= '<div class="lt--content-inner show-content">';
			  
				$output .= '<div class="lt-layout-row">';

					$output .= '<div class="lt--results-content d-none">';
						$output .= '<div class="lt-content-inner clearfix">';
							
					 		$output .= $html;

						$output .= '</div>';
					$output .= '</div>';

					$output .= '<div class="lt--map-content">';
						$output .= '<div id="lt-listing--map" class="lt-listing--map lt-map-main hidden-sm hidden-xs"></div>';
					$output .= '</div>';

				$output .= '</div>'; //End row    

			$output .= '</div>';
		$output .= '</div>';

  	}
  return $output;
}

add_filter( 'job_manager_get_listings_result', 'ziston_listings_custom_results', 10, 2 );
function ziston_listings_custom_results( $result, $jobs ) {
	$result[ 'found' ] = $jobs->found_posts == 0 ? 0 : $jobs->found_posts;
	if ( isset($_REQUEST['form_data']) ) {
		$form_data = urldecode($_REQUEST['form_data']);
		parse_str($form_data, $data);
		if( 
			(isset($data['_search_location']) && !empty($data['_search_location']) ) ||
			( isset($data['filter_listing_region']) && array($data['filter_listing_region']) && count($data['filter_listing_region']) > 0 && $data['filter_listing_region'][0] > 0 ) || 
			( isset($data['lt_filter_job_type']) && array($data['lt_filter_job_type']) && count($data['lt_filter_job_type']) > 0 && !empty($data['lt_filter_job_type'][0]) ) ||
			( isset($data['lt_filter_price_range']) && !empty($data['lt_filter_price_range']) ) ||
			( isset($data['filter_listing_amenity']) && !empty($data['filter_listing_amenity']) ) 
		){
			$result[ 'showing' ] = sprintf(esc_html__('Search completed. Found %s matching record', 'ziston'), $jobs->found_posts) . $result['showing_links'];
			$result['showing_links'] = '';
		}
	}

	return $result;
}

add_filter('the_content', 'ziston_listing_count_views');
function ziston_listing_count_views($content){
	global $post;
	if ( $post->post_type == 'job_listing' ) {
		$key = '_count_views';
	   $count = get_post_meta($post->ID, $key, true);
	   if( empty($count) ){
	      delete_post_meta($post->ID, $key);
	      add_post_meta($post->ID, $key, 1);
	   }else{
	      $count++;
	      update_post_meta($post->ID, $key, sanitize_text_field($count));
	   }
	}

   return $content;
}

add_filter( 'wp_get_nav_menu_items', 'ziston_nav_items', 11, 3 );

function ziston_nav_items( $items, $menu, $args ) {
   $job_dashboard_page_id = get_option( 'job_manager_job_dashboard_page_id' );
   if( is_admin() ){
      return $items;
   }
   foreach( $items as $item ) {
      if( $job_dashboard_page_id == $item->object_id ){
         $item->url .= '?dashboard=' . $item->attr_title;
      }
   }
   return $items;
}

function ziston_manange_package(){
	$lt_enable_package = get_option( 'ziston_enable_paid', '' );
	$lt_enable_package_option = ziston_get_option('lt_enable_paid', 'enable');
	if( empty($lt_enable_package) ){
   	update_option('ziston_enable_paid', 'enable');
	}elseif( $lt_enable_package != $lt_enable_package_option ){
   	update_option('ziston_enable_paid', $lt_enable_package_option );
   }
}
add_action( 'init', 'ziston_manange_package', 1 );


function ziston_job_type_label($fields){
	if(isset($fields['job']['job_type']['label'])){
		$fields['job']['job_type']['label'] = esc_html__( 'Type', 'ziston' );
	}
	return $fields;
}	

add_filter( 'submit_job_form_fields', 'ziston_job_type_label', 1 ); 