<?php
function ziston_map_options(){
	$current_position_style = apply_filters('ziston_current_position_style', 'default');
	$option = array(
		'map_source' 				=> ziston_get_option('lt_map_source', 'mapbox'),
		'latitude'					=> ziston_get_option('lt_default_latitude', '40.749402'),
		'longitude'					=> ziston_get_option('lt_default_longitude', '-74.1752547'),
		'map_zoom'					=> ziston_get_option('lt_map_zoom', '14'),
		'google_map_style'		=> ziston_get_option('lt_google_map_style', ''),
		'mapbox_token'				=> ziston_get_option('lt_mapbox_token', 'pk.eyJ1IjoibmFtY3QiLCJhIjoiY2tnOHFwdHBsMGdodTJ5bHNwbnF5Mm5mciJ9.VNYZ-1YeH6oUe-2RvRGbyw'),
		'mapbox_style'				=> ziston_get_option('lt_mapbox_style', 'streets-v11'),
		'map_api_key'				=> ziston_get_option('map_api_key', ''),
		'mode'						=> 'element',
		'current_position'		=> $current_position_style
	);
	return $option;
}

function ziston_listing_info($post_id, $prefix = ''){
	$data = array(
		'phone'		=> get_post_meta( $post_id, '_lt_phone', true ),
		'address'	=> get_post_meta( $post_id, '_lt_address', true ),
		'email'		=> get_post_meta( $post_id, '_lt_email', true ),
		'website'	=> get_post_meta( $post_id, '_lt_website', true ),
	);
	return $data;
}

function ziston_listing_social($post_id, $prefix = ''){
	$data = array(
		'facebook' 	=> get_post_meta( $post_id, '_lt_social_facebook', true ),
		'linkedin' 	=> get_post_meta( $post_id, '_lt_social_linkedin', true ),
		'twitter' 	=> get_post_meta( $post_id, '_lt_social_twitter', true ),
		'instagram' => get_post_meta( $post_id, '_lt_social_instagram', true ),
		'tumbler' 	=> get_post_meta( $post_id, '_lt_social_tumbler', true ),
		'pinterest' => get_post_meta( $post_id, '_lt_social_pinterest', true ),
		'vimeo' 		=> get_post_meta( $post_id, '_lt_social_vimeo', true ),
		'youtube' 	=> get_post_meta( $post_id, '_lt_social_youtube', true )
	);
	return $data;
}

function ziston_lising_single_cover_style($post_id){
	$style = get_post_meta( $post_id, '_lt_single_style', true );
	if( empty($style) ){
		$style = "cover_gallery";
	}
	$photos = get_post_meta( $post_id, '_lt_gallery_images', true );
	if( empty($photos) ){
		$style = "cover_image";
	}
	if( is_array($photos) && count($photos) == 0 ){
		$style = "cover_image";
	}
	return $style;
}

function ziston_listings_layout_page(){
	global $post;
	$layout = $layout_items = $show_map_top = $grid_columns = $per_page = $pagination_style = '';

	if ( is_page() && is_object($post) ) {
		$post_id = $post->ID;
		$layout					= get_post_meta( $post_id, 'ziston_lt_layout_page', true );
		$layout_item			= get_post_meta( $post_id, 'ziston_lt_layout_item', true );
		$grid_columns_lg		= get_post_meta( $post_id, 'ziston_lt_grid_columns_lg', true );
		$grid_columns_md		= get_post_meta( $post_id, 'ziston_lt_grid_columns_md', true );
		$grid_columns_sm		= get_post_meta( $post_id, 'ziston_lt_grid_columns_sm', true );
		$grid_columns_xs		= get_post_meta( $post_id, 'ziston_lt_grid_columns_xs', true );
		$pagination_style		= get_post_meta( $post_id, 'ziston_lt_pagination_style', true );
		$show_map_top			= get_post_meta( $post_id, 'ziston_lt_show_map_top', true );
		$show_rating			= get_post_meta($post_id, 'ziston_lt_show_rating', true);
		$show_tagline			= get_post_meta($post_id, 'ziston_lt_show_tagline', true);
		$per_page 				= get_post_meta($post_id, 'ziston_lt_per_page', true);
	}

	if ( isset($_REQUEST['form_data']) ) {
		$form_data = urldecode($_REQUEST['form_data']);
		parse_str($form_data, $settings);

		if( isset($settings['lt_layout']) && $settings['lt_layout'] ){
			$layout = $settings['lt_layout'];
		}	

		if( isset($settings['lt_layout_item']) && $settings['lt_layout_item'] ){
			$layout_item = $settings['lt_layout_item'];
		}	

		if( isset($settings['lt_grid_columns_lg']) && $settings['lt_grid_columns_lg'] ){
			$grid_columns = $settings['lt_grid_columns_lg'];
		}

		if( isset($settings['lt_grid_columns_md']) && $settings['lt_grid_columns_md'] ){
			$grid_columns = $settings['lt_grid_columns_md'];
		}

		if( isset($settings['lt_grid_columns_sm']) && $settings['lt_grid_columns_sm'] ){
			$grid_columns = $settings['lt_grid_columns_sm'];
		}

		if( isset($settings['lt_grid_columns_xs']) && $settings['lt_grid_columns_xs'] ){
			$grid_columns = $settings['lt_grid_columns_xs'];
		}

		if( isset($settings['lt_show_map_top']) && $settings['lt_show_map_top'] ){
			$show_map_top = $settings['lt_show_map_top'];
		}

		if( isset($settings['lt_show_rating']) && $settings['lt_show_rating'] ){
			$show_rating = $settings['lt_show_rating'];
		}

		if( isset($settings['lt_show_tagline']) && $settings['lt_show_tagline'] ){
			$show_tagline = $settings['lt_show_tagline'];
		}
	}

	if( empty($layout) ){
		$layout = ziston_get_option('lt_layout_page', 'filters_left');
	}
	if( empty($layout_item) ){
		$layout_item = ziston_get_option('lt_layout_item', 'item-grid-1');
	}
	if( empty($show_map_top) ){
		$show_map_top = ziston_get_option('lt_show_map_top', 'item-grid-1');
	}
	if( empty($grid_columns_lg) ){
		$grid_columns_lg = ziston_get_option('lt_grid_columns_lg', '3');
	}
	if( empty($grid_columns_md) ){
		$grid_columns_md = ziston_get_option('lt_grid_columns_md', '3');
	}
	if( empty($grid_columns_sm) ){
		$grid_columns_sm = ziston_get_option('lt_grid_columns_sm', '3');
	}
	if( empty($grid_columns_xs) ){
		$grid_columns_xs = ziston_get_option('lt_grid_columns_xs', '2');
	}
	if( empty($pagination_style) ){
		$pagination_style = ziston_get_option('lt_pagination_style', 'load_more');
	}
	if( empty($show_rating) ){
		$show_rating = ziston_get_option('lt_show_rating', 'number');
	}
	if( empty($show_tagline) ){
		$show_tagline = ziston_get_option('lt_show_tagline', 'yes');
	}
	if( empty($per_page) ){
		$per_page = get_option( 'job_manager_per_page', '12' );
	}
	$data = array(
		'layout'					=> $layout,
		'layout_item'			=> $layout_item,
		'show_map_top'			=> $show_map_top,
		'grid_columns_lg'		=> $grid_columns_lg,
		'grid_columns_md'		=> $grid_columns_md,
		'grid_columns_sm'		=> $grid_columns_sm,
		'grid_columns_xs'		=> $grid_columns_xs,
		'pagination_style'	=> $pagination_style,
		'show_rating'			=> $show_rating, 
		'show_tagline'			=> $show_tagline,
		'per_page'				=> $per_page
	);	

	return $data;
}

