<?php
function ziston_register_meta_boxes(){

	$prefix = 'ziston_';
	global $meta_boxes, $wp_registered_sidebars;
	$sidebar = array();
	$sidebar[""] = ' --Default-- ';
	foreach($wp_registered_sidebars as $key => $value){
		$sidebar[$value['id']] = $value['name'];
	}
	$default_options = get_option('ziston_options');
	
	$meta_boxes = array();

	/* Thumbnail Meta Box
	================================================== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_post_thumbnail',
		'title' => esc_html__('Thumbnail', 'ziston'),
		'pages' => array( 'post' ),
		'context' => 'normal',
		'fields' => array(
			
			// THUMBNAIL IMAGE
			array(
				'name'  => esc_html__('Thumbnail image', 'ziston'),
				'desc'  => esc_html__('The image that will be used as the thumbnail image.', 'ziston'),
				'id'    => "{$prefix}thumbnail_image",
				'type'  => 'image_advanced',
				'max_file_uploads' => 1
			),

			// THUMBNAIL VIDEO
			array(
				'name' => esc_html__('Thumbnail video URL', 'ziston'),
				'id' => $prefix . 'thumbnail_video_url',
				'desc' => esc_html__('Enter the video url for the thumbnail. Only links from Vimeo & YouTube are supported.', 'ziston'),
				'clone' => false,
				'type'  => 'oembed',
				'std' => '',
			),

			// THUMBNAIL AUDIO
			array(
				'name' => esc_html__('Thumbnail audio URL', 'ziston'),
				'id' => "{$prefix}thumbnail_audio_url",
				'desc' => esc_html__('Enter the audio url for the thumbnail.', 'ziston'),
				'clone' => false,
				'type'  => 'oembed',
				'std' => '',
			),

			// THUMBNAIL GALLERY
			array(
				'name'             => esc_html__('Thumbnail gallery', 'ziston'),
				'desc'             => esc_html__('The images that will be used in the thumbnail gallery.', 'ziston'),
				'id'               => "{$prefix}thumbnail_gallery",
				'type'             => 'image_advanced',
				'max_file_uploads' => 50,
			),

			// THUMBNAIL LINK TYPE
			array(
				'name' => esc_html__('Thumbnail link type', 'ziston'),
				'id'   => "{$prefix}thumbnail_link_type",
				'type' => 'select',
				'options' => array(
					'link_to_post'    => esc_html__('Link to item', 'ziston'),
					'link_to_url'     => esc_html__('Link to URL', 'ziston'),
					'link_to_url_nw'  => esc_html__('Link to URL (New Window)', 'ziston'),
					'lightbox_thumb'  => esc_html__('Lightbox to the thumbnail image', 'ziston'),
					'lightbox_image'  => esc_html__('Lightbox to image (select below)', 'ziston'),
					'lightbox_video'  => esc_html__('Fullscreen Video Overlay (input below)', 'ziston')
				),
				'multiple' => false,
				'std'  => 'link-to-post',
				'desc' => esc_html__('Choose what link will be used for the image(s) and title of the item.', 'ziston')
			),

			// THUMBNAIL LINK URL
			array(
				'name' => esc_html__('Thumbnail link URL', 'ziston'),
				'id' => $prefix . 'thumbnail_link_url',
				'desc' => esc_html__('Enter the url for the thumbnail link.', 'ziston'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),

			// THUMBNAIL LINK LIGHTBOX IMAGE
			array(
				'name'  => esc_html__('Thumbnail link lightbox image', 'ziston'),
				'desc'  => esc_html__('The image that will be used as the lightbox image.', 'ziston'),
				'id'    => "{$prefix}thumbnail_link_image",
				'type'  => 'thickbox_image'
			),
		)
	);

	 /* Page Meta Box
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'ziston'),
		'pages' => array( 'page', 'portfolio', 'product', 'post', 'service' ),
		'priority'   => 'high',
		'fields' => array(
			// Full width
			array(
				'name' => esc_html__('Full Width( 100% Main Width )', 'ziston'),
				'id'   => "{$prefix}page_full_width",
				'type' => 'switch',
				'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'ziston'),
				'std' => 0,
			),
			// Extra Page Class
			array(
				'name' => esc_html__('Header', 'ziston'),
				'id' => $prefix . 'page_header',
				'desc' => esc_html__("You can change header for page if you like's.", 'ziston'),
				'type'  => 'select',
				'options'   => ziston_get_headers(),
				'std' => '__default_option_theme',
			),
			array(
				'name'      => esc_html__('Footer', 'ziston'),
				'id'        => $prefix . 'page_footer',
				'desc'      => esc_html__("You can change footer for page if you like's",'ziston'),
				'type'      => 'select',
				'options'   =>  ziston_get_footer(),
				'std'       => '__default_option_theme'
			),
			// Extra Page Class
			array(
				'name' => esc_html__('Extra page class', 'ziston'),
				'id' => $prefix . 'extra_page_class',
				'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'ziston'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),
		  
		)
	);

	/* Page Title Meta Box
	================================================== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_page_heading',
		'title' => esc_html__('Page Title & Breadcrumb', 'ziston'),
		'pages' => array( 'post', 'page', 'product', 'portfolio', 'gallery', 'tribe_events', 'gva_team', 'service'),
		'context' => 'normal',
		'priority'   => 'high',
		'fields' => array(
		  array(
			 'name' => esc_html__('Remove Title of Page', 'ziston'),   
			 'id'   => "{$prefix}disable_page_title",
			 'type' => 'switch',
			 'std'  => 0,
		  ),
		  array(
			 'name' => esc_html__('Disable Breadcrumbs', 'ziston'),
			 'id'   => "{$prefix}no_breadcrumbs",
			 'type' => 'switch',
			 'desc' => esc_html__('Disable the breadcrumbs from under the page title on this page.', 'ziston'),
			 'std' => 0,
		  ),
		  array(
			 'name' => esc_html__('Breadcrumb Layout', 'ziston'),
			 'id'   => "{$prefix}breadcrumb_layout",
			 'type' => 'select',
			 'options' => array(
				 'theme_options'     => esc_html__('Default Options in Theme-Settings', 'ziston'),
				 'page_options'      => esc_html__('Individuals Options This Page', 'ziston')
			 ),
			 'multiple' => false,
			 'std'  => 'theme_options',
			 'desc' => esc_html__('You can use breadcrumb settings default in Theme-Settings or individuals this page', 'ziston')
		  ),
		  array(
			 'name'    => esc_html__('Show page title in the breadcrumbs', 'ziston'),   
			 'id'      => "{$prefix}page_title",
			 'type'    => 'select',
			 'options' => array(
				 'show'     => esc_html__('Show', 'ziston'),
				 'hide'      => esc_html__('Hidden', 'ziston')
			 ),
			 'std'     => 'show',

			 'class'   => 'breadcrumb_setting'
		  ),
		  array(
			 'name' => esc_html__('Page Title Override', 'ziston'),
			 'id' => $prefix . 'page_title_one',
			 'desc' => esc_html__("Enter a custom page title if you'd like.", 'ziston'),
			 'type'  => 'text',
			 'std' => '',
			 'class'   => 'breadcrumb_setting'
		  ),
		  array(
			 'name'        => esc_html__( 'Breadcrumb Padding Top (px)', 'ziston' ),
			 'id'          => "{$prefix}breadcrumb_padding_top",
			 'type'        => 'number',
			 'prefix'      => '',
			 'class'       => 'breadcrumb_setting',
			 'desc'        => esc_html__('Option Padding Top of Breacrumb, set empty = padding default of theme', 'ziston'),
			 'std'         => ziston_get_option('breadcrumb_padding_top', '135'),
		  ),
		  array(
			 'name'       => esc_html__( 'Breadcrumb Padding Bottom (px)', 'ziston' ),
			 'id'         => "{$prefix}breadcrumb_padding_bottom",
			 'type'       => 'number',
			 'prefix'     => 'px',
			 'class'      => 'breadcrumb_setting',
			 'desc'        => esc_html__('Option Padding Bottom of Breacrumb, set empty = padding default of theme', 'ziston'),
			 'std'        => ziston_get_option('breadcrumb_padding_bottom', '135'),
		  ),
		  array(
			 'name' => esc_html__( 'Background Overlay Color', 'ziston' ),
			 'id'   => "{$prefix}bg_color_title",
			 'desc' => esc_html__( "Set an overlay color for hero heading image.", 'ziston' ),
			 'type' => 'color',
			 'class'   => 'breadcrumb_setting',
			 'std'  => '',
		  ),
		  array(
			 'name'       => esc_html__( 'Overlay Opacity', 'ziston' ),
			 'id'         => "{$prefix}bg_opacity_title",
			 'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'ziston' ),
			 'clone'      => false,
			 'type'       => 'slider',
			 'prefix'     => '',
			 'class'   => 'breadcrumb_setting',
			 'js_options' => array(
				  'min'  => 0,
				  'max'  => 100,
				  'step' => 1,
			 ),
			 'std'   => '50'
		  ),
		  array(
			 'name'    => esc_html__('Enable Breadcrumb Image', 'ziston'),
			 'id'      => "{$prefix}image_breadcrumbs",
			 'type'    => 'switch',
			 'class'   => 'breadcrumb_setting',
			 'std'     => 1,
		  ),
		  array(
			 'name'  => esc_html__('Breadcrumb Background Image', 'ziston'),
			 'id'    => "{$prefix}page_title_image",
			 'type'  => 'image_advanced',
			 'class'   => 'breadcrumb_setting',
			 'max_file_uploads' => 1
		  ),
		  array(
			 'name' => esc_html__('Heading Text Style', 'ziston'),
			 'id'   => "{$prefix}page_title_text_style",
			 'type' => 'select',
			 'class'   => 'breadcrumb_setting',
			 'options' => array(
				 'text-light'     => esc_html__('Light', 'ziston'),
				 'text-dark'      => esc_html__('Dark', 'ziston')
			 ),
			 'multiple' => false,
			 'std'  => ziston_get_option('breadcrumb_text_stype', 'text-dark'),
			 'desc' => esc_html__('If you uploaded an image in the option above, choose light/dark styling for the text heading text here.', 'ziston')
		  ),
		  array(
			 'name' => esc_html__('Heading Text Align', 'ziston'),
			 'id'   => "{$prefix}page_title_text_align",
			 'type' => 'select',
			 'class'   => 'breadcrumb_setting',
			 'options' => array(
				 'text-left'      => esc_html__('Left', 'ziston'),
				 'text-center'    => esc_html__('Center', 'ziston'),
				 'text-right'     => esc_html__('Right', 'ziston')
			 ),
			 'multiple' => false,
			 'std'  => ziston_get_option('breadcrumb_text_align', 'text-center'),
			 'desc' => esc_html__('Choose the text alignment for the hero heading.', 'ziston')
		  ),
		)
	);

	/* Brands Meta Box
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_brands_options',
		'title' => esc_html__('Brands Options', 'ziston'),
		'pages' => array( 'brands'),
		'priority'   => 'high',
		'fields' => array(
			// LEFT SIDEBAR
			array (
				'name'   => esc_html__('Url Link', 'ziston'),
				 'id'    => "{$prefix}url_link",
				 'type' => 'text',
				 'std'   => ''
			),
		)
	);

	/* Sidebar Meta Box Page
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_sidebar_page',
		'title' => esc_html__('Sidebar Options', 'ziston'),
		'pages' => array( 'post', 'page', 'portfolio', 'gallery', 'tribe_events', 'service' ),
		'priority'   => 'high',
		'fields' => array(

			// SIDEBAR CONFIG
			array(
				'name' => esc_html__('Sidebar configuration', 'ziston'),
				'id'   => "{$prefix}sidebar_config",
				'type' => 'select',
				'options' => array(
				  ''                   => esc_html__('--Default--', 'ziston'),
				  'no-sidebars'        => esc_html__('No Sidebars', 'ziston'),
				  'left-sidebar'       => esc_html__('Left Sidebar', 'ziston'),
				  'right-sidebar'      => esc_html__('Right Sidebar', 'ziston'),
				),
				'multiple' => false,
				'std'  => '',
				'desc' => esc_html__('Choose the sidebar configuration for the detail page of this page.', 'ziston'),
			),

			// LEFT SIDEBAR
			array (
				'name'   => esc_html__('Left Sidebar', 'ziston'),
				 'id'    => "{$prefix}left_sidebar",
				 'type' => 'select',
				 'options'  => $sidebar,
				 'std'   => ''
			),

			// RIGHT SIDEBAR
			array (
				'name'   => esc_html__('Right Sidebar', 'ziston'),
				'id'    => "{$prefix}right_sidebar",
				'type' => 'select',
				'options'  => $sidebar,
				'std'   => ''
			),
		)
	);

  /* Gallery Meta Box 
  ================================================== */
  $meta_boxes[] = array(
	 'id'    => 'metaboxes_portfolio_page',
	 'title' => esc_html__('Portfolio Settings', 'ziston'),
	 'pages' => array( 'portfolio' ),
	 'priority'   => 'high',
	 'fields' => array(
		array (
		  'name'   => esc_html__('Gallery Images', 'ziston'),
		  'id'    => "{$prefix}gallery_images",
		  'type'             => 'image_advanced',
		  'max_file_uploads' => 50,
		),
	 )
  );


  $meta_boxes[] = array(
	 'id'    => 'metaboxes_gallery_page',
	 'title' => esc_html__('Gallery Settings', 'ziston'),
	 'pages' => array( 'gallery' ),
	 'priority'   => 'high',
	 'fields' => array(
		array (
		  'name'   => esc_html__('Gallery Images', 'ziston'),
		  'id'    => "{$prefix}gallery_images",
		  'type'             => 'image_advanced',
		  'max_file_uploads' => 50,
		),
	 )
  );

  /* Service Meta Box 
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'metaboxes_service_page',
		'title' => esc_html__('Service Link Settings', 'ziston'),
		'pages' => array( 'service' ),
		'priority' => 'low',
		'fields' => array(
		  array (
			 'name'   => esc_html__('Gallery Images', 'ziston'),
			 'id'    => "{$prefix}gallery_images",
			 'type'             => 'image_advanced',
			 'max_file_uploads' => 50,
		  ),
		  array(
			 'name' => esc_html__('Show Gallery Top Service Single Page', 'ziston'),
			 'id'   => "{$prefix}show_service_gallery",
			 'type' => 'switch',
			 'std' => 0,
		  ),
		  array (
			 'name'    => esc_html__('Extra Link', 'ziston'),
			 'id'      => "{$prefix}service_extra_link",
			 'type'    => 'text'
		  ),
		)
	);

	$map_api_key = ziston_get_option('map_api_key', 'AIzaSyChkvQkXo_61RR7u-XJOj-rLF9ekk9eRYc'); 
	 /* Event Meta Box 
	================================================== */

  $meta_boxes[] = array(
	 'id'    => 'metaboxes_team_page',
	 'title' => esc_html__('Team Settings', 'ziston'),
	 'pages' => array( 'gva_team' ),
	 'priority'   => 'high',
	 'fields' => array(
		array (
		  'name'   => esc_html__('Position', 'ziston'),
		  'id'    => "{$prefix}team_position",
		  'type' => 'text',
		  'std'   => ''
		),
		array (
		  'name'   => esc_html__('Quote', 'ziston'),
		  'id'    => "{$prefix}team_quote",
		  'type' => 'textarea',
		  'std'   => ''
		),
		array (
		  'name'   => esc_html__('Email', 'ziston'),
		  'id'    => "{$prefix}team_email",
		  'type' => 'text',
		  'std'   => ''
		),
		array (
		  'name'   => esc_html__('Phone', 'ziston'),
		  'id'    => "{$prefix}team_phone",
		  'type' => 'text',
		  'std'   => ''
		),
		array (
		  'name'   => esc_html__('Address', 'ziston'),
		  'id'    => "{$prefix}team_address",
		  'type' => 'text',
		  'std'   => ''
		),
	 )
  );

  $meta_boxes[] = array(
	 'id'    => 'metaboxes_header_builder',
	 'title' => esc_html__('Header Builder', 'ziston'),
	 'pages' => array( 'gva_header' ),
	 'priority' => 'high',
	 'fields' => array(
		array(
		  'name' => esc_html__('Enable Background Black', 'ziston'),
		  'id'   => "{$prefix}header_bg_black",
		  'type' => 'switch',
		  'desc' => esc_html__('It will display background black when builder header.', 'ziston'),
		  'std' => 0,
		),
		array(
		  'name' => esc_html__('Full Width( 100% Main Width )', 'ziston'),
		  'id'   => "{$prefix}header_full_width",
		  'type' => 'switch',
		  'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'ziston'),
		  'std' => 0,
	  ),
		array(
		  'name' => esc_html__('Position Styling', 'ziston'),
		  'id'   => "{$prefix}header_position",
		  'type' => 'select',
		  'options' => array(
			 'relative'      => esc_html__('Relative', 'ziston'),
			 'absolute'      => esc_html__('Absolute', 'ziston'),
		  ),
		  'std' => 'relative',
		  'multiple' => false,
		),
	 )
  );

  $meta_boxes[] = array(
	 'id'    => 'metaboxes_lt_package',
	 'title' => esc_html__('Data', 'ziston'),
	 'pages' => array( 'lt_package' ),
	 'fields' => array(
		array (
		  'name'    => esc_html__('Package Type', 'ziston'),
		  'id'      => "lt_package_type",
		  'type'    => 'text',
		  'desc' 	=> esc_html__('Woocommerce product ID', 'ziston'),
		),
		array (
		  'name'   	=> esc_html__('Listing Limit', 'ziston'),
		  'id'    	=> "lt_package_limit",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many listings should this package allow the user to post?', 'ziston'),
		),
		array (
		  'name'   	=> esc_html__('Listing Duration', 'ziston'),
		  'id'    	=> "lt_package_duration",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many days should listings posted with this package be active?', 'ziston'),
		),
		array (
		  'name'   	=> esc_html__('Listing Count', 'ziston'),
		  'id'    	=> "lt_package_count",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many listings has the user already posted with this package?', 'ziston'),
		),
		array (
		  'name'   	=> esc_html__('Feature Listings', 'ziston'),
		  'id'    	=> "lt_package_feature",
		  'type'    => 'checkbox',
		),
		array (
		  'name'   	=> esc_html__('User', 'ziston'),
		  'id'    	=> "lt_package_user",
		  'type'    => 'user',
		),
		array (
		  'name'   	=> esc_html__('Order ID', 'ziston'),
		  'id'    	=> "lt_package_order",
		  'type'    => 'textfield',
		  'desc' 	=> esc_html__('Optionally link this package to an order.', 'ziston'),
		),
	 )
  );


  $meta_boxes[] = array(
	 'id'    => 'metaboxes_listings_images',
	 'title' => esc_html__('Logo & Cover Image', 'ziston'),
	 'post_types' => array( 'job_listing' ),
	 'context'	=> 'side',
	 'priority'	=> 'low',
	 'fields' => array(
		array (
		  'name'   		=> esc_html__('Logo Image', 'ziston'),
		  'id'    		=> "_lt_logo_image",
		  'type'       => 'single_image',
		),
		array (
		  'name'   		=> esc_html__('Cover Image', 'ziston'),
		  'id'    		=> "_lt_cover_image",
		  'type'       => 'single_image',
		),
	 )
  );

   $meta_boxes[] = array(
	 'id'    => 'metaboxes_listings_additional',
	 'title' => esc_html__('Additional Info', 'ziston'),
	 'post_types' => array( 'job_listing' ),
	 'fields' => array(
		array(
				'id'      => '_lt_additional_info',
				'name'    => 'Additional Info',
				'type'    => 'text_list',
				'clone' => true,
				'options' => array(
					esc_html__( 'Program Guide', 'ziston' ) => 'Text',
					esc_html__( 'Yes', 'ziston' )           => 'Value'
				),
			),
	 	)
  );

   if(ziston_get_option('lt_business_hours', 'enable') == 'enable'){
		$meta_boxes[] = array(
			'id'    => 'metaboxes_listings_business_hours',
			'title' => esc_html__('Business Hours Settings', 'ziston'),
			'pages' => array( 'job_listing' ),
			'fields' => array(

				// Monday
				array(
					'name' => esc_html__('Monday Time Option', 'ziston'),
					'id'   => "_lt_mon_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'custom',
				),
				array(
					'id'      => '_lt_mon_time',
					'name'    => 'Monday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Tuesday
				array(
					'name' => esc_html__('Tuesday Time Option', 'ziston'),
					'id'   => "_lt_tue_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'custom',
				),
				array(
					'id'      => '_lt_tue_time',
					'name'    => 'Tuesday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Wednesday
				array(
					'name' => esc_html__('Wednesday Time Option', 'ziston'),
					'id'   => "_lt_wed_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'custom',
				),
				array(
					'id'      => '_lt_wed_time',
					'name'    => 'Wednesday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Thursday
				array(
					'name' => esc_html__('Thursday Time Option', 'ziston'),
					'id'   => "_lt_thu_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'custom',
				),
				array(
					'id'      => '_lt_thu_time',
					'name'    => 'Thursday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Friday
				array(
					'name' => esc_html__('Friday Time Option', 'ziston'),
					'id'   => "_lt_fri_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'custom',
				),
				array(
					'id'      => '_lt_fri_time',
					'name'    => 'Friday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Saturday
				array(
					'name' => esc_html__('Saturday Time Option', 'ziston'),
					'id'   => "_lt_sat_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'open_day',
				),
				array(
					'id'      => '_lt_sat_time',
					'name'    => 'Saturday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),

				//Sunday
				array(
					'name' => esc_html__('Sunday Time Option', 'ziston'),
					'id'   => "_lt_sun_time_option",
					'type' => 'radio',
					'options' => array(
						'custom'        => esc_html__('Custom', 'ziston'),
						'open_day'      => esc_html__('Open Day', 'ziston'),
						'close_day'     => esc_html__('Close Day', 'ziston'),
					),
					'std' => 'close_day',
				),
				array(
					'id'      => '_lt_sun_time',
					'name'    => 'Sunday',
					'type'    => 'fieldset_text',
					'options' => array(
						'0'             => 'From',
						'1'             => 'To'
					),
				),
			) 
		);
	}

	/* Sidebar Meta Box Page
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_listings_page',
		'title' => esc_html__('Listings Page Options', 'ziston'),
		'pages' => array('page'),
		'priority'   => 'high',
		'fields' => array(

			// SIDEBAR CONFIG
			array(
				'name' => esc_html__('Layout Listings Page', 'ziston'),
				'id'   => "{$prefix}lt_layout_page",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'ziston'),
				  'half_map'        	  	=> esc_html__('Half Map', 'ziston'),
				  'filters_left'       	=> esc_html__('Sidebar Filters Left', 'ziston'),
				  'filters_right'       => esc_html__('Sidebar Filters Right', 'ziston'),
				  'filters_hidden'		=> esc_html__('Hidden Filters', 'ziston'),
				  'full_map'				=> esc_html__( 'Full Map', 'ziston' )
				),
				'class'	=> 'setting-lt_layout_page',
				'multiple' => false,
			),

			array(
				'name' => esc_html__('Show Map Top Page', 'ziston'),
				'id'   => "{$prefix}lt_show_map_top",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'ziston'),
				  'disable'             => esc_html__('Disable Map', 'ziston'),
				  'container'           => esc_html__('Container', 'ziston'),
				  'contain-fw'          => esc_html__('Full Width', 'ziston'),
				),
				'class'	=> 'setting-lt_show_map_top',
				'default'  => 'container',
				'multiple' => false,
			),

			array(
				'name' => esc_html__('Layout Item', 'ziston'),
				'id'   => "{$prefix}lt_layout_item",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'ziston'),
				  'item-grid-1'        	=> esc_html__('Grid', 'ziston'),
				  'item-list'       		=> esc_html__('List', 'ziston'),
				),
				'multiple' => false,
			),

			array(
				'name' 		=> esc_html__('Per Page', 'ziston'),
				'id'   		=> "{$prefix}lt_per_page",
				'type' 		=> 'number',
				'std'			=> 12
			),
			
			array(
				'name' => esc_html__('Show Rating', 'ziston'),
				'id'   => "{$prefix}lt_show_rating",
				'type' => 'select',
				'options' => array(
				  	''      		=> esc_html__( 'Hidden', 'ziston' ),
					'star'  		=> esc_html__( 'Star', 'ziston' ),
					'number'  	=> esc_html__( 'Number', 'ziston' )
				),
			),

			array(
				'name' => esc_html__('Show Tagline', 'ziston'),
				'id'   => "{$prefix}lt_show_tagline",
				'type' => 'select',
				'options' => array(
				  	'yes'     	=> esc_html__( 'Yes', 'ziston' ),
					'no'  		=> esc_html__( 'no', 'ziston' )
				),
			),
			
			array(
				'name' => esc_html__('Grid columns large screen', 'ziston'),
				'id'   => "{$prefix}lt_grid_columns_lg",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'ziston'),
				  '1'               	=> esc_html__('1 Column', 'ziston'),
				  '2'                => esc_html__('2 Columns', 'ziston'),
				  '3'        	  		=> esc_html__('3 Columns', 'ziston'),
				  '4'       			=> esc_html__('4 Columns', 'ziston'),
				  '5'       			=> esc_html__('5 Columns', 'ziston'),
				  '6'       			=> esc_html__('6 Columns', 'ziston'),
				),
				'std' => '3',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns medium screen', 'ziston'),
				'id'   => "{$prefix}lt_grid_columns_md",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'ziston'),
				  '1'               	=> esc_html__('1 Column', 'ziston'),
				  '2'                => esc_html__('2 Columns', 'ziston'),
				  '3'        	  		=> esc_html__('3 Columns', 'ziston'),
				  '4'       			=> esc_html__('4 Columns', 'ziston'),
				  '5'       			=> esc_html__('5 Columns', 'ziston'),
				  '6'       			=> esc_html__('6 Columns', 'ziston'),
				),
				'std' => '3',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns small screen', 'ziston'),
				'id'   => "{$prefix}lt_grid_columns_sm",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'ziston'),
				  '1'               	=> esc_html__('1 Column', 'ziston'),
				  '2'                => esc_html__('2 Columns', 'ziston'),
				  '3'        	  		=> esc_html__('3 Columns', 'ziston'),
				  '4'       			=> esc_html__('4 Columns', 'ziston'),
				  '5'       			=> esc_html__('5 Columns', 'ziston'),
				  '6'       			=> esc_html__('6 Columns', 'ziston'),
				),
				'std' => '2',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns extra small screen', 'ziston'),
				'id'   => "{$prefix}lt_grid_columns_xs",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'ziston'),
				  '1'               	=> esc_html__('1 Column', 'ziston'),
				  '2'                => esc_html__('2 Columns', 'ziston'),
				  '3'        	  		=> esc_html__('3 Columns', 'ziston'),
				  '4'       			=> esc_html__('4 Columns', 'ziston'),
				  '5'       			=> esc_html__('5 Columns', 'ziston'),
				  '6'       			=> esc_html__('6 Columns', 'ziston'),
				),
				'std' => '1',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Pagination Style', 'ziston'), 
				'id'   => "{$prefix}lt_pagination_style",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'ziston'),
				  'load_more'        => esc_html__('Load More', 'ziston'),
				  'paginate'         => esc_html__('Paginate', 'ziston')
				),
				'multiple' => false,
			),
		)
	);

  
	return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'ziston_register_meta_boxes' , 99 );

