<?php
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Breadcrumb Options', 'ziston'),
	'desc' => '',
	'icon' => 'el-icon-compass',
	'fields' => array(
		array(
		  	'id' => 'breadcrumb_show_title',
		  	'type' => 'button_set',
		  	'title' => esc_html__('Breadcrumb Display Title Page', 'ziston'),
		  	'desc' => '',
		  	'options' => array(
				'show' => esc_html__('Enable', 'ziston'),
				'hide' => esc_html__('Disable', 'ziston')
			),
		  	'default' => 1
		),
		array(
		  	'id' => 'breadcrumb_show_links',
		  	'type' => 'button_set',
		  	'title' => esc_html__('Breadcrumb Display Links', 'ziston'),
		  	'desc' => '',
		  	'options' => array(
				'show' => esc_html__('Enable', 'ziston'),
				'hide' => esc_html__('Disable', 'ziston')
			),
		  	'default' => 1
		),
		array(
		  	'id'        => 'breadcrumb_padding_top',
		  	'type'      => 'slider',
		  	'title'     => esc_html__( 'Breadcrumb Padding Top', 'ziston' ),
		  	'default'   => 180,
		  	'min'       => 50,
		  	'max'       => 500,
		  	'step'      => 1,
		  	'display_value' => 'text',
		),
		array(
		  	'id'        => 'breadcrumb_padding_bottom',
		  	'type'      => 'slider',
		  	'title'     => esc_html__( 'Breadcrumb Padding Top', 'ziston' ),
		  	'default'   => 135,
		  	'min'       => 50,
		  	'max'       => 500,
		  	'step'      => 1,
		  	'display_value' => 'text',
		),
		array(
		  	'id' => 'breadcrumb_background_color',
		  	'type' => 'color',
		  	'title' => esc_html__('Background Overlay Color', 'ziston'),
		  	'default' => '#11161F'
		),
		array(
		  	'id'        => 'breadcrumb_background_opacity',
		  	'type'      => 'slider',
		  	'title'     => esc_html__( 'Breadcrumb Ovelay Color Opacity', 'ziston' ),
		  	'default'   => 50,
		  	'min'       => 0,
		  	'max'       => 100,
		  	'step'      => 1,
		  	'display_value' => 'text'
		),
		array(
		  	'id' => 'breadcrumb_image',
		  	'type' => 'button_set',
		  	'title' => esc_html__('Enable Breadcrumb Image', 'ziston'),
		  	'desc' => '',
		  	'options' => array(1 => 'Enable', 0 => 'Disable'),
		  	'default' => 1
		),
		array(
		  	'id' => 'breadcrumb_background_image',
		  	'type' => 'media',
		  	'url' => true,
		  	'title' => esc_html__('Breadcrumb Background Image', 'ziston'),
		  	'default' => '',
		  	'required'  => array( 'breadcrumb_image', '=', 1 )
		),
		array(
		  	'id'    => 'breadcrumb_text_stype',
		  	'type'    => 'select',
		  	'title'   => esc_html__( 'Breadcrumb Text Stype', 'ziston' ),
		  	'options' => 
		  	array(
			 	'text-light'     => esc_html__('Light', 'ziston'),
			 	'text-dark'      => esc_html__('Dark', 'ziston')
		  	),
		  	'default' => 'text-light'
		),
		array(
		  	'id'    => 'breadcrumb_text_align',
		  	'type'    => 'select',
		  	'title'   => esc_html__( 'Breadcrumb Text Align', 'ziston' ),
		  	'options' => 
		  	array(
			 	'text-left'      => esc_html__('Left', 'ziston'),
			 	'text-center'    => esc_html__('Center', 'ziston'),
			 	'text-right'     => esc_html__('Right', 'ziston')
		  	),
		  	'default' => 'text-center'
		)
	)
));