<?php
  function ziston_get_all_menus(){
     $menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) ); 
     $results = array();
     foreach ($menus as $key => $menu) {
      $results[$menu->slug] = $menu->name;
     }
     return $results;
  }

  Redux::setSection( $opt_name, array(
    'title' => esc_html__('Header Options', 'ziston'),
    'desc' => '',
    'icon' => 'el-icon-compass',
    'fields' => array(
      array(
        'id' => 'header_layout',
        'type' => 'select',
        'title' => esc_html__('Header Layout', 'ziston'),
        'subtitle' => esc_html__('Select a header layout option from the examples.', 'ziston'),
        'desc' => '',
        'options' => ziston_get_headers(false),
        'default' => 'header-1'
      ),
      array(
        'id' => 'header_logo', 
        'type' => 'media',
        'url' => true,
        'title' => esc_html__('Logo in header default', 'ziston'), 
        'default' => ''
      ),  
      array(
        'id'  => 'header_mobile_settings',
        'type'  => 'info',
        'raw' => '<h3 style="margin: 0;">' . esc_html__( 'Header Mobile settings', 'ziston' ) . '</h3>'
      ),
      array(
        'id' => 'hm_logo',
        'type' => 'media',
        'url' => true,
        'title' => esc_html__('Header Mobile | Logo', 'ziston'),
        'default' => ''
      ),
      array(
        'id' => 'hm_show_user',
        'type' => 'button_set',
        'title' => esc_html__('Show User', 'ziston'),
        'desc' => '',
        'options' => array('yes' => 'Enable', 'no' => 'Disable'),
        'default' => 'yes'
      ),
      array(
        'id' => 'hm_my_account_menu',
        'type' => 'select',
        'title' => esc_html__('Header Mobile | My Account Menu', 'ziston'),
        'options' => ziston_get_all_menus(),
        'default' => 'my-account'
      ),
    )
  ));