<?php
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Listings Filter', 'ziston'),
	'icon' => 'el-icon-wrench',
	'fields' => array(
		array(
         'id'        => 'lt_filter_sort_fields',
         'type'      => 'sorter',
         'title'     => esc_html__( 'Filter Fields', 'ziston' ),
         'options'   => array(
            'enabled' => array(
            	'keywords' 		=> esc_html__('Keywords', 'ziston'),
            	'category' 		=> esc_html__('Category', 'ziston'),
               'regions'      => esc_html__('Regions', 'ziston'),
            	'types' 			=> esc_html__('Types', 'ziston'),
            	'location' 		=> esc_html__('Location', 'ziston'),
            	'distance' 		=> esc_html__('Distance', 'ziston'),
            	'price_range' 	=> esc_html__('Price Range', 'ziston'),
            	'amenities' 	=> esc_html__('Amenities', 'ziston')
            ),
            'disabled' => array()
         )
      ),
		array(
	      'id'        => 'lt_distance',
	      'type'      => 'slider',
	      'title'     => esc_html__( 'Radius Around Distance Default', 'ziston' ),
	      'default'   => 60,
	      'min'       => 5,
	      'max'       => 500,
	      'step'      => 1,
	      'display_value' => 'text',
	   ),
	   array(
		  	'id'         => 'lt_distance_unit',
		  	'type'       => 'select',
		  	'title'      => esc_html__('Distance Unit', 'ziston'),
		  	'options'    => array(
			  	'km' => esc_html__('Kilometre', 'ziston'),
			  	'miles' => esc_html__('Miles', 'ziston'),
			),
		  	'default'  => 'km'
		),
		array(
        	'id' => 'lt_show_amenities',
        	'type' => 'button_set',
        	'title' => esc_html__('Show Amenities', 'ziston'),
        	'desc' => '',
        	'options' => array(
        		'show' => esc_html__('Show', 'ziston'),
        		'hide' => esc_html__('Hide', 'ziston')
        	),
        	'default' => 'hide'
      ),
	)
));