<?php
	Redux::setSection( $opt_name, array(
		'title' => esc_html__('Listings Map', 'ziston'),
		'desc' => '',
		'icon' => 'el-icon-wrench',
		'fields' => array(
			array(
				'id'        => 'lt_map_source',
				'type'      => 'select',
				'title'     => esc_html__('Map Source', 'ziston'),
				'desc'      => '',
				'options'   => array(
					'mapbox'         => 'Mapbox (mapbox.com)',
					'google'         => 'Google (google.com)',
					'openstreetmap'  => 'Open Street Map'
				),
				'default' => 'mapbox'
			),
			array(
			  'id'         => 'lt_default_latitude',
			  'type'       => 'text',
			  'title'      => esc_html__('Default Latitude', 'ziston'),
			  'default'    => '40.6783499',
			),
			array(
			  'id'         => 'lt_default_longitude',
			  'type'       => 'text',
			  'title'      => esc_html__('Default Longitude', 'ziston'),
			  'default'       => '-73.9495439',
			),
			array(
				'id'        => 'lt_map_zoom',
				'type'      => 'slider',
				'title'     => esc_html__('Map Zoom', 'ziston'),
				'default'   => 14,
				'min'       => 2,
				'max'       => 18,
				'step'      => 1,
				'display_value' => 'text'
			),
			array(
			  	'id'         => 'listing_goolge_info',
			  	'type'       => 'info',
			  	'icon'       => true,
			  	'raw'        => '<h3 style="margin: 0;">' . esc_html__( 'Google Map Settings', 'ziston' ) . '</h3>',
			  	'required'  	=> array( 'lt_map_source', '=', 'google' )
			),
			array(
           	'id' => 'map_api_key',
           	'type' => 'text',
           	'title' => esc_html__('Google Map API key', 'ziston'),
           	'required'  	=> array( 'lt_map_source', '=', 'google' )
         ),
			array(
			  	'id'         => 'lt_google_map_style',
			  	'type'       => 'textarea',
			  	'title'      => esc_html__('Google Map Style', 'ziston'),
			  	'desc'       => wp_kses(__('<a href="//snazzymaps.com/">Get custom style</a> and paste it below. If there is nothing added, we will fallback to the Google Maps service.', 'ziston'), false),
			  	'required'  	=> array( 'lt_map_source', '=', 'google' )
			),
			array(
			  	'id'         => 'listing_mapbox_info',
			  	'type'       => 'info',
			  	'icon'       => true,
			  	'raw'        => '<h3 style="margin: 0;">' . esc_html__( 'Map Box Settings', 'ziston' ) . '</h3>',
			  	'required'  	=> array( 'lt_map_source', '=', 'mapbox' )
			),
			array(
			  	'id'         => 'lt_mapbox_token',
			  	'type'       => 'text',
			  	'title'      => esc_html__('Mapbox Access Token', 'ziston'),
			  	'desc'       => wp_kses(__('Access Token key of <a href="https://www.mapbox.com/">Mapbox</a> service.', 'ziston'), false),
			  	'required'  	=> array( 'lt_map_source', '=', 'mapbox' )
			),
			array(
			  	'id'         => 'lt_mapbox_style',
			  	'type'       => 'select',
			  	'title'      => esc_html__('Mapbox style', 'ziston'),
			  	'options'    => array(
				  	'streets-v8' => 'streets-v8',
				  	'streets-v9' => 'streets-v9',
				  	'streets-v10' => 'streets-v10',
				  	'streets-v11' => 'streets-v11'
				),
			  	'default'  => 'streets-v11',
			  	'required'  	=> array( 'lt_map_source', '=', 'mapbox' )
			),
		)
	));