<?php
   $post_id = $job->ID;
   $tagline = get_post_meta( $post_id, '_lt_tagline', true );
   $class_content = 'listing-content without_thumbnail';
   $rterms =  wp_get_post_terms( $post_id, 'job_listing_region' );
   $city = $country = false;
   if ( !empty($rterms) ) {
      foreach ($rterms as $term) {
         if($term->parent == 0){
            $country = $term;
         }else{
            $city = $term;
         }
      }
   }

   $link_region_country = $link_region_city = '';
   if( isset($regions['city']) && $regions['city'] ){
      $link_region_city = get_term_link($regions['city'], 'job_listing_region');
   }
   if(isset($regions['country']) && $regions['country']){
      $link_region_country = get_term_link($regions['country'], 'job_listing_region');
   }
?>
<div class="my-listing-item job_listing listing-block listing-list">
   <div class="listing-content-inner">
      <?php if( has_post_thumbnail($post_id) ){ ?>
         <div class="listing-image">
            <?php $class_content = 'listing-content with_thumbnail'; ?>
            <?php echo get_the_post_thumbnail( $post_id, 'medium', array( 'alt' => get_the_title($post_id) ) ); ?>
         </div>
      <?php } ?>

      <div class="<?php echo esc_attr($class_content) ?>">
         <div class="listing-status <?php echo esc_attr($job->post_status); ?>">
            <?php 
               $status = get_post_status($job->ID); 
               if($status == 'publish') $status = esc_html__('published', 'ziston');
               echo esc_html($status);
            ?>
         </div>
         <h3 class="title"><a href="<?php the_permalink($post_id) ?>"><?php echo esc_html($job->post_title); ?></a></h3>

         <?php if( !empty($tagline) ){ ?>
            <div class="listing-tagline"><?php echo esc_html($tagline) ?></div>
         <?php } ?>  

         <div class="listing-meta">
            <?php if($city || $country){ ?>
               <div class="location">          
                  <i class="icon fas fa-map-marker-alt"></i>
                  <span class="regions">
                     <?php if( $city ){ ?>
                        <a href="<?php echo esc_url(get_term_link($city->term_id, 'job_listing_region')) ?>"><?php echo esc_html($city->name) ?></a>
                     <?php } ?>
                     <?php if( $country ){ ?>
                        <span>,&nbsp;</span><a href="<?php echo esc_url(get_term_link($country->term_id, 'job_listing_region')) ?>"><?php echo esc_html($country->name) ?></a>
                     <?php } ?>
                  </span>
               </div>
            <?php } ?>   
         </div>    

         <div class="content-footer clearfix">
            <div class="lt_block-category">
               <?php Ziston_Lising_Theme::instance()->html_categories($post_id, true); ?>
            </div>

            <?php 
               $review_avg = get_post_meta( $post_id, 'lt_reviews_average', true ); 
               if( !empty($review_avg) ){
                  $review_avg = round( $review_avg, 1 );
                  echo Ziston_Listing_Comment::instance()->show_star_by_avg($review_avg, $review_avg); 
               }
            ?>
         </div>
      </div> 

      <div class="listing-action clearfix">
         <div class="action-left">
             <div class="listing-date-post listing-meta-item">
               <span class="label"><?php echo esc_html__( 'Date Post:', 'ziston' ) ?></span>
               <span><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $job->post_date ) ) ); ?></span>
            </div>
            <div class="listing-expires listing-meta-item">
               <span class="label"><?php echo esc_html__( 'Date Expires:', 'ziston' ) ?></span>
               <span><?php echo esc_html( $job->_job_expires ? date_i18n( get_option( 'date_format' ), strtotime( $job->_job_expires ) ) : '&ndash;' ); ?></span>
            </div>
         </div>
         <div class="action-right">   
            <div class="job-dashboard-actions">
               <?php
                  $actions = [];

                  switch ( $job->post_status ) {
                     case 'publish' :
                        if ( WP_Job_Manager_Post_Types::job_is_editable( $job->ID ) ) {
                           $actions[ 'edit' ] = [ 'label' => __( 'Edit', 'ziston' ), 'nonce' => false ];
                        }
                        $actions['duplicate'] = [ 'label' => __( 'Duplicate', 'ziston' ), 'nonce' => true ];
                        break;
                     case 'expired' :
                        if ( job_manager_get_permalink( 'submit_job_form' ) ) {
                           $actions['relist'] = [ 'label' => __( 'Relist', 'ziston' ), 'nonce' => true ];
                        }
                        break;
                     case 'pending_payment' :
                     case 'pending' :
                        if ( WP_Job_Manager_Post_Types::job_is_editable( $job->ID ) ) {
                           $actions['edit'] = [ 'label' => __( 'Edit', 'ziston' ), 'nonce' => false ];
                        }
                     break;
                     case 'draft' :
                     case 'preview' :
                        $actions['continue'] = [ 'label' => __( 'Continue Submission', 'ziston' ), 'nonce' => true ];
                        break;
                  }

                  $actions['delete'] = [ 'label' => __( 'Delete', 'ziston' ), 'nonce' => true ];
                  $actions           = apply_filters( 'job_manager_my_job_actions', $actions, $job );

                  foreach ( $actions as $action => $value ) {
                     $action_url = add_query_arg( [ 'action' => $action, 'job_id' => $job->ID ] );
                     if ( $value['nonce'] ) {
                        $action_url = wp_nonce_url( $action_url, 'job_manager_my_job_actions' );
                     }
                     echo '<a href="' . esc_url( $action_url ) . '" class="btn-gray-icon job-dashboard-action-' . esc_attr( $action ) . '">' . esc_html( $value['label'] ) . '</a>';
                  }

                  if( class_exists('LT_Package_Function') ){
                     if($job->post_status == 'publish' || $job->post_status == 'expired' || $job->post_status == 'pending'){
                        echo '<a href="#" data-id="' . esc_attr($job->ID) . '" data-toggle="modal" data-target="#popup-ajax-package" class="btn-gray-icon load-lt-package">' . esc_html('Apply Package') . '</a>';
                     }
                  }

               ?>
            </div>
         </div>   
      </div>

   </div>
</div>