<?php
   if( !class_exists('Gavias_Ziston_Themer') ){ return; }
   
   $terms = wp_get_post_terms( get_the_ID(), 'job_listing_amenity' );
?>

<?php if ( !empty($terms) ): ?>
   <div class="listing-amenities listing-single-block">
      <h3 class="block-title"><?php echo esc_html__( 'Listing Amenities',  'ziston') ?></h3>
      <div class="block-content">
         <ul class="amenities-list clearfix">
            <?php foreach ($terms as $term) { ?>
               <?php 
                  $has_icon = 'without-icon'; 
                  $icon_html = '<i class="icon flaticon-star-2"></i>';
                  $term_id = $term->term_id;
                  $icon_style = get_term_meta($term_id, 'gva_term_icon_type', true);

                  if($icon_style == 'icon_type_font'){
                     $icon = get_term_meta($term_id, 'gva_term_icon_font', true);
                     if( !empty($icon) ){
                        $has_icon = 'with-icon';
                        $icon_html = '<i class="icon icon-font ' . esc_attr($icon) . '"></i>';
                     }
                  }elseif($icon_style == 'icon_type_image'){
                     $icon = get_term_meta($term_id, 'gva_term_icon_image', true);
                     $icon_attach = wp_get_attachment_image_src($icon, 'full');
                     if( isset($icon_attach[0]) && $icon_attach[0] ){
                        $has_icon = 'with-icon';
                        $icon_html = '<img class="icon icon-img" src="'.esc_url($icon_attach[0]) . '" alt="' . esc_attr($term->name) . '" />';
                     }
                  }
               ?>

               <li class="amenity-item <?php echo esc_attr($has_icon) ?>">
                  <span class="icon-box"><?php echo trim($icon_html) ?></span>
                  <span class="name"><?php echo esc_html($term->name) ?></span>
               </li>
            <?php } ?>
         </ul>
      </div>   
   </div>
<?php endif; ?>