<?php
   $lt_email = get_post_meta( get_the_ID(), '_lt_email', true );
   $class = '';
   if( empty($lt_email) ){
      $lt_email = get_the_author_meta( 'email' );
      $class = 'email-author';
   }
?>

<?php if($lt_email): ?>
	<div class="single_lising-contact single_listing-block <?php echo esc_attr($class) ?>">
		<h3 class="title"><?php echo esc_html__( 'Contact Business', 'ziston' ) ?></h3>
		<div class="box-content">
         <div class="lt-email">
            <a href="mailto:<?php echo esc_attr($lt_email) ?>"><i class="icon fas fa-envelope"></i><?php echo esc_html($lt_email) ?></a>
         </div>
			<?php 
            $contact_form_id = ziston_get_option('lt_single_contact_form', 1415);
            echo do_shortcode( '[contact-form-7 id="' . esc_attr($contact_form_id) . '" author_email="' . esc_attr($lt_email) . '"]' ); 
         ?>
		</div>   
	</div>
<?php endif; ?> 
