<?php
   $post_id = get_the_ID();
   $cats = get_the_terms($post_id, 'job_listing_category');
   $tagline = get_post_meta( get_the_ID(), '_lt_tagline', true );
   $cats_html = '';
   $i = 0;
   if(!empty($cats) && !is_wp_error($cats)){
      foreach((array)$cats as $cat){
         $i++;
         $term_id = $cat->term_id;
         $has_icon = false;
         $cat_color = get_term_meta($term_id, 'gva_term_color', true);
         $cat_color_style = $cat_color ? ' style="color:' . $cat_color . ';"' : '';
         $cats_html .= '<a class="cat-item" href="' . get_category_link( $term_id ) . '">';
            $cats_html .= '<span class="cat-name" ' . $cat_color_style . '>' . $cat->name . '</span>';
         $cats_html .= '</a>';   
         if( $i < count($cats) ) $cats_html .= '<span>&nbsp;-&nbsp;</span>';

      }
   }
?>

<div class="lt-content-top-left">
   
   <div class="content-left">
      <?php $logo = ziston_image_attach(get_the_ID(), '_lt_logo_image', true); ?>
      <?php if( isset($logo[0]) && $logo[0] ){ ?>
         <div class="lt-logo">
            <img src="<?php echo esc_url($logo[0]) ?>" alt="<?php echo the_title_attribute() ?>" />
         </div>
      <?php } ?>
   </div>

   <div class="content-right">
      <div class="lt-category">
         <?php echo wp_kses_post($cats_html) ?>
      </div>

      <h1 class="title">
         <?php echo get_the_title() ?>
      </h1>

      <?php if($tagline){ ?>
         <div class="tagline"><?php echo esc_html($tagline) ?></div>
      <?php } ?>   

      <?php if( class_exists('Ziston_Listing_Comment') ): ?>
          <!-- Reviews Addon -->
         <?php 
            $count_reviews = Ziston_Listing_Comment::instance()->total_reviews(get_the_ID(), 0, true);
            $review_avg = get_post_meta( get_the_ID(), 'lt_reviews_average', true );
            
         ?>

         <?php if( !empty($review_avg) ){ ?>
            <!-- Reviews Addon -->
               <div class="lt-top-reviews">
                  <div class="review-avg-content">
                     <div class="review-star">
                        <?php echo Ziston_Listing_Comment::instance()->show_star_by_avg( round($review_avg, 2) ); ?>
                        <span class="review-text">(<?php echo esc_html($count_reviews) ?>)</span>  
                     </div>
                      
                  </div>
               </div>
            <!-- End Reviews Addon -->
         <?php } ?>   

      <?php endif; ?>
   </div>   

</div>

