<?php 
   $phone = get_post_meta(get_the_ID(), '_lt_phone', true);
?>
<div class="content-top-right">
   <div class="listing-action clearfix">
      <?php if($phone){ ?>
         <div class="listing-phone">
            <a href="tel:<?php echo esc_attr($phone) ?>" class="btn-gray-icon bg-theme"><i class="fas fa-phone-volume"></i><?php echo esc_html($phone) ?></a>
         </div>
      <?php } ?> 
      <div class="listing-review">
         <a href="#lt-comment-review" class="btn-gray-icon scroll-link"><i class="fas fa-comments"></i><?php echo esc_html__('Review', 'ziston') ?></a>
      </div>
      <div class="listing-share">
         <a href="#" class="btn-gray-icon btn-control-share"><i class="fas fa-share"></i><?php echo esc_html__('Share', 'ziston') ?></a>
         <div class="lt-share-content">
            <?php do_action( 'ziston_share' ); ?>
         </div>
      </div>
   </div>

   <?php if( class_exists('Ziston_Lising_Theme') ){ ?>
      <div class="listing-price-wishlist clearfix">
         <?php Ziston_Lising_Theme::instance()->get_price_range(get_the_ID(), '<div class="lt-price-range"><span class="price-label">' . esc_html__( "Price", 'ziston') . '</span>', '</div>', true) ?>

         <div class="wishlist">
            <?php 
               if( class_exists('Ziston_Addons_Wishlist_Ajax') ){
                  Ziston_Addons_Wishlist_Ajax::instance()->html_icon( get_the_ID(), esc_html__( 'Add to Wishlist', 'ziston' ) );
               }
            ?>
         </div>
      </div>
   <?php } ?>   

</div>