<?php
   wp_enqueue_script('map-api');
   wp_enqueue_script('leaflet');
   wp_enqueue_script('leaflet-markercluster');
   wp_enqueue_script('leaflet-googlemutant');
   wp_enqueue_script('geocoder-control');
   wp_enqueue_script('ziston-listing'); 
  
   wp_enqueue_style('leaflet');
   wp_enqueue_style('marker-cluster');
   wp_enqueue_style('marker-cluster-default');
   wp_enqueue_style('geocoder-control');

   $post_id = get_the_ID();
   $lat = get_post_meta($post_id, '_lt_map_latitude', true);
   $lng = get_post_meta($post_id, '_lt_map_longitude', true);

   $map_options = ziston_map_options();
   $without_map = false;
   if( !empty($lat) && !empty($lng) ){
      $map_options['mode'] = 'single';
      $map_options['latitude'] = $lat;
      $map_options['longitude'] = $lng;
      wp_localize_script( 'ziston-listing', 'ziston_map_options', $map_options );
   }else{
      $map_options['mode'] = 'without_map';
      $without_map = true;
   }

   $info = ziston_listing_info($post_id);
   $socials = ziston_listing_social($post_id);
   $hidden = 'no_hidden';
   if(empty($info['phone']) && empty($info['address']) && empty($info['email']) && empty($info['website']) 
      && empty($socials['facebook']) && empty($socials['linkedin']) && empty($socials['twitter']) && empty($socials['instagram'])
      && empty($socials['tumbler']) && empty($socials['pinterest'])  && empty($socials['vimeo']) && empty($socials['youtube']) 
   ){
      $hidden = 'hidden';
   }
?>

<div class="single_listing-map">
   <?php if( !$without_map && ziston_get_option('lt_single_disable_map', 'no') == 'no' ){ ?>
      <div id="lt-listing--map" class="lt-listing--map lt-map-main"></div>
   <?php } ?>

   <div class="single_listing-information <?php echo esc_attr($hidden) ?>">
      <?php if( !empty($info['phone']) ){ ?> 
         <div class="lt-phone item">
            <a href="tel:<?php echo esc_attr($info['phone']) ?>"><i class="fas fa-phone-alt"></i><?php echo esc_html($info['phone']) ?></a>
         </div>
      <?php } ?>
      <?php if( !empty($info['address']) ){ ?>
         <div class="lt-address item"><i class="fas fa-map-marker-alt"></i><?php echo esc_html($info['address']) ?></div>
      <?php } ?> 
      <?php if( !empty($info['email']) ){ ?>
         <div class="lt-email item">
            <a href="mailto:<?php echo esc_attr($info['email']) ?>" target="_blank"><i class="fas fa-envelope"></i></i><?php echo esc_html($info['email']) ?></a>
         </div>
      <?php } ?> 
      <?php if( !empty($info['website']) ){ ?>
         <div class="lt-website item">
            <a href="<?php echo esc_url($info['website']) ?>" target="_blank"><i class="fas fa-globe-asia"></i>
               <span><?php echo esc_html($info['website']) ?></span>
            </a>
         </div>
      <?php } ?> 

      <div class="single_listing-social">
         <?php if( !empty($socials['facebook']) ){ ?>
            <a href="<?php echo esc_url($socials['facebook']) ?>" target="_blank" ><i class="fab fa-facebook-square"></i></a>
         <?php } ?>
         <?php if( !empty($socials['linkedin']) ){ ?>
            <a href="<?php echo esc_url($socials['linkedin']) ?>" target="_blank" ><i class="fa fa-linkedin"></i></a>
         <?php } ?>
         <?php if( !empty($socials['twitter']) ){ ?>
            <a href="<?php echo esc_url($socials['twitter']) ?>" target="_blank" ><i class="fa fa-twitter"></i></a>
         <?php } ?>
         <?php if( !empty($socials['instagram']) ){ ?>
            <a href="<?php echo esc_url($socials['instagram']) ?>" target="_blank" ><i class="fa fa-instagram"></i></a>
         <?php } ?>
         <?php if( !empty($socials['tumbler']) ){ ?>
            <a href="<?php echo esc_url($socials['tumbler']) ?>" target="_blank" ><i class="fab fa-tumblr"></i></a>
         <?php } ?>
         <?php if( !empty($socials['pinterest']) ){ ?>
            <a href="<?php echo esc_url($socials['pinterest']) ?>" target="_blank" ><i class="fa fa-pinterest"></i></a>
         <?php } ?>
         <?php if( !empty($socials['vimeo']) ){ ?>
            <a href="<?php echo esc_url($socials['vimeo']) ?>" target="_blank" ><i class="fa fa-vimeo"></i></a>
         <?php } ?>
         <?php if( !empty($socials['youtube']) ){ ?>
            <a href="<?php echo esc_url($socials['youtube']) ?>" target="_blank" ><i class="fa fa-youtube"></i></a>
         <?php } ?>
      </div>

   </div>
</div>
