<?php
if( !class_exists('Ziston_Lising_Theme') ){ return ;}
if(ziston_get_option('lt_business_hours', 'enable') != 'enable'){ return;}
$post_id = get_the_ID();
$open_hours =  Ziston_Lising_Theme::instance()->get_business_hours($post_id);
$open_hours['mon']['title'] = esc_html__( 'Monday', 'ziston' );
$open_hours['tue']['title'] = esc_html__( 'Tuesday', 'ziston' );
$open_hours['wed']['title'] = esc_html__( 'Wednesday', 'ziston' );
$open_hours['thu']['title'] = esc_html__( 'Thursday', 'ziston' );
$open_hours['fri']['title'] = esc_html__( 'Friday', 'ziston' );
$open_hours['sat']['title'] = esc_html__( 'Saturday', 'ziston' );
$open_hours['sun']['title'] = esc_html__( 'Sunday', 'ziston' );
//print "<pre>"; print_r($open_hours);
$days = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
$check_open = Ziston_Lising_Theme::instance()->check_open($post_id);
?>


<div class="single_listing-open-hours single_listing-block hidden">
	
	<h3 class="title"><?php echo esc_html__( 'Opening Hours', 'ziston' ) ?></h3>

	<div class="block-content">
		<?php if(!empty($check_open['check']) && $check_open['check'] != 'hidden'){ ?>
			<div class="item today clearfix">
				<label><?php echo esc_html__('Today', 'ziston') ?></label>
				<div class="value text-theme text-right">
					<?php 
						if($check_open['check'] == 'open'){ 
							echo esc_html__('Open Now', 'ziston');
						}elseif($check_open['check'] == 'closed'){
							echo esc_html__( 'Closed Now', 'ziston' );
						}
					?>   
				</div>
			</div>
		<?php } ?>

		<div class="lt-open_hours-day">
			<?php foreach ( $days as $day ): ?>
			
				<?php if($open_hours[$day]['option'] == 'open_day' || $open_hours[$day]['option'] == 'close_day'){ ?>
					<div class="item clearfix">
					  <label><?php echo esc_html($open_hours[$day]['title']) ?></label>
					  <div class="values">
							<?php if($open_hours[$day]['option'] == 'open_day'){ ?>
								<span><?php echo esc_html__('Open', 'ziston') ?></span>
							<?php } ?>

							<?php if($open_hours[$day]['option'] == 'close_day'){ ?>
								<span><?php echo esc_html__('Closed', 'ziston') ?></span>
							<?php } ?>
					  </div>
					</div>
				<?php } ?>

				<?php 
				if( $open_hours[$day]['option'] == 'custom'):
					$time = isset($open_hours[$day]['time']) ? $open_hours[$day]['time'] : array();
					if( isset($time[0]) && isset($time[1]) && $time[0] && $time[1] ){
				?>

					<div class="item clearfix">
						<label><?php echo esc_html($open_hours[$day]['title']) ?></label>
						<div class="values">
							<?php 
								$time_0 = date(get_option('time_format'), strtotime($time[0]));
								$time_1 = date(get_option('time_format'), strtotime($time[1]));
								echo ('<span class="value">' . preg_replace('/\s/', '', $time_0) . '&nbsp;-&nbsp;' . preg_replace('/\s/', '', $time_1)  . '</span>'); 
							?>
						</div>
					</div>

				<?php 
					}
				endif;
				?>   
			<?php endforeach; ?>   
		</div>


		<div class="current-time">
			<?php 
				$current_time = date_i18n(get_option('time_format') , false); 
				$current_date = date_i18n(get_option( 'date_format', false ));
			?>
			<span class="date"><?php echo esc_html($current_date) ?></span>
			<span class="time"><?php echo esc_html($current_time) ?></span>
		</div>

	</div>	

</div>