<?php if( class_exists('Ziston_Listing_Comment') && comments_open() ): ?>
<!-- Reviews Addon -->

<?php 
	wp_enqueue_script( 'waypoints' );
	$reviews = Ziston_Listing_Comment::instance()->results_reviews_by_post( get_the_ID() );
  
	$lt_results_reviews = get_post_meta( get_the_ID(), 'lt_results_reviews', true ); 
	
	//print '<pre>'; print_r($lt_results_reviews);

	$reviews_average = get_post_meta( get_the_ID(), 'lt_reviews_average', true ); 
	if($reviews_average) $reviews_average = round($reviews_average, 2);
	$cats_review = Ziston_Listing_Comment::instance()->categories_review();

   $results_reviews_by_cats = array();
   $results_reviews_by_del_cats = array();
   if( $lt_results_reviews && is_array($lt_results_reviews) ){
	   foreach ($lt_results_reviews as $key => $value){
	      if( isset($cats_review[$key]) && $value['avg']){
	         $results_reviews_by_cats[$key] = $value;
	      }else{
	         $results_reviews_by_del_cats[$key] = $value;
	      }
	   }
	}

?>
<?php if( $lt_results_reviews && is_array($lt_results_reviews) ): ?>
	<div class="listing-total-reviews">
		<div class="row no-margin">
		
			<div class="reviews-left col-3 no-padding align-self-center">
				<div class="content-inner">
					<div class="reviews-average">
						<?php echo esc_html( $reviews_average ) ?>
					</div>
					<div class="reviews-average-star">
						<?php echo Ziston_Listing_Comment::instance()->show_star_by_avg($reviews_average, ''); ?>
					</div>
				</div>   
			</div>

			<div class="reviews-right col-9 no-padding">
				<div class="content-inner">
					<div class="reviews-result">
						
						<?php foreach ($results_reviews_by_cats as $key => $value) : ?>
							<div class="result-item">
								<div class="review-value">
									<div class="review-progress-wrapper clearfix">
										<?php $volume = round($value['avg']/5, 2) * 100; ?>
									  	<div class="review__progress-label"><?php echo esc_html( $cats_review[$key] ); ?></div>
									  	<div class="review__progress">
										 	<div class="review__progress-bar" data-progress-max="<?php echo esc_attr($volume) ?>%">
												<?php if($volume > 80){ ?>
												  <span class="percentage percentage-left"><?php echo esc_attr( round($value['avg'], 1) ) ?></span>
												<?php }else{ ?>  
												  <span class="percentage"><?php echo esc_attr( round($value['avg'], 1) ) ?></span>
												<?php } ?>  
										 	</div>
									  	</div>  
									</div> 
								</div>
							</div>
						<?php endforeach; ?>

						<?php if( count($results_reviews_by_del_cats) > 0 ): ?>
							<?php foreach ($results_reviews_by_del_cats as $key => $value) : ?>
								<div class="result-item">
									<div class="review-value">
										<div class="review-progress-wrapper clearfix">
											<?php $volume = round($value['avg']/5, 2) * 100; ?>
										  	<div class="review__progress-label"><?php echo esc_html( $key ); ?></div>
										  	<div class="review__progress">
											 	<div class="review__progress-bar" data-progress-max="<?php echo esc_attr($volume) ?>%">
													<?php if($volume > 80){ ?>
													  <span class="percentage percentage-left"><?php echo esc_attr( round($value['avg'], 1) ) ?></span>
													<?php }else{ ?>  
													  <span class="percentage"><?php echo esc_attr( round($value['avg'], 1) ) ?></span>
													<?php } ?>  
											 	</div>
										  	</div>  
										</div> 
									</div>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>	

					</div>
				</div>   
			</div>

		</div>	
	</div>

<?php endif; ?>

<!-- End Reviews Addon -->
<?php endif; ?>